# create clock 
create_clock -name {Clk1} -period 10 [get_ports Clk1]
create_clock -name {clk2} -period 40 [get_ports clk2]
# Virtual clock definition for external devices connection to the FPGA
create_clock -name {VCLK1} -period 10
create_clock -name {VCLK2} -period 10
# Timing exceptions
set_clock_groups -group [get_clocks Clk1] -group [get_clocks clk2] -logically_exclusive
# Input and output delay constraints 
set_input_delay -clock [get_clocks VCLK1] -min 0.5 [get_ports {A[7] A[6] A[5] A[4] A[3] A[2] A[1] A[0] B[7] B[6] B[5] B[4] B[3] B[2] B[1] B[0] SEL En}]
set_input_delay -clock [get_clocks VCLK1] -max 1 [get_ports {A[7] A[6] A[5] A[4] A[3] A[2] A[1] A[0] B[7] B[6] B[5] B[4] B[3] B[2] B[1] B[0] SEL En}]
set_output_delay -clock [get_clocks VCLK2] 1 [get_ports {D[15] D[14] D[13] D[12] D[11] D[10] D[9] D[8] D[7] D[6] D[5] D[4] D[3] D[2] D[1] D[0]}]

set_max_delay -from [get_pins -hierarchical */*.FIFO16K_MODE_inst/FULL]  -to [get_pins -hierarchical {*/*.full_r.ff_inst/LSR}]   4
set_max_delay -from [get_pins -hierarchical */*.FIFO16K_MODE_inst/ALMOSTFULL]  -to [get_pins -hierarchical {*/*.afull_r.ff_inst/LSR}]  4