
/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Radiant Software (64-bit)
    2022.1.1.289.4
    Soft IP Version: 1.4.0
    2023 04 13 08:59:23
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
module FIFO_A2B (wr_clk_i, 
        rd_clk_i, 
        rst_i, 
        rp_rst_i, 
        wr_en_i, 
        rd_en_i, 
        wr_data_i, 
        full_o, 
        empty_o, 
        rd_data_o) ;
    input wr_clk_i ; 
    input rd_clk_i ; 
    input rst_i ; 
    input rp_rst_i ; 
    input wr_en_i ; 
    input rd_en_i ; 
    input [15:0] wr_data_i ; 
    output full_o ; 
    output empty_o ; 
    output [15:0] rd_data_o ; 
    FIFO_A2B_ipgen_lscc_fifo_dc #(.WADDR_DEPTH(1024),
            .WDATA_WIDTH(16),
            .RADDR_DEPTH(1024),
            .RDATA_WIDTH(16),
            .FIFO_CONTROLLER("HARD_IP"),
            .FORCE_FAST_CONTROLLER(1),
            .IMPLEMENTATION("EBR"),
            .WADDR_WIDTH(10),
            .RADDR_WIDTH(10),
            .REGMODE("reg"),
            .RESETMODE("async"),
            .ENABLE_ALMOST_FULL_FLAG("FALSE"),
            .ALMOST_FULL_ASSERTION("static-single"),
            .ALMOST_FULL_ASSERT_LVL(1023),
            .ALMOST_FULL_DEASSERT_LVL(1022),
            .ENABLE_ALMOST_EMPTY_FLAG("FALSE"),
            .ALMOST_EMPTY_ASSERTION("static-single"),
            .ALMOST_EMPTY_ASSERT_LVL(1),
            .ALMOST_EMPTY_DEASSERT_LVL(2),
            .ENABLE_DATA_COUNT_WR("FALSE"),
            .ENABLE_DATA_COUNT_RD("FALSE"),
            .FAMILY("LFCPNX")) lscc_fifo_dc_inst (.wr_clk_i(wr_clk_i), 
                .rd_clk_i(rd_clk_i), 
                .rst_i(rst_i), 
                .rp_rst_i(rp_rst_i), 
                .wr_en_i(wr_en_i), 
                .rd_en_i(rd_en_i), 
                .wr_data_i(wr_data_i[15:0]), 
                .almost_full_th_i(10'b1111111111), 
                .almost_full_clr_th_i(10'b1111111111), 
                .almost_empty_th_i(10'b1111111111), 
                .almost_empty_clr_th_i(10'b1111111111), 
                .full_o(full_o), 
                .empty_o(empty_o), 
                .almost_full_o(), 
                .almost_empty_o(), 
                .wr_data_cnt_o(), 
                .rd_data_cnt_o(), 
                .rd_data_o(rd_data_o[15:0]), 
                .one_err_det_o(), 
                .two_err_det_o()) ; 
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_fifo_dc.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module FIFO_A2B_ipgen_lscc_fifo_dc #(parameter IMPLEMENTATION = "EBR", 
        parameter WADDR_DEPTH = 512, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 36, 
        parameter RADDR_DEPTH = 512, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 36, 
        parameter REGMODE = "reg", 
        parameter RESETMODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter INIT_FILE = "none", 
        parameter INIT_MODE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 511, 
        parameter ALMOST_FULL_DEASSERT_LVL = 510, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 2, 
        parameter ECC_ENABLE = 0, 
        parameter ENABLE_DATA_COUNT_WR = "FALSE", 
        parameter ENABLE_DATA_COUNT_RD = "FALSE", 
        parameter FAMILY = "LIFCL", 
        parameter FIFO_CONTROLLER = "FABRIC", 
        parameter FORCE_FAST_CONTROLLER = 0) (
    //----------------------------
    // Inputs
    //----------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input rp_rst_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_th_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [WADDR_WIDTH:0] wr_data_cnt_o, 
    output [RADDR_WIDTH:0] rd_data_cnt_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    //--end_ports--
    localparam T_FAMILY = ((((((FAMILY == "LFD2NX") || (FAMILY == "LFCPNX")) || (FAMILY == "LFMXO5")) || (FAMILY == "UT24C")) || (FAMILY == "UT24CP")) ? "LIFCL" : FAMILY) ; 
    FIFO_A2B_ipgen_lscc_fifo_dc_main #(.IMPLEMENTATION(IMPLEMENTATION),
            .WADDR_DEPTH(WADDR_DEPTH),
            .WADDR_WIDTH(WADDR_WIDTH),
            .WDATA_WIDTH(WDATA_WIDTH),
            .RADDR_DEPTH(RADDR_DEPTH),
            .RADDR_WIDTH(RADDR_WIDTH),
            .RDATA_WIDTH(RDATA_WIDTH),
            .REGMODE(REGMODE),
            .RESETMODE(RESETMODE),
            .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
            .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
            .INIT_FILE(INIT_FILE),
            .INIT_MODE(INIT_MODE),
            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
            .ALMOST_FULL_ASSERTION(ALMOST_FULL_ASSERTION),
            .ALMOST_FULL_ASSERT_LVL(ALMOST_FULL_ASSERT_LVL),
            .ALMOST_FULL_DEASSERT_LVL(ALMOST_FULL_DEASSERT_LVL),
            .ALMOST_EMPTY_ASSERTION(ALMOST_EMPTY_ASSERTION),
            .ALMOST_EMPTY_ASSERT_LVL(ALMOST_EMPTY_ASSERT_LVL),
            .ALMOST_EMPTY_DEASSERT_LVL(ALMOST_EMPTY_DEASSERT_LVL),
            .ECC_ENABLE(ECC_ENABLE),
            .ENABLE_DATA_COUNT_WR(ENABLE_DATA_COUNT_WR),
            .ENABLE_DATA_COUNT_RD(ENABLE_DATA_COUNT_RD),
            .FAMILY(T_FAMILY),
            .FIFO_CONTROLLER(FIFO_CONTROLLER),
            .FORCE_FAST_CONTROLLER(FORCE_FAST_CONTROLLER)) fifo_dc0 (//----------------------------
            // Inputs
            //----------------------------
            .wr_clk_i(wr_clk_i), 
                .rd_clk_i(rd_clk_i), 
                .wr_data_i(wr_data_i), 
                .wr_en_i(wr_en_i), 
                .rd_en_i(rd_en_i), 
                .rst_i(rst_i), 
                .rp_rst_i(rp_rst_i), 
                .almost_full_th_i(almost_full_th_i), 
                .almost_full_clr_th_i(almost_full_clr_th_i), 
                .almost_empty_th_i(almost_empty_th_i), 
                .almost_empty_clr_th_i(almost_empty_clr_th_i), 
                //----------------------------
            // Outputs
            //----------------------------
            .rd_data_o(rd_data_o), 
                .full_o(full_o), 
                .empty_o(empty_o), 
                .almost_full_o(almost_full_o), 
                .almost_empty_o(almost_empty_o), 
                .wr_data_cnt_o(wr_data_cnt_o), 
                .rd_data_cnt_o(rd_data_cnt_o), 
                .one_err_det_o(one_err_det_o), 
                .two_err_det_o(two_err_det_o)) ; //--end_ports--
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_fifo_dc.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module FIFO_A2B_ipgen_lscc_fifo_dc_main #(parameter IMPLEMENTATION = "EBR", 
        parameter WADDR_DEPTH = 512, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 36, 
        parameter RADDR_DEPTH = 512, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 36, 
        parameter REGMODE = "reg", 
        parameter RESETMODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter INIT_FILE = "none", 
        parameter INIT_MODE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 511, 
        parameter ALMOST_FULL_DEASSERT_LVL = 510, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 2, 
        parameter ECC_ENABLE = 0, 
        parameter ENABLE_DATA_COUNT_WR = "FALSE", 
        parameter ENABLE_DATA_COUNT_RD = "FALSE", 
        parameter FAMILY = "LIFCL", 
        parameter FIFO_CONTROLLER = "FABRIC", 
        parameter FORCE_FAST_CONTROLLER = 0) (
    //----------------------------
    // Inputs
    //----------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input rp_rst_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_th_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [WADDR_WIDTH:0] wr_data_cnt_o, 
    output [RADDR_WIDTH:0] rd_data_cnt_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    //--end_ports--
    if ((FIFO_CONTROLLER == "FABRIC")) 
        begin : _FABRIC
            FIFO_A2B_ipgen_lscc_soft_fifo_dc #(.IMPLEMENTATION(IMPLEMENTATION),
                    .WADDR_DEPTH(WADDR_DEPTH),
                    .WADDR_WIDTH(WADDR_WIDTH),
                    .WDATA_WIDTH(WDATA_WIDTH),
                    .RADDR_DEPTH(RADDR_DEPTH),
                    .RADDR_WIDTH(RADDR_WIDTH),
                    .RDATA_WIDTH(RDATA_WIDTH),
                    .REGMODE(REGMODE),
                    .RESETMODE(RESETMODE),
                    .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
                    .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
                    .INIT_FILE(INIT_FILE),
                    .INIT_MODE(INIT_MODE),
                    .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                    .ALMOST_FULL_ASSERTION(ALMOST_FULL_ASSERTION),
                    .ALMOST_FULL_ASSERT_LVL(ALMOST_FULL_ASSERT_LVL),
                    .ALMOST_FULL_DEASSERT_LVL(ALMOST_FULL_DEASSERT_LVL),
                    .ALMOST_EMPTY_ASSERTION(ALMOST_EMPTY_ASSERTION),
                    .ALMOST_EMPTY_ASSERT_LVL(ALMOST_EMPTY_ASSERT_LVL),
                    .ALMOST_EMPTY_DEASSERT_LVL(ALMOST_EMPTY_DEASSERT_LVL),
                    .ECC_ENABLE(ECC_ENABLE),
                    .ENABLE_DATA_COUNT_WR(ENABLE_DATA_COUNT_WR),
                    .ENABLE_DATA_COUNT_RD(ENABLE_DATA_COUNT_RD),
                    .FAMILY(FAMILY)) u_fifo (//----------------------------
                    // Inputs
                    //----------------------------
                    .wr_clk_i(wr_clk_i), 
                        .rd_clk_i(rd_clk_i), 
                        .wr_data_i(wr_data_i), 
                        .wr_en_i(wr_en_i), 
                        .rd_en_i(rd_en_i), 
                        .rst_i(rst_i), 
                        .rp_rst_i(rp_rst_i), 
                        .almost_full_th_i(almost_full_th_i), 
                        .almost_full_clr_th_i(almost_full_clr_th_i), 
                        .almost_empty_th_i(almost_empty_th_i), 
                        .almost_empty_clr_th_i(almost_empty_clr_th_i), 
                        //----------------------------
                    // Outputs
                    //----------------------------
                    .rd_data_o(rd_data_o), 
                        .full_o(full_o), 
                        .empty_o(empty_o), 
                        .almost_full_o(almost_full_o), 
                        .almost_empty_o(almost_empty_o), 
                        .wr_data_cnt_o(wr_data_cnt_o), 
                        .rd_data_cnt_o(rd_data_cnt_o), 
                        .one_err_det_o(one_err_det_o), 
                        .two_err_det_o(two_err_det_o)) ; 
        end
    else
        begin : genblk1
            FIFO_A2B_ipgen_lscc_hard_fifo_dc #(.IMPLEMENTATION(IMPLEMENTATION),
                    .WADDR_DEPTH(WADDR_DEPTH),
                    .WADDR_WIDTH(WADDR_WIDTH),
                    .WDATA_WIDTH(WDATA_WIDTH),
                    .RADDR_DEPTH(RADDR_DEPTH),
                    .RADDR_WIDTH(RADDR_WIDTH),
                    .RDATA_WIDTH(RDATA_WIDTH),
                    .REGMODE(REGMODE),
                    .RESETMODE(RESETMODE),
                    .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
                    .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
                    .INIT_FILE(INIT_FILE),
                    .INIT_MODE(INIT_MODE),
                    .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                    .ALMOST_FULL_ASSERTION(ALMOST_FULL_ASSERTION),
                    .ALMOST_FULL_ASSERT_LVL(ALMOST_FULL_ASSERT_LVL),
                    .ALMOST_FULL_DEASSERT_LVL(ALMOST_FULL_DEASSERT_LVL),
                    .ALMOST_EMPTY_ASSERTION(ALMOST_EMPTY_ASSERTION),
                    .ALMOST_EMPTY_ASSERT_LVL(ALMOST_EMPTY_ASSERT_LVL),
                    .ALMOST_EMPTY_DEASSERT_LVL(ALMOST_EMPTY_DEASSERT_LVL),
                    .ECC_ENABLE(ECC_ENABLE),
                    .ENABLE_DATA_COUNT_WR(ENABLE_DATA_COUNT_WR),
                    .ENABLE_DATA_COUNT_RD(ENABLE_DATA_COUNT_RD),
                    .FAMILY(FAMILY),
                    .FORCE_FAST_CONTROLLER(FORCE_FAST_CONTROLLER)) u_fifo (//----------------------------
                    // Inputs
                    //----------------------------
                    .wr_clk_i(wr_clk_i), 
                        .rd_clk_i(rd_clk_i), 
                        .wr_data_i(wr_data_i), 
                        .wr_en_i(wr_en_i), 
                        .rd_en_i(rd_en_i), 
                        .rst_i(rst_i), 
                        .rp_rst_i(rp_rst_i), 
                        .almost_full_th_i(almost_full_th_i), 
                        .almost_full_clr_th_i(almost_full_clr_th_i), 
                        .almost_empty_th_i(almost_empty_th_i), 
                        .almost_empty_clr_th_i(almost_empty_clr_th_i), 
                        //----------------------------
                    // Outputs
                    //----------------------------
                    .rd_data_o(rd_data_o), 
                        .full_o(full_o), 
                        .empty_o(empty_o), 
                        .almost_full_o(almost_full_o), 
                        .almost_empty_o(almost_empty_o), 
                        .wr_data_cnt_o(wr_data_cnt_o), 
                        .rd_data_cnt_o(rd_data_cnt_o), 
                        .one_err_det_o(one_err_det_o), 
                        .two_err_det_o(two_err_det_o)) ; 
        end
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 2.1
// File                  : lscc_hard_fifo_dc.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO using an internal 
//                         controller
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module FIFO_A2B_ipgen_lscc_hard_fifo_dc #(parameter _FCODE_LIFCL_ = 1, 
        parameter _FCODE_ICE_ = 2, 
        parameter _FCODE_COMMON_ = 0, 
        parameter IMPLEMENTATION = "EBR", 
        parameter FAMILY = "LIFCL", 
        parameter FAMILY_CODE = ((FAMILY == "LIFCL") ? _FCODE_LIFCL_ : ((FAMILY == "iCE40UP") ? _FCODE_ICE_ : _FCODE_COMMON_)), 
        parameter WADDR_DEPTH = 16384, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 16, 
        parameter RADDR_DEPTH = 8192, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 32, 
        parameter REGMODE = "reg", 
        parameter RESETMODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter INIT_FILE = "none", 
        parameter INIT_MODE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 511, 
        parameter ALMOST_FULL_DEASSERT_LVL = 510, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 2, 
        parameter ECC_ENABLE = 0, 
        parameter ENABLE_DATA_COUNT_WR = "FALSE", 
        parameter ENABLE_DATA_COUNT_RD = "FALSE", 
        parameter FORCE_FAST_CONTROLLER = 0) (
    //----------------------------
    // Inputs
    //----------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input rp_rst_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_th_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [WADDR_WIDTH:0] wr_data_cnt_o, 
    output [RADDR_WIDTH:0] rd_data_cnt_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    //--end_ports--
    genvar i0, 
        i1 ; 
    generate
        if ((WDATA_WIDTH == RDATA_WIDTH)) 
            begin : _SAME_WIDTH
                localparam OPT_DATA_WIDTH = getMinFIFO(WADDR_DEPTH,
                            WDATA_WIDTH,
                            ECC_ENABLE,
                            FAMILY_CODE,
                            FORCE_FAST_CONTROLLER) ; 
                localparam OPT_ADDR_DEPTH = data_to_addr(OPT_DATA_WIDTH,
                            FAMILY_CODE) ; 
                localparam FIFO_DATA = roundUP(WDATA_WIDTH,
                            OPT_DATA_WIDTH) ; 
                localparam FIFO_ADDR = roundUP(WADDR_DEPTH,
                            OPT_ADDR_DEPTH) ; 
                localparam FULL_PER_EBR = roundUP(WADDR_DEPTH,
                            FIFO_ADDR) ; 
                localparam AFULL_PER_EBR = roundUP(ALMOST_FULL_ASSERT_LVL,
                            FIFO_ADDR) ; 
                localparam AEMPTY_PER_EBR = (ALMOST_EMPTY_ASSERT_LVL / FIFO_ADDR) ; 
                localparam FULL_CNT = (WADDR_DEPTH % FIFO_ADDR) ; 
                localparam AF_FLAG_CNT = (ALMOST_FULL_ASSERT_LVL % FIFO_ADDR) ; 
                localparam AE_FLAG_CNT = (FIFO_ADDR - (ALMOST_EMPTY_ASSERT_LVL % FIFO_ADDR)) ; 
                localparam IS_CASCADE = (FIFO_ADDR > 1) ; 
                reg [(FIFO_ADDR - 1):0] wr_pong_r ; 
                reg [(FIFO_ADDR - 1):0] rd_pong_r ; 
                reg [(FIFO_ADDR - 1):0] wr_pong_nxt_c ; 
                reg [(FIFO_ADDR - 1):0] rd_pong_nxt_c ; 
                wire [(RDATA_WIDTH - 1):0] rd_data_raw_w [(FIFO_ADDR - 1):0] ; 
                wire [(FIFO_ADDR - 1):0] full_out_w ; 
                wire [(FIFO_ADDR - 1):0] afull_out_w ; 
                wire [(FIFO_ADDR - 1):0] empty_out_w ; 
                wire [(FIFO_ADDR - 1):0] aempty_out_w ; 
                wire [(FIFO_ADDR - 1):0] one_err_det_out_w ; 
                wire [(FIFO_ADDR - 1):0] two_err_det_out_w ; 
                for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                begin : _FIFO_ADDR
                    // ------ Read Port ------
                    wire [(RDATA_WIDTH - 1):0] fifo_out_raw_w ; 
                    assign rd_data_raw_w[i0] = fifo_out_raw_w ; 
                    wire wr_fifo_w ; 
                    wire rd_fifo_w ; 
                    if ((FIFO_ADDR == 1)) 
                        begin : genblk1
                            assign wr_fifo_w = wr_en_i ; 
                            assign rd_fifo_w = rd_en_i ; 
                        end
                    else
                        begin : genblk1
                            assign wr_fifo_w = (wr_pong_r[i0] & wr_en_i) ; 
                            assign rd_fifo_w = (rd_pong_r[i0] & rd_en_i) ; 
                        end
                    wire [(FIFO_DATA - 1):0] one_err_det_raw_w ; 
                    wire [(FIFO_DATA - 1):0] two_err_det_raw_w ; 
                    assign one_err_det_out_w[i0] = (|one_err_det_raw_w) ; 
                    assign two_err_det_out_w[i0] = (|two_err_det_raw_w) ; 
                    for (i1 = 0;(i1 < FIFO_DATA);i1 = (i1 + 1))
                    begin : _FIFO_DATA
                        wire [(OPT_DATA_WIDTH - 1):0] in_fifo_w ; 
                        wire [(OPT_DATA_WIDTH - 1):0] out_fifo_w ; 
                        wire loc_full_w ; 
                        wire loc_empty_w ; 
                        wire loc_afull_w ; 
                        wire loc_aempty_w ; 
                        if (((OPT_DATA_WIDTH * (i1 + 1)) < WDATA_WIDTH)) 
                            begin : genblk1
                                assign in_fifo_w = wr_data_i[(OPT_DATA_WIDTH * i1) +: OPT_DATA_WIDTH] ; 
                                assign fifo_out_raw_w[(OPT_DATA_WIDTH * i1) +: OPT_DATA_WIDTH] = out_fifo_w ; 
                            end
                        else
                            begin : genblk1
                                assign in_fifo_w[(WDATA_WIDTH - (1 + (OPT_DATA_WIDTH * i1))):0] = wr_data_i[(WDATA_WIDTH - 1):(OPT_DATA_WIDTH * i1)] ; 
                                if ((OPT_DATA_WIDTH > (WDATA_WIDTH - (OPT_DATA_WIDTH * i1)))) 
                                    begin : genblk1
                                        assign in_fifo_w[(OPT_DATA_WIDTH - 1):(WDATA_WIDTH - (OPT_DATA_WIDTH * i1))] = {(OPT_DATA_WIDTH - (WDATA_WIDTH - (OPT_DATA_WIDTH * i1))){1'b0}} ; 
                                    end
                                assign fifo_out_raw_w[(RDATA_WIDTH - 1):(OPT_DATA_WIDTH * i1)] = out_fifo_w[(RDATA_WIDTH - (1 + (OPT_DATA_WIDTH * i1))):0] ; 
                            end
                        FIFO_A2B_ipgen_lscc_fifo_dc_hw_core #(.FAMILY(FAMILY),
                                .WADDR_DEPTH(FULL_PER_EBR),
                                .WDATA_WIDTH(OPT_DATA_WIDTH),
                                .RADDR_DEPTH(FULL_PER_EBR),
                                .RDATA_WIDTH(OPT_DATA_WIDTH),
                                .REGMODE(REGMODE),
                                .RESETMODE(RESETMODE),
                                .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
                                .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
                                .ALMOST_FULL_ASSERTION("static-dual"),
                                .ALMOST_FULL_ASSERT_LVL(AFULL_PER_EBR),
                                .ALMOST_FULL_DEASSERT_LVL(AFULL_PER_EBR),
                                .ALMOST_EMPTY_ASSERTION("static-dual"),
                                .ALMOST_EMPTY_ASSERT_LVL(AEMPTY_PER_EBR),
                                .ALMOST_EMPTY_DEASSERT_LVL(AEMPTY_PER_EBR),
                                .ENABLE_DATA_COUNT_WR("FALSE"),
                                .ENABLE_DATA_COUNT_RD("FALSE"),
                                .ECC_ENABLE(ECC_ENABLE),
                                .IS_CASCADE(IS_CASCADE)) u_fifo (.wr_clk_i(wr_clk_i), 
                                    .wr_en_i(wr_fifo_w), 
                                    .wr_data_i(in_fifo_w), 
                                    .rd_clk_i(rd_clk_i), 
                                    .rd_en_i(rd_fifo_w), 
                                    .rst_i(rst_i), 
                                    .rp_rst_i(rp_rst_i), 
                                    .full_cascade_i(full_o), 
                                    .rd_data_o(out_fifo_w), 
                                    .full_o(loc_full_w), 
                                    .empty_o(loc_empty_w), 
                                    .almost_full_o(loc_afull_w), 
                                    .almost_empty_o(loc_aempty_w), 
                                    .one_err_det_o(one_err_det_raw_w[i1]), 
                                    .two_err_det_o(two_err_det_raw_w[i1])) ; 
                        if ((i1 == 0)) 
                            begin : genblk2
                                assign full_out_w[i0] = loc_full_w ; 
                                assign afull_out_w[i0] = loc_afull_w ; 
                                assign empty_out_w[i0] = loc_empty_w ; 
                                assign aempty_out_w[i0] = loc_aempty_w ; 
                            end
                    end
                end
                if ((FIFO_ADDR == 1)) 
                    begin : _SING_DEPTH
                        assign full_o = full_out_w[0] ; 
                        assign empty_o = empty_out_w[0] ; 
                        assign rd_data_o = rd_data_raw_w[0] ; 
                        if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                            begin : genblk1
                                assign almost_full_o = afull_out_w[0] ; 
                            end
                        else
                            begin : genblk1
                                assign almost_full_o = 1'b0 ; 
                            end
                        if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                            begin : genblk2
                                assign almost_empty_o = aempty_out_w[0] ; 
                            end
                        else
                            begin : genblk2
                                assign almost_empty_o = 1'b0 ; 
                            end
                        if (ECC_ENABLE) 
                            begin : genblk3
                                assign one_err_det_o = one_err_det_out_w[0] ; 
                                assign two_err_det_o = two_err_det_out_w[0] ; 
                            end
                        else
                            begin : genblk3
                                assign one_err_det_o = 1'b0 ; 
                                assign two_err_det_o = 1'b0 ; 
                            end
                    end
                else
                    begin : _MULT_DEPTH
                        reg [(FIFO_ADDR - 1):0] rd_pong_p_r ; 
                        always
                            @(*)
                            begin
                                wr_pong_nxt_c = wr_pong_r ;
                                if ((wr_en_i & (!full_o))) 
                                    begin
                                        wr_pong_nxt_c = (wr_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                1'b1} : (wr_pong_r << 1)) ;
                                    end
                            end
                        always
                            @(*)
                            begin
                                rd_pong_nxt_c = rd_pong_r ;
                                if ((rd_en_i & (!empty_o))) 
                                    begin
                                        rd_pong_nxt_c = (rd_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                1'b1} : (rd_pong_r << 1)) ;
                                    end
                            end
                        always
                            @(posedge wr_clk_i or 
                                posedge rst_i)
                            begin
                                if (rst_i) 
                                    begin
                                        wr_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                1'b1} ;
                                    end
                                else
                                    begin
                                        wr_pong_r <=  wr_pong_nxt_c ;
                                    end
                            end
                        always
                            @(posedge rd_clk_i or 
                                posedge rst_i)
                            begin
                                if (rst_i) 
                                    begin
                                        rd_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                1'b1} ;
                                    end
                                else
                                    begin
                                        rd_pong_r <=  rd_pong_nxt_c ;
                                    end
                            end
                        if ((REGMODE == "noreg")) 
                            begin : _NREG
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_p_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_p_r <=  rd_pong_r ;
                                            end
                                    end
                            end
                        else
                            begin : _REG
                                reg [(FIFO_ADDR - 1):0] rd_pong_pr_r ; 
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_p_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                                rd_pong_pr_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_p_r <=  rd_pong_pr_r ;
                                                rd_pong_pr_r <=  rd_pong_r ;
                                            end
                                    end
                            end
                        for (i0 = 0;(i0 < RDATA_WIDTH);i0 = (i0 + 1))
                        begin : genblk2
                            wire [(FIFO_ADDR - 1):0] translate_rd_data_w ; 
                            assign rd_data_o[i0] = (|translate_rd_data_w) ; 
                            for (i1 = 0;(i1 < FIFO_ADDR);i1 = (i1 + 1))
                            begin : genblk1
                                wire [(RDATA_WIDTH - 1):0] sampled_rd_data_w ; 
                                assign sampled_rd_data_w = (rd_pong_p_r[i1] ? rd_data_raw_w[i1] : {RDATA_WIDTH{1'b0}}) ; 
                                assign translate_rd_data_w[i1] = sampled_rd_data_w[i0] ; 
                            end
                        end
                        if (ECC_ENABLE) 
                            begin : genblk3
                                wire [(FIFO_ADDR - 1):0] one_todet_out_w ; 
                                wire [(FIFO_ADDR - 1):0] two_todet_out_w ; 
                                assign one_err_det_o = (|one_todet_out_w) ; 
                                assign two_err_det_o = (|two_todet_out_w) ; 
                                for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                begin : genblk1
                                    assign one_todet_out_w = (rd_pong_p_r[i0] & one_err_det_out_w[i0]) ; 
                                    assign two_todet_out_w = (rd_pong_p_r[i0] & one_err_det_out_w[i0]) ; 
                                end
                            end
                        else
                            begin : genblk3
                                assign one_err_det_o = 1'b0 ; 
                                assign two_err_det_o = 1'b0 ; 
                            end
                        assign empty_o = (&empty_out_w) ; 
                        if ((FULL_CNT == 0)) 
                            begin : _FIX_FULL
                                assign full_o = (&full_out_w) ; 
                            end
                        else
                            if ((FULL_CNT == 1)) 
                                begin : _SING_FULL
                                    assign full_o = (|full_out_w) ; 
                                end
                            else
                                begin : _MULT_FULL
                                    wire [(FIFO_ADDR - 1):0] full_expand_w ; 
                                    assign full_o = (|full_expand_w) ; 
                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                    begin : _EXP_FULL_FLAG
                                        wire [(FULL_CNT - 1):0] nterm_and_w ; 
                                        assign full_expand_w[i0] = (&nterm_and_w) ; 
                                        for (i1 = 0;(i1 < FULL_CNT);i1 = (i1 + 1))
                                        begin : _MULT_NTERM
                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                begin : genblk1
                                                    assign nterm_and_w[i1] = full_out_w[(i0 + i1)] ; 
                                                end
                                            else
                                                begin : genblk1
                                                    assign nterm_and_w[i1] = full_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                end
                                        end
                                    end
                                end
                        if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                            begin : _EN_AF_FLAG
                                if ((AF_FLAG_CNT == 0)) 
                                    begin : _FIX_AF_FLAG
                                        assign almost_full_o = (&afull_out_w) ; 
                                    end
                                else
                                    if ((AF_FLAG_CNT == 1)) 
                                        begin : _SING_AF_FLAG
                                            assign almost_full_o = (|afull_out_w) ; 
                                        end
                                    else
                                        begin : genblk1
                                            wire [(FIFO_ADDR - 1):0] afull_expand_w ; 
                                            assign almost_full_o = (|afull_expand_w) ; 
                                            for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                            begin : genblk1
                                                wire [(AF_FLAG_CNT - 1):0] nterm_and_w ; 
                                                assign afull_expand_w[i0] = (&nterm_and_w) ; 
                                                for (i1 = 0;(i1 < AF_FLAG_CNT);i1 = (i1 + 1))
                                                begin : genblk1
                                                    if (((i0 + i1) < FIFO_ADDR)) 
                                                        begin : genblk1
                                                            assign nterm_and_w[i1] = afull_out_w[(i0 + i1)] ; 
                                                        end
                                                    else
                                                        begin : genblk1
                                                            assign nterm_and_w[i1] = afull_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                        end
                                                end
                                            end
                                        end
                            end
                        else
                            begin : _DIS_AF_FLAG
                                assign almost_full_o = 1'b0 ; 
                            end
                        if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                            begin : _EN_AE_FLAG
                                if ((AE_FLAG_CNT == 0)) 
                                    begin : _FIX_AE_FLAG
                                        assign almost_empty_o = (&aempty_out_w) ; 
                                    end
                                else
                                    if ((AE_FLAG_CNT == 1)) 
                                        begin : _SING_AE_FLAG
                                            assign almost_empty_o = (|aempty_out_w) ; 
                                        end
                                    else
                                        begin : _MULT_AE_FLAG
                                            wire [(FIFO_ADDR - 1):0] aempty_expand_w ; 
                                            assign almost_empty_o = (|aempty_expand_w) ; 
                                            for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                            begin : _EXP_AEFLAG
                                                wire [(AE_FLAG_CNT - 1):0] nterm_and_w ; 
                                                assign aempty_expand_w[i0] = (&nterm_and_w) ; 
                                                for (i1 = 0;(i1 < AE_FLAG_CNT);i1 = (i1 + 1))
                                                begin : _MULT_NTERM
                                                    if (((i0 + i1) < FIFO_ADDR)) 
                                                        begin : genblk1
                                                            assign nterm_and_w[i1] = aempty_out_w[(i0 + i1)] ; 
                                                        end
                                                    else
                                                        begin : genblk1
                                                            assign nterm_and_w[i1] = aempty_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                        end
                                                end
                                            end
                                        end
                            end
                        else
                            begin : _DIS_AE_FLAG
                                assign almost_empty_o = 1'b0 ; 
                            end
                    end
            end
        else
            begin : _MIXED_WIDTH
                assign one_err_det_o = 1'b0 ; 
                assign two_err_det_o = 1'b0 ; 
                localparam IS_W_GREATER = (WDATA_WIDTH > RDATA_WIDTH) ; 
                localparam Q_FACTOR = (IS_W_GREATER ? (WDATA_WIDTH / RDATA_WIDTH) : (RDATA_WIDTH / WDATA_WIDTH)) ; 
                localparam MAX_DATA = (IS_W_GREATER ? WDATA_WIDTH : RDATA_WIDTH) ; 
                localparam MIN_DEPTH = (IS_W_GREATER ? WADDR_DEPTH : RADDR_DEPTH) ; 
                localparam PROC_MAX_DATA = procData(MAX_DATA,
                            FAMILY_CODE) ; 
                localparam PROC_MIN_DATA = (PROC_MAX_DATA / Q_FACTOR) ; 
                localparam W_DWID_USE = (IS_W_GREATER ? PROC_MAX_DATA : PROC_MIN_DATA) ; 
                localparam R_DWID_USE = (IS_W_GREATER ? PROC_MIN_DATA : PROC_MAX_DATA) ; 
                localparam W_DWID_IMPL = getDWIDImpl(WADDR_DEPTH,
                            W_DWID_USE,
                            RADDR_DEPTH,
                            R_DWID_USE,
                            1'b1,
                            FAMILY_CODE,
                            FORCE_FAST_CONTROLLER) ; 
                localparam W_ADEPTH_IMPL = data_to_addr(W_DWID_IMPL,
                            FAMILY_CODE) ; 
                localparam R_DWID_IMPL = getDWIDImpl(WADDR_DEPTH,
                            W_DWID_USE,
                            RADDR_DEPTH,
                            R_DWID_USE,
                            1'b0,
                            FAMILY_CODE,
                            FORCE_FAST_CONTROLLER) ; 
                localparam R_ADEPTH_IMPL = data_to_addr(R_DWID_IMPL,
                            FAMILY_CODE) ; 
                localparam FIFO_DATA = roundUP(W_DWID_USE,
                            W_DWID_IMPL) ; 
                localparam FIFO_ADDR = roundUP(WADDR_DEPTH,
                            W_ADEPTH_IMPL) ; 
                localparam FULL_PER_EBR = getFullFlag(WADDR_DEPTH,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b0) ; 
                localparam FULL_CNT = getFullFlag(WADDR_DEPTH,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b1) ; 
                localparam AFULL_PER_EBR = getAFullFlag(ALMOST_FULL_ASSERT_LVL,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b0) ; 
                localparam AF_FLAG_CNT = getAFullFlag(ALMOST_FULL_ASSERT_LVL,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b1) ; 
                localparam AEMPTY_PER_EBR = getAEmptyFlag(ALMOST_EMPTY_ASSERT_LVL,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b0) ; 
                localparam AE_NUM_TERMS = getAEmptyFlag(ALMOST_EMPTY_ASSERT_LVL,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b1) ; 
                localparam NUM_TERMS = (WADDR_DEPTH % FIFO_ADDR) ; 
                localparam IS_CASCADE = (FIFO_ADDR > 1) ; 
                reg [(FIFO_ADDR - 1):0] wr_pong_r ; 
                reg [(FIFO_ADDR - 1):0] rd_pong_r ; 
                wire [(W_DWID_USE - 1):0] wr_top_w ; 
                wire [(R_DWID_USE - 1):0] rd_top_w ; 
                wire [(W_DWID_USE - 1):0] wr_fifo_w ; 
                wire [(R_DWID_USE - 1):0] rd_fifo_w ; 
                wire [(R_DWID_USE - 1):0] rd_data_raw_w [(FIFO_ADDR - 1):0] ; 
                wire [(FIFO_ADDR - 1):0] full_out_w ; 
                wire [(FIFO_ADDR - 1):0] afull_out_w ; 
                wire [(FIFO_ADDR - 1):0] empty_out_w ; 
                wire [(FIFO_ADDR - 1):0] aempty_out_w ; 
                if (IS_W_GREATER) 
                    begin : _W_OVR_R
                        assign rd_data_o = rd_fifo_w[(RDATA_WIDTH - 1):0] ; 
                        for (i0 = 0;(i0 < Q_FACTOR);i0 = (i0 + 1))
                        begin : genblk1
                            wire [(R_DWID_USE - 1):0] conn_w ; 
                            assign conn_w[(RDATA_WIDTH - 1):0] = wr_data_i[(RDATA_WIDTH * i0) +: RDATA_WIDTH] ; 
                            if ((R_DWID_USE > RDATA_WIDTH)) 
                                begin : genblk1
                                    assign conn_w[(R_DWID_USE - 1):RDATA_WIDTH] = {(R_DWID_USE - RDATA_WIDTH){1'b0}} ; 
                                end
                            assign wr_top_w[(R_DWID_USE * i0) +: R_DWID_USE] = conn_w ; 
                        end
                        wire [(R_DWID_IMPL - 1):0] fifo_seg_w [((W_DWID_USE / R_DWID_IMPL) - 1):0] ; 
                        for (i0 = 0;(i0 < FIFO_DATA);i0 = (i0 + 1))
                        begin : genblk2
                            for (i1 = 0;(i1 < (W_DWID_USE / (R_DWID_IMPL * FIFO_DATA)));i1 = (i1 + 1))
                            begin : genblk1
                                assign fifo_seg_w[(((W_DWID_USE / (R_DWID_IMPL * FIFO_DATA)) * i0) + i1)] = wr_top_w[((i0 * R_DWID_IMPL) + ((i1 * FIFO_DATA) * R_DWID_IMPL)) +: R_DWID_IMPL] ; 
                            end
                        end
                        for (i0 = 0;(i0 < (W_DWID_USE / R_DWID_IMPL));i0 = (i0 + 1))
                        begin : genblk3
                            assign wr_fifo_w[(i0 * R_DWID_IMPL) +: R_DWID_IMPL] = fifo_seg_w[i0] ; 
                        end
                        if ((FIFO_ADDR > 1)) 
                            begin : _MULT_PONG
                                localparam RD_CNTR = (Q_FACTOR - 1) ; 
                                localparam RD_CTR_WID = clog2(Q_FACTOR) ; 
                                reg [(FIFO_ADDR - 1):0] wr_pong_nxt_c ; 
                                reg [(FIFO_ADDR - 1):0] rd_pong_nxt_c ; 
                                reg [(RD_CTR_WID - 1):0] rd_ctr_r ; 
                                reg [(RD_CTR_WID - 1):0] rd_ctr_nxt_c ; 
                                always
                                    @(*)
                                    begin
                                        wr_pong_nxt_c = wr_pong_r ;
                                        if ((wr_en_i & (~full_o))) 
                                            begin
                                                wr_pong_nxt_c = (wr_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} : (wr_pong_r << 1)) ;
                                            end
                                    end
                                always
                                    @(*)
                                    begin
                                        rd_pong_nxt_c = rd_pong_r ;
                                        if (((rd_en_i & (~empty_o)) & (rd_ctr_r == RD_CNTR))) 
                                            begin
                                                rd_pong_nxt_c = (rd_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} : (rd_pong_r << 1)) ;
                                            end
                                    end
                                always
                                    @(*)
                                    begin
                                        rd_ctr_nxt_c = rd_ctr_r ;
                                        if ((rd_en_i & (~empty_o))) 
                                            begin
                                                rd_ctr_nxt_c = ((rd_ctr_r == RD_CNTR) ? {RD_CTR_WID{1'b0}} : (rd_ctr_r + 1'b1)) ;
                                            end
                                    end
                                always
                                    @(posedge wr_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                wr_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                wr_pong_r <=  wr_pong_nxt_c ;
                                            end
                                    end
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                                rd_ctr_r <=  {RD_CTR_WID{1'b0}} ;
                                            end
                                        else
                                            begin
                                                rd_pong_r <=  rd_pong_nxt_c ;
                                                rd_ctr_r <=  rd_ctr_nxt_c ;
                                            end
                                    end
                            end
                    end
                else
                    begin : _R_OVR_W
                        assign wr_fifo_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                        if ((W_DWID_USE > WDATA_WIDTH)) 
                            begin : genblk1
                                assign wr_fifo_w[(W_DWID_USE - 1):WDATA_WIDTH] = {(W_DWID_USE - WDATA_WIDTH){1'b0}} ; 
                            end
                        for (i0 = 0;(i0 < Q_FACTOR);i0 = (i0 + 1))
                        begin : genblk2
                            wire [(W_DWID_USE - 1):0] conn_w ; 
                            assign conn_w = rd_top_w[(W_DWID_USE * i0) +: W_DWID_USE] ; 
                            assign rd_data_o[(WDATA_WIDTH * i0) +: WDATA_WIDTH] = conn_w[(WDATA_WIDTH - 1):0] ; 
                        end
                        wire [(W_DWID_IMPL - 1):0] fifo_seg_w [((R_DWID_USE / W_DWID_IMPL) - 1):0] ; 
                        for (i0 = 0;(i0 < Q_FACTOR);i0 = (i0 + 1))
                        begin : genblk3
                            for (i1 = 0;(i1 < FIFO_DATA);i1 = (i1 + 1))
                            begin : genblk1
                                assign fifo_seg_w[((i0 * FIFO_DATA) + i1)] = rd_fifo_w[((i1 * R_DWID_IMPL) + (i0 * W_DWID_IMPL)) +: W_DWID_IMPL] ; 
                            end
                        end
                        for (i0 = 0;(i0 < (R_DWID_USE / W_DWID_IMPL));i0 = (i0 + 1))
                        begin : genblk4
                            assign rd_top_w[(i0 * W_DWID_IMPL) +: W_DWID_IMPL] = fifo_seg_w[i0] ; 
                        end
                        if ((FIFO_ADDR > 1)) 
                            begin : _MULT_PONG
                                localparam WR_CNTR = (Q_FACTOR - 1) ; 
                                localparam WR_CTR_WID = clog2(Q_FACTOR) ; 
                                reg [(FIFO_ADDR - 1):0] wr_pong_nxt_c ; 
                                reg [(FIFO_ADDR - 1):0] rd_pong_nxt_c ; 
                                reg [(WR_CTR_WID - 1):0] wr_ctr_r ; 
                                reg [(WR_CTR_WID - 1):0] wr_ctr_nxt_c ; 
                                always
                                    @(*)
                                    begin
                                        wr_pong_nxt_c = wr_pong_r ;
                                        if (((wr_en_i & (~full_o)) & (wr_ctr_r == WR_CNTR))) 
                                            begin
                                                wr_pong_nxt_c = (wr_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} : (wr_pong_r << 1)) ;
                                            end
                                    end
                                always
                                    @(*)
                                    begin
                                        rd_pong_nxt_c = rd_pong_r ;
                                        if ((rd_en_i & (~empty_o))) 
                                            begin
                                                rd_pong_nxt_c = (rd_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} : (rd_pong_r << 1)) ;
                                            end
                                    end
                                always
                                    @(*)
                                    begin
                                        wr_ctr_nxt_c = wr_ctr_r ;
                                        if ((wr_en_i & (~full_o))) 
                                            begin
                                                wr_ctr_nxt_c = ((wr_ctr_r == WR_CNTR) ? {WR_CTR_WID{1'b0}} : (wr_ctr_r + 1'b1)) ;
                                            end
                                    end
                                always
                                    @(posedge wr_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                wr_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                                wr_ctr_r <=  {WR_CTR_WID{1'b0}} ;
                                            end
                                        else
                                            begin
                                                wr_pong_r <=  wr_pong_nxt_c ;
                                                wr_ctr_r <=  wr_ctr_nxt_c ;
                                            end
                                    end
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_r <=  rd_pong_nxt_c ;
                                            end
                                    end
                            end
                    end
                for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                begin : _EXP_ADDR
                    // ------ Read Port ------
                    wire [(R_DWID_USE - 1):0] fifo_out_raw_w ; 
                    assign rd_data_raw_w[i0] = fifo_out_raw_w ; 
                    wire wr_en_w ; 
                    wire rd_en_w ; 
                    if ((FIFO_ADDR == 1)) 
                        begin : genblk1
                            assign wr_en_w = wr_en_i ; 
                            assign rd_en_w = rd_en_i ; 
                        end
                    else
                        begin : genblk1
                            assign wr_en_w = (wr_pong_r[i0] & wr_en_i) ; 
                            assign rd_en_w = (rd_pong_r[i0] & rd_en_i) ; 
                        end
                    for (i1 = 0;(i1 < FIFO_DATA);i1 = (i1 + 1))
                    begin : _EXP_DATA
                        wire [(W_DWID_IMPL - 1):0] in_fifo_w ; 
                        wire [(R_DWID_IMPL - 1):0] out_fifo_w ; 
                        wire loc_full_w ; 
                        wire loc_empty_w ; 
                        wire loc_afull_w ; 
                        wire loc_aempty_w ; 
                        if (((W_DWID_IMPL * (i1 + 1)) < W_DWID_USE)) 
                            begin : genblk1
                                assign in_fifo_w = wr_fifo_w[(W_DWID_IMPL * i1) +: W_DWID_IMPL] ; 
                                assign fifo_out_raw_w[(R_DWID_IMPL * i1) +: R_DWID_IMPL] = out_fifo_w ; 
                            end
                        else
                            begin : genblk1
                                assign in_fifo_w[(W_DWID_USE - (1 + (W_DWID_IMPL * i1))):0] = wr_fifo_w[(W_DWID_USE - 1):(W_DWID_IMPL * i1)] ; 
                                if ((W_DWID_IMPL > (W_DWID_USE - (W_DWID_IMPL * i1)))) 
                                    begin : genblk1
                                        assign in_fifo_w[(W_DWID_IMPL - 1):(W_DWID_USE - (W_DWID_IMPL * i1))] = {(W_DWID_IMPL - (W_DWID_USE - (W_DWID_IMPL * i1))){1'b0}} ; 
                                    end
                                assign fifo_out_raw_w[(R_DWID_USE - 1):(R_DWID_IMPL * i1)] = out_fifo_w[(R_DWID_USE - (1 + (R_DWID_IMPL * i1))):0] ; 
                            end
                        FIFO_A2B_ipgen_lscc_fifo_dc_hw_core #(.FAMILY(FAMILY),
                                .WADDR_DEPTH(FULL_PER_EBR),
                                .WDATA_WIDTH(W_DWID_IMPL),
                                .RADDR_DEPTH(FULL_PER_EBR),
                                .RDATA_WIDTH(R_DWID_IMPL),
                                .REGMODE(REGMODE),
                                .RESETMODE(RESETMODE),
                                .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
                                .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
                                .ALMOST_FULL_ASSERTION("static-dual"),
                                .ALMOST_FULL_ASSERT_LVL(AFULL_PER_EBR),
                                .ALMOST_FULL_DEASSERT_LVL(AFULL_PER_EBR),
                                .ALMOST_EMPTY_ASSERTION("static-dual"),
                                .ALMOST_EMPTY_ASSERT_LVL(AEMPTY_PER_EBR),
                                .ALMOST_EMPTY_DEASSERT_LVL(AEMPTY_PER_EBR),
                                .ENABLE_DATA_COUNT_WR("FALSE"),
                                .ENABLE_DATA_COUNT_RD("FALSE"),
                                .ECC_ENABLE(ECC_ENABLE),
                                .IS_CASCADE(IS_CASCADE)) u_fifo (.wr_clk_i(wr_clk_i), 
                                    .wr_en_i(wr_en_w), 
                                    .wr_data_i(in_fifo_w), 
                                    .rd_clk_i(rd_clk_i), 
                                    .rd_en_i(rd_en_w), 
                                    .rst_i(rst_i), 
                                    .rp_rst_i(rp_rst_i), 
                                    .full_cascade_i(full_o), 
                                    .rd_data_o(out_fifo_w), 
                                    .full_o(loc_full_w), 
                                    .empty_o(loc_empty_w), 
                                    .almost_full_o(loc_afull_w), 
                                    .almost_empty_o(loc_aempty_w), 
                                    .one_err_det_o(), 
                                    .two_err_det_o()) ; 
                        if ((i1 == 0)) 
                            begin : genblk2
                                assign full_out_w[i0] = loc_full_w ; 
                                assign afull_out_w[i0] = loc_afull_w ; 
                                assign empty_out_w[i0] = loc_empty_w ; 
                                assign aempty_out_w[i0] = loc_aempty_w ; 
                            end
                    end
                end
                if ((FIFO_ADDR == 1)) 
                    begin : _SING_DEPTH
                        assign full_o = full_out_w[0] ; 
                        assign empty_o = empty_out_w[0] ; 
                        assign rd_fifo_w = rd_data_raw_w[0] ; 
                        if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                            begin : genblk1
                                assign almost_full_o = afull_out_w[0] ; 
                            end
                        else
                            begin : genblk1
                                assign almost_full_o = 1'b0 ; 
                            end
                        if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                            begin : genblk2
                                assign almost_empty_o = aempty_out_w[0] ; 
                            end
                        else
                            begin : genblk2
                                assign almost_empty_o = 1'b0 ; 
                            end
                    end
                else
                    begin : _MULT_DEPTH
                        reg [(FIFO_ADDR - 1):0] rd_pong_p_r ; 
                        if ((REGMODE == "noreg")) 
                            begin : _NREG
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_p_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_p_r <=  rd_pong_r ;
                                            end
                                    end
                            end
                        else
                            begin : _REG
                                reg [(FIFO_ADDR - 1):0] rd_pong_pr_r ; 
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_p_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                                rd_pong_pr_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_p_r <=  rd_pong_pr_r ;
                                                rd_pong_pr_r <=  rd_pong_r ;
                                            end
                                    end
                            end
                        for (i0 = 0;(i0 < R_DWID_USE);i0 = (i0 + 1))
                        begin : _DOUT_GEN_LOOP
                            wire [(FIFO_ADDR - 1):0] translate_rd_data_w ; 
                            assign rd_fifo_w[i0] = (|translate_rd_data_w) ; 
                            for (i1 = 0;(i1 < FIFO_ADDR);i1 = (i1 + 1))
                            begin : _DOUT_GEN_LOOP2
                                wire [(R_DWID_USE - 1):0] sampled_rd_data_w ; 
                                assign sampled_rd_data_w = (rd_pong_p_r[i1] ? rd_data_raw_w[i1] : {RDATA_WIDTH{1'b0}}) ; 
                                assign translate_rd_data_w[i1] = sampled_rd_data_w[i0] ; 
                            end
                        end
                        assign empty_o = (&empty_out_w) ; 
                        if (IS_W_GREATER) 
                            begin : _W_OVR_R
                                if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                                    begin : _EN_AF_FLAG
                                        if ((AF_FLAG_CNT == 0)) 
                                            begin : _FIX_AF_FLAG
                                                assign almost_full_o = (&afull_out_w) ; 
                                            end
                                        else
                                            if ((AF_FLAG_CNT == 1)) 
                                                begin : _SING_AF_FLAG
                                                    assign almost_full_o = (|afull_out_w) ; 
                                                end
                                            else
                                                begin : _MULT_AF_FLAG
                                                    wire [(FIFO_ADDR - 1):0] afull_expand_w ; 
                                                    assign almost_full_o = (|afull_expand_w) ; 
                                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                                    begin : _EXP_AFULL_FLAG
                                                        wire [(AF_FLAG_CNT - 1):0] nterm_and_w ; 
                                                        assign afull_expand_w[i0] = (&nterm_and_w) ; 
                                                        for (i1 = 0;(i1 < AF_FLAG_CNT);i1 = (i1 + 1))
                                                        begin : _GEN_MINTERM
                                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                                begin : _PRELOOP
                                                                    assign nterm_and_w[i1] = afull_out_w[(i0 + i1)] ; 
                                                                end
                                                            else
                                                                begin : _POSTLOOP
                                                                    assign nterm_and_w[i1] = afull_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                                end
                                                        end
                                                    end
                                                end
                                    end
                                else
                                    begin : _DIS_AF_FLAG
                                        assign almost_full_o = 1'b0 ; 
                                    end
                                if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                                    begin : _EN_AE_FLAG
                                        if (((AE_NUM_TERMS == FIFO_ADDR) || (AE_NUM_TERMS == 0))) 
                                            begin : _FIX_AE_FLAG
                                                assign almost_empty_o = (&aempty_out_w) ; 
                                            end
                                        else
                                            if ((AE_NUM_TERMS == 1)) 
                                                begin : _SING_AE_FLAG
                                                    assign almost_empty_o = (|aempty_out_w) ; 
                                                end
                                            else
                                                begin : _MULT_AE_FLAG
                                                    wire [(FIFO_ADDR - 1):0] aempty_expand_w ; 
                                                    assign almost_empty_o = (|aempty_expand_w) ; 
                                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                                    begin : _EXP_AEFLAG
                                                        wire [(AE_NUM_TERMS - 1):0] nterm_and_w ; 
                                                        assign aempty_expand_w[i0] = (&nterm_and_w) ; 
                                                        for (i1 = 0;(i1 < AE_NUM_TERMS);i1 = (i1 + 1))
                                                        begin : genblk1
                                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                                begin : genblk1
                                                                    assign nterm_and_w[i1] = aempty_out_w[(i0 + i1)] ; 
                                                                end
                                                            else
                                                                begin : genblk1
                                                                    assign nterm_and_w[i1] = aempty_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                                end
                                                        end
                                                    end
                                                end
                                    end
                                else
                                    begin : _DIS_AE_FLAG
                                        assign almost_empty_o = 1'b0 ; 
                                    end
                            end
                        else
                            begin : _R_OVR_W
                                if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                                    begin : _EN_AF_FLAG
                                        if ((AF_FLAG_CNT == 0)) 
                                            begin : genblk1
                                                assign almost_full_o = (&afull_out_w) ; 
                                            end
                                        else
                                            if ((AF_FLAG_CNT == 1)) 
                                                begin : genblk1
                                                    assign almost_full_o = (|afull_out_w) ; 
                                                end
                                            else
                                                begin : genblk1
                                                    wire [(FIFO_ADDR - 1):0] afull_expand_w ; 
                                                    assign almost_full_o = (|afull_expand_w) ; 
                                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                                    begin : _EXP_AFULL_FLAG
                                                        wire [(AF_FLAG_CNT - 1):0] nterm_and_w ; 
                                                        assign afull_expand_w[i0] = (&nterm_and_w) ; 
                                                        for (i1 = 0;(i1 < AF_FLAG_CNT);i1 = (i1 + 1))
                                                        begin : _GEN_MINTERM
                                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                                begin : _PRELOOP
                                                                    assign nterm_and_w[i1] = afull_out_w[(i0 + i1)] ; 
                                                                end
                                                            else
                                                                begin : _POSTLOOP
                                                                    assign nterm_and_w[i1] = afull_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                                end
                                                        end
                                                    end
                                                end
                                    end
                                else
                                    begin : _DIS_AF_FLAG
                                        assign almost_full_o = 1'b0 ; 
                                    end
                                if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                                    begin : _EN_AE_FLAG
                                        if (((AE_NUM_TERMS == FIFO_ADDR) || (AE_NUM_TERMS == 0))) 
                                            begin : _FIX_AE_FLAG
                                                assign almost_empty_o = (&aempty_out_w) ; 
                                            end
                                        else
                                            if ((AE_NUM_TERMS == 1)) 
                                                begin : _SING_AE_FLAG
                                                    assign almost_empty_o = (|aempty_out_w) ; 
                                                end
                                            else
                                                begin : _MULT_AE_FLAG
                                                    wire [(FIFO_ADDR - 1):0] aempty_expand_w ; 
                                                    assign almost_empty_o = (|aempty_expand_w) ; 
                                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                                    begin : _EXP_AEFLAG
                                                        wire [(AE_NUM_TERMS - 1):0] nterm_and_w ; 
                                                        assign aempty_expand_w[i0] = (&nterm_and_w) ; 
                                                        for (i1 = 0;(i1 < AE_NUM_TERMS);i1 = (i1 + 1))
                                                        begin : genblk1
                                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                                begin : genblk1
                                                                    assign nterm_and_w[i1] = aempty_out_w[(i0 + i1)] ; 
                                                                end
                                                            else
                                                                begin : genblk1
                                                                    assign nterm_and_w[i1] = aempty_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                                end
                                                        end
                                                    end
                                                end
                                    end
                                else
                                    begin : _DIS_AE_FLAG
                                        assign almost_empty_o = 1'b0 ; 
                                    end
                            end
                        if ((FULL_CNT == 0)) 
                            begin : _FIX_FULL
                                assign full_o = (&full_out_w) ; 
                            end
                        else
                            if ((FULL_CNT == 1)) 
                                begin : _SING_FULL
                                    assign full_o = (|full_out_w) ; 
                                end
                            else
                                begin : genblk4
                                    wire [(FIFO_ADDR - 1):0] full_expand_w ; 
                                    assign full_o = (|full_expand_w) ; 
                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                    begin : _EXP_FULL_FLAG
                                        wire [(FULL_CNT - 1):0] nterm_and_w ; 
                                        assign full_expand_w[i0] = (&nterm_and_w) ; 
                                        for (i1 = 0;(i1 < FULL_CNT);i1 = (i1 + 1))
                                        begin : _GEN_MINTERM
                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                begin : _PRELOOP
                                                    assign nterm_and_w[i1] = full_out_w[(i0 + i1)] ; 
                                                end
                                            else
                                                begin : _POSTLOOP
                                                    assign nterm_and_w[i1] = full_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                end
                                        end
                                    end
                                end
                    end
            end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] getAEmptyFlag ; 
        input [31:0] flag_assert ; 
        input [31:0] split ; 
        input [31:0] factor ; 
        input IsWGreater ; 
        input IsGetFlagCnt ; 
        reg [31:0] base, 
            prod_spf, 
            per_ebr, 
            excess ; 
        begin
            if ((split == 1)) 
                begin
                    getAEmptyFlag = flag_assert ;
                end
            else
                if (IsWGreater) 
                    begin
                        prod_spf = (split * factor) ;
                        base = 0 ;
                        per_ebr = 0 ;
                        while (((flag_assert - base) > prod_spf))
                            begin
                                base = (base + prod_spf) ;
                                per_ebr = (per_ebr + factor) ;
                            end
                        excess = (flag_assert - base) ;
                        getAEmptyFlag = (per_ebr + (excess % factor)) ;
                        if (IsGetFlagCnt) 
                            begin
                                getAEmptyFlag = (split - (excess / factor)) ;
                            end
                    end
                else
                    begin
                        getAEmptyFlag = (flag_assert / split) ;
                        if (IsGetFlagCnt) 
                            begin
                                getAEmptyFlag = (split - (flag_assert % split)) ;
                            end
                    end
        end
    endfunction
    function [31:0] getAFullFlag ; 
        input [31:0] flag_assert ; 
        input [31:0] split ; 
        input [31:0] factor ; 
        input IsWGreater ; 
        input IsGetFlagCnt ; 
        reg [31:0] diff_chk ; 
        reg [31:0] factor_diff ; 
        begin
            if ((split == 1)) 
                begin
                    getAFullFlag = flag_assert ;
                end
            else
                if (IsWGreater) 
                    begin
                        getAFullFlag = roundUP(flag_assert,
                                split) ;
                        if (IsGetFlagCnt) 
                            begin
                                getAFullFlag = (flag_assert % split) ;
                            end
                    end
                else
                    begin
                        getAFullFlag = (flag_assert / split) ;
                        while (((getAFullFlag % factor) != 0))
                            getAFullFlag = (getAFullFlag - 1) ;
                        diff_chk = (flag_assert - (getAFullFlag * split)) ;
                        factor_diff = 1 ;
                        while ((diff_chk > factor))
                            begin
                                diff_chk = (diff_chk - factor) ;
                                factor_diff = (factor_diff + 1) ;
                            end
                        getAFullFlag = (getAFullFlag + diff_chk) ;
                        if (IsGetFlagCnt) 
                            begin
                                getAFullFlag = factor_diff ;
                            end
                    end
        end
    endfunction
    function [31:0] getFullFlag ; 
        input [31:0] flag ; 
        input [31:0] split ; 
        input [31:0] factor ; 
        input IsWGreater ; 
        input IsGetFlagCnt ; 
        reg [31:0] prod_spf ; 
        begin
            if ((split == 1)) 
                begin
                    getFullFlag = flag ;
                end
            else
                if (IsWGreater) 
                    begin
                        getFullFlag = roundUP(flag,
                                split) ;
                        if (IsGetFlagCnt) 
                            begin
                                getFullFlag = (flag % split) ;
                            end
                    end
                else
                    begin
                        prod_spf = (split * factor) ;
                        getFullFlag = (roundUP(flag,
                                prod_spf) * factor) ;
                        if (IsGetFlagCnt) 
                            begin
                                getFullFlag = (split - (((getFullFlag * split) - flag) / factor)) ;
                            end
                    end
        end
    endfunction
    function [31:0] getBase9 ; 
        input [31:0] base ; 
        input [31:0] fcode ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    case (base)
                    0 : 
                        getBase9 = 36 ;
                    1 : 
                        getBase9 = 18 ;
                    default : 
                        getBase9 = 9 ;
                    endcase 
                end
            default : 
                getBase9 = base ;
            endcase 
        end
    endfunction
    function [31:0] getBase8 ; 
        input [31:0] base ; 
        input [31:0] fcode ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    case (base)
                    0 : 
                        getBase8 = 32 ;
                    1 : 
                        getBase8 = 16 ;
                    2 : 
                        getBase8 = 8 ;
                    3 : 
                        getBase8 = 4 ;
                    4 : 
                        getBase8 = 2 ;
                    default : 
                        getBase8 = 1 ;
                    endcase 
                end
            default : 
                getBase8 = base ;
            endcase 
        end
    endfunction
    function [31:0] getDWIDImpl ; 
        input [31:0] wdepth ; 
        input [31:0] wdwid ; 
        input [31:0] rdepth ; 
        input [31:0] rdwid ; 
        input isTakingWDWID ; 
        input [31:0] fcode ; 
        input IsUsingFastCtrl ; 
        reg [31:0] n0, 
            n1 ; 
        reg [31:0] factor, 
            addrWPart, 
            dataWPart, 
            addrRPart, 
            dataRPart ; 
        reg [31:0] addrWChk, 
            dataWChk, 
            addrRChk, 
            dataRChk ; 
        reg [31:0] UseFIFO, 
            UseADDR, 
            PROD ; 
        reg [31:0] AddrLimit ; 
        begin
            factor = ((wdwid > rdwid) ? (wdwid / rdwid) : (rdwid / wdwid)) ;
            UseFIFO = {32{1'b1}} ;
            UseADDR = {32{1'b1}} ;
            AddrLimit = 5 ;
            if (IsUsingFastCtrl) 
                AddrLimit = 1 ;
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    if ((factor <= 4)) 
                        begin
                            for (n0 = 0 ; (n0 < 3) ; n0 = (n0 + 1))
                                begin
                                    dataWPart = getBase9(n0,
                                            fcode) ;
                                    addrWPart = data_to_addr(dataWPart,
                                            fcode) ;
                                    dataWChk = roundUP(wdwid,
                                            dataWPart) ;
                                    addrWChk = roundUP(wdepth,
                                            addrWPart) ;
                                    for (n1 = 0 ; (n1 < 3) ; n1 = (n1 + 1))
                                        begin
                                            dataRPart = getBase9(n1,
                                                    fcode) ;
                                            addrRPart = data_to_addr(dataRPart,
                                                    fcode) ;
                                            dataRChk = roundUP(rdwid,
                                                    dataRPart) ;
                                            addrRChk = roundUP(rdepth,
                                                    addrRPart) ;
                                            if (((((dataRChk == dataWChk) && (addrWChk == addrRChk)) && (addrWChk <= AddrLimit)) && (addrRPart != addrWPart))) 
                                                begin
                                                    if ((((wdwid % dataWPart) == 0) && ((rdwid % dataRPart) == 0))) 
                                                        begin
                                                            PROD = (dataWChk * addrWChk) ;
                                                            if (((PROD < UseFIFO) || ((PROD == UseFIFO) & (addrWChk < UseADDR)))) 
                                                                begin
                                                                    UseADDR = addrWChk ;
                                                                    UseFIFO = PROD ;
                                                                    getDWIDImpl = (isTakingWDWID ? dataWPart : dataRPart) ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
                    for (n0 = 0 ; (n0 < 6) ; n0 = (n0 + 1))
                        begin
                            dataWPart = getBase8(n0,
                                    fcode) ;
                            addrWPart = data_to_addr(dataWPart,
                                    fcode) ;
                            dataWChk = roundUP(wdwid,
                                    dataWPart) ;
                            addrWChk = roundUP(wdepth,
                                    addrWPart) ;
                            for (n1 = 0 ; (n1 < 6) ; n1 = (n1 + 1))
                                begin
                                    dataRPart = getBase8(n1,
                                            fcode) ;
                                    addrRPart = data_to_addr(dataRPart,
                                            fcode) ;
                                    dataRChk = roundUP(rdwid,
                                            dataRPart) ;
                                    addrRChk = roundUP(rdepth,
                                            addrRPart) ;
                                    if (((((dataRChk == dataWChk) && (addrWChk == addrRChk)) && (addrWChk <= AddrLimit)) && (addrRPart != addrWPart))) 
                                        begin
                                            if ((((wdwid % dataWPart) == 0) && ((rdwid % dataRPart) == 0))) 
                                                begin
                                                    PROD = (dataWChk * addrWChk) ;
                                                    if (((PROD < UseFIFO) || ((PROD == UseFIFO) & (addrWChk < UseADDR)))) 
                                                        begin
                                                            UseADDR = addrWChk ;
                                                            UseFIFO = PROD ;
                                                            getDWIDImpl = (isTakingWDWID ? dataWPart : dataRPart) ;
                                                        end
                                                end
                                        end
                                end
                        end
                end
            default : 
                getDWIDImpl = 0 ;
            endcase 
        end
    endfunction
    function [31:0] procData ; 
        input [31:0] maxData ; 
        input [31:0] fcode ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    procData = 1 ;
                    while ((procData < maxData))
                        begin
                            if ((procData < 8)) 
                                begin
                                    procData = (procData * 2) ;
                                end
                            else
                                begin
                                    if ((procData == 8)) 
                                        begin
                                            procData = 9 ;
                                        end
                                    else
                                        if (((procData % 9) == 0)) 
                                            begin
                                                procData = ((procData / 9) * 16) ;
                                            end
                                        else
                                            begin
                                                procData = ((procData / 8) * 9) ;
                                            end
                                end
                        end
                end
            default : 
                procData = maxData ;
            endcase 
        end
    endfunction
    function [31:0] data_to_addr ; 
        input [31:0] dwid ; 
        input [31:0] fcode ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    case (dwid)
                    36 : 
                        data_to_addr = 511 ;
                    32 : 
                        data_to_addr = 511 ;
                    18 : 
                        data_to_addr = 1023 ;
                    16 : 
                        data_to_addr = 1023 ;
                    9 : 
                        data_to_addr = 2047 ;
                    8 : 
                        data_to_addr = 2047 ;
                    4 : 
                        data_to_addr = 4095 ;
                    2 : 
                        data_to_addr = 8191 ;
                    1 : 
                        data_to_addr = 16383 ;
                    default : 
                        data_to_addr = 511 ;
                    endcase 
                end
            default : 
                data_to_addr = 512 ;
            endcase 
        end
    endfunction
    function [31:0] roundUP ; 
        input [31:0] dividend ; 
        input [31:0] divisor ; 
        begin
            if ((divisor == 1)) 
                begin
                    roundUP = dividend ;
                end
            else
                if ((divisor == dividend)) 
                    begin
                        roundUP = 1 ;
                    end
                else
                    begin
                        roundUP = ((dividend / divisor) + (((dividend % divisor) == 0) ? 0 : 1)) ;
                    end
        end
    endfunction
    function [31:0] FIFOimpl ; 
        input [31:0] DEPTH_IMPL ; 
        input [31:0] WIDTH_IMPL ; 
        input [31:0] ADDR_DEPTH_X ; 
        input [31:0] DATA_WIDTH_X ; 
        begin
            FIFOimpl = (roundUP(DEPTH_IMPL,
                    ADDR_DEPTH_X) * roundUP(WIDTH_IMPL,
                    DATA_WIDTH_X)) ;
        end
    endfunction
    function [31:0] getMinFIFO ; 
        input [31:0] depth ; 
        input [31:0] dwid ; 
        input ecc_en ; 
        input [31:0] fcode ; 
        input IsUsingFastCtrl ; 
        reg [31:0] temp_00, 
            temp_01, 
            temp_02, 
            temp_03, 
            temp_04, 
            temp_05 ; 
        reg [31:0] addr_00, 
            addr_01, 
            addr_02, 
            addr_03, 
            addr_04, 
            addr_05 ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    if (ecc_en) 
                        begin
                            getMinFIFO = 32 ;
                        end
                    else
                        begin
                            temp_00 = FIFOimpl(depth,
                                    dwid,
                                    511,
                                    36) ;
                            temp_01 = FIFOimpl(depth,
                                    dwid,
                                    1023,
                                    18) ;
                            temp_02 = FIFOimpl(depth,
                                    dwid,
                                    2047,
                                    9) ;
                            temp_03 = FIFOimpl(depth,
                                    dwid,
                                    4095,
                                    4) ;
                            temp_04 = FIFOimpl(depth,
                                    dwid,
                                    8191,
                                    2) ;
                            temp_05 = FIFOimpl(depth,
                                    dwid,
                                    16383,
                                    1) ;
                            addr_00 = roundUP(depth,
                                    511) ;
                            addr_01 = roundUP(depth,
                                    1023) ;
                            addr_02 = roundUP(depth,
                                    2047) ;
                            addr_03 = roundUP(depth,
                                    4095) ;
                            addr_04 = roundUP(depth,
                                    8191) ;
                            addr_05 = roundUP(depth,
                                    16383) ;
                            if (IsUsingFastCtrl) 
                                begin
                                    if ((addr_00 > 1)) 
                                        temp_00 = {32{1'b1}} ;
                                    if ((addr_01 > 1)) 
                                        temp_01 = {32{1'b1}} ;
                                    if ((addr_02 > 1)) 
                                        temp_02 = {32{1'b1}} ;
                                    if ((addr_03 > 1)) 
                                        temp_03 = {32{1'b1}} ;
                                    if ((addr_04 > 1)) 
                                        temp_04 = {32{1'b1}} ;
                                    if ((addr_05 > 1)) 
                                        temp_05 = {32{1'b1}} ;
                                end
                            else
                                begin
                                    if ((addr_00 > 5)) 
                                        temp_00 = {32{1'b1}} ;
                                    if ((addr_01 > 5)) 
                                        temp_01 = {32{1'b1}} ;
                                    if ((addr_02 > 5)) 
                                        temp_02 = {32{1'b1}} ;
                                    if ((addr_03 > 5)) 
                                        temp_03 = {32{1'b1}} ;
                                    if ((addr_04 > 5)) 
                                        temp_04 = {32{1'b1}} ;
                                    if ((addr_05 > 5)) 
                                        temp_05 = {32{1'b1}} ;
                                end
                            if ((temp_00 < temp_01)) 
                                begin
                                    if ((temp_00 < temp_02)) 
                                        begin
                                            if ((temp_00 < temp_03)) 
                                                begin
                                                    if ((temp_00 < temp_04)) 
                                                        begin
                                                            if ((temp_00 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 36 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 4 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        begin
                                                            if ((temp_02 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 9 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 4 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                            else
                                begin
                                    if ((temp_01 < temp_02)) 
                                        begin
                                            if ((temp_01 < temp_03)) 
                                                begin
                                                    if ((temp_01 < temp_04)) 
                                                        begin
                                                            if ((temp_01 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 18 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 4 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        begin
                                                            if ((temp_02 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 9 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 4 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
                end
            default : 
                getMinFIFO = dwid ;
            endcase 
        end
    endfunction
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 2.1
// File                  : lscc_fifo_dc_hw_core.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO using an internal 
//                         controller
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module FIFO_A2B_ipgen_lscc_fifo_dc_hw_core #(parameter FAMILY = "LIFCL", 
        parameter WADDR_DEPTH = 512, 
        parameter WDATA_WIDTH = 36, 
        parameter RADDR_DEPTH = 512, 
        parameter RDATA_WIDTH = 36, 
        parameter REGMODE = "reg", 
        parameter RESETMODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 510, 
        parameter ALMOST_FULL_DEASSERT_LVL = 509, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 2, 
        parameter ENABLE_DATA_COUNT_WR = "FALSE", 
        parameter ENABLE_DATA_COUNT_RD = "FALSE", 
        parameter ECC_ENABLE = 0, 
        parameter IS_CASCADE = 0) (
    input wr_clk_i, 
    input wr_en_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input rd_clk_i, 
    input rd_en_i, 
    input rst_i, 
    input rp_rst_i, 
    input full_cascade_i, 
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    if ((FAMILY == "LIFCL")) 
        begin : _LIFCL
            localparam W_FACTOR = (((WDATA_WIDTH == 36) || (WDATA_WIDTH == 32)) ? 32 : (((WDATA_WIDTH == 18) || (WDATA_WIDTH == 16)) ? 16 : (((WDATA_WIDTH == 9) || (WDATA_WIDTH == 8)) ? 8 : ((WDATA_WIDTH == 4) ? 4 : ((WDATA_WIDTH == 2) ? 2 : 1))))) ; 
            localparam R_FACTOR = (((RDATA_WIDTH == 36) || (RDATA_WIDTH == 32)) ? 32 : (((RDATA_WIDTH == 18) || (RDATA_WIDTH == 16)) ? 16 : (((RDATA_WIDTH == 9) || (RDATA_WIDTH == 8)) ? 8 : ((RDATA_WIDTH == 4) ? 4 : ((RDATA_WIDTH == 2) ? 2 : 1))))) ; 
            localparam DWID_W = (((WDATA_WIDTH == 36) || (WDATA_WIDTH == 32)) ? "X36" : (((WDATA_WIDTH == 18) || (WDATA_WIDTH == 16)) ? "X18" : (((WDATA_WIDTH == 9) || (WDATA_WIDTH == 8)) ? "X9" : ((WDATA_WIDTH == 4) ? "X4" : ((WDATA_WIDTH == 2) ? "X2" : "X1"))))) ; 
            localparam DWID_R = (((RDATA_WIDTH == 36) || (RDATA_WIDTH == 32)) ? "X36" : (((RDATA_WIDTH == 18) || (RDATA_WIDTH == 16)) ? "X18" : (((RDATA_WIDTH == 9) || (RDATA_WIDTH == 8)) ? "X9" : ((RDATA_WIDTH == 4) ? "X4" : ((RDATA_WIDTH == 2) ? "X2" : "X1"))))) ; 
            localparam WF_DIFF = ((W_FACTOR <= 2) ? 0 : {{(((W_FACTOR <= 2) + clog2((W_FACTOR - 1))) - 1){1'b1}},
                        1'b0}) ; 
            localparam RF_DIFF = ((R_FACTOR == 1) ? 0 : ((R_FACTOR == 2) ? 1'b1 : {((R_FACTOR <= 2) + clog2((R_FACTOR - 1))){1'b1}})) ; 
            localparam [13:0] W_FULL_FLAG_BIN = (((WADDR_DEPTH * W_FACTOR) > WF_DIFF) ? ((WADDR_DEPTH * W_FACTOR) - WF_DIFF) : 0) ; 
            //localparam [13:0] W_AFULL_FLAG_BIN   = ((ALMOST_FULL_ASSERT_LVL * W_FACTOR) > WF_DIFF) ? (ALMOST_FULL_ASSERT_LVL * W_FACTOR - WF_DIFF) : 0;
            localparam [13:0] W_AFULL_FLAG_BIN = ((ALMOST_FULL_ASSERT_LVL * W_FACTOR) - WF_DIFF) ; 
            localparam [127:0] W_FULL_FLAG_STR = {"0b",
                        (W_FULL_FLAG_BIN[13] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[12] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[11] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[10] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[9] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[8] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[7] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[6] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[5] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[4] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[3] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[2] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[1] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[0] ? "1" : "0")} ; 
            localparam [127:0] W_AFULL_FLAG_STR = {"0b",
                        (W_AFULL_FLAG_BIN[13] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[12] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[11] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[10] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[9] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[8] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[7] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[6] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[5] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[4] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[3] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[2] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[1] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[0] ? "1" : "0")} ; 
            //localparam [13:0]  R_AEMPTY_FLAG_BIN = ((ALMOST_EMPTY_ASSERT_LVL * R_FACTOR + RF_DIFF) < RADDR_DEPTH) ? (ALMOST_EMPTY_ASSERT_LVL * R_FACTOR + RF_DIFF) : RADDR_DEPTH;
            localparam [13:0] R_AEMPTY_FLAG_BIN = ((ALMOST_EMPTY_ASSERT_LVL * R_FACTOR) + RF_DIFF) ; 
            localparam [127:0] R_AEMPTY_FLAG_STR = {"0b",
                        (R_AEMPTY_FLAG_BIN[13] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[12] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[11] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[10] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[9] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[8] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[7] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[6] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[5] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[4] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[3] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[2] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[1] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[0] ? "1" : "0")} ; 
            localparam T_REG = ((REGMODE == "reg") ? "USED" : "BYPASSED") ; 
            localparam T_RST = ((RESETMODE == "sync") ? "SYNC" : "ASYNC") ; 
            localparam T_REL = T_RST ; 
            wire [35:0] di_w ; 
            wire [35:0] do_w ; 
            wire rd_en_w ; 
            wire FULL ; 
            wire EMPTY ; 
            wire ALMOSTFULL ; 
            wire ALMOSTEMPTY ; 
            wire ONEBITERR ; 
            wire TWOBITERR ; 
            wire cascade_chk_w ; 
            reg empty_sync_r ; 
            reg empty_r ; 
            reg aempty_sync_r ; 
            reg aempty_r ; 
            reg full_r ; 
            reg afull_r ; 
            case (WDATA_WIDTH)
            36 : 
                begin: genblk1
                    assign di_w = wr_data_i ; 
                end
            32 : 
                begin : genblk1
                    assign di_w[7:0] = wr_data_i[7:0] ; 
                    assign di_w[16:9] = wr_data_i[15:8] ; 
                    assign di_w[25:18] = wr_data_i[23:16] ; 
                    assign di_w[34:27] = wr_data_i[31:24] ; 
                    assign di_w[8] = 1'b0 ; 
                    assign di_w[17] = 1'b0 ; 
                    assign di_w[26] = 1'b0 ; 
                    assign di_w[35] = 1'b0 ; 
                end
            18 : 
                begin : genblk1
                    assign di_w = {{18{1'b0}},
                                wr_data_i} ; 
                end
            16 : 
                begin : genblk1
                    assign di_w[7:0] = wr_data_i[7:0] ; 
                    assign di_w[16:9] = wr_data_i[15:8] ; 
                    assign di_w[8] = 1'b0 ; 
                    assign di_w[17] = 1'b0 ; 
                    assign di_w[35:18] = {18{1'b0}} ; 
                end
            default : 
                begin : genblk1
                    assign di_w = {{(36 - WDATA_WIDTH){1'b0}},
                                wr_data_i} ; 
                end
            endcase
            if ((REGMODE == "reg")) 
                begin : genblk2
                    always
                        @(posedge rd_clk_i or 
                            posedge EMPTY)
                        begin
                            if (EMPTY) 
                                begin
                                    empty_sync_r <=  1'b1 ;
                                    empty_r <=  1'b1 ;
                                end
                            else
                                begin
                                    empty_sync_r <=  1'b0 ;
                                    empty_r <=  empty_sync_r ;
                                end
                        end
                end
            else
                begin : genblk2
                    always
                        @(posedge rd_clk_i or 
                            posedge EMPTY)
                        begin
                            if (EMPTY) 
                                begin
                                    empty_r <=  1'b1 ;
                                end
                            else
                                begin
                                    empty_r <=  1'b0 ;
                                end
                        end
                end
            if ((REGMODE == "reg")) 
                begin : genblk3
                    always
                        @(posedge rd_clk_i or 
                            posedge ALMOSTEMPTY)
                        begin
                            if (ALMOSTEMPTY) 
                                begin
                                    aempty_sync_r <=  1'b1 ;
                                    aempty_r <=  1'b1 ;
                                end
                            else
                                begin
                                    aempty_sync_r <=  1'b0 ;
                                    aempty_r <=  aempty_sync_r ;
                                end
                        end
                end
            else
                begin : genblk3
                    always
                        @(posedge rd_clk_i or 
                            posedge ALMOSTEMPTY)
                        begin
                            if (ALMOSTEMPTY) 
                                begin
                                    aempty_r <=  1'b1 ;
                                end
                            else
                                begin
                                    aempty_r <=  1'b0 ;
                                end
                        end
                end
            always
                @(posedge wr_clk_i or 
                    posedge FULL)
                begin
                    if (FULL) 
                        begin
                            full_r <=  1'b1 ;
                        end
                    else
                        begin
                            full_r <=  1'b0 ;
                        end
                end
            always
                @(posedge wr_clk_i or 
                    posedge ALMOSTFULL)
                begin
                    if (ALMOSTFULL) 
                        begin
                            afull_r <=  1'b1 ;
                        end
                    else
                        begin
                            afull_r <=  1'b0 ;
                        end
                end
            if ((REGMODE == "noreg")) 
                begin : _NREG
                    case (RDATA_WIDTH)
                    32 : 
                        begin : genblk1
                            assign rd_data_o[7:0] = do_w[7:0] ; 
                            assign rd_data_o[15:8] = do_w[16:9] ; 
                            assign rd_data_o[23:16] = do_w[25:18] ; 
                            assign rd_data_o[31:24] = do_w[34:27] ; 
                        end
                    16 : 
                        begin : genblk1
                            assign rd_data_o[15:8] = do_w[16:9] ; 
                            assign rd_data_o[7:0] = do_w[7:0] ; 
                        end
                    default : 
                        begin: genblk1
                            assign rd_data_o = do_w[(RDATA_WIDTH - 1):0] ; 
                        end
                    endcase
                end
            else
                begin : _REG
                    reg [(RDATA_WIDTH - 1):0] do_r ; 
                    wire [(RDATA_WIDTH - 1):0] do_mix_w ; 
                    assign rd_data_o = do_r ; 
                    case (RDATA_WIDTH)
                    32 : 
                        begin : genblk1
                            assign do_mix_w[7:0] = do_w[7:0] ; 
                            assign do_mix_w[15:8] = do_w[16:9] ; 
                            assign do_mix_w[23:16] = do_w[25:18] ; 
                            assign do_mix_w[31:24] = do_w[34:27] ; 
                        end
                    16 : 
                        begin : genblk1
                            assign do_mix_w[15:8] = do_w[16:9] ; 
                            assign do_mix_w[7:0] = do_w[7:0] ; 
                        end
                    default : 
                        begin: genblk1
                            assign do_mix_w = do_w[(RDATA_WIDTH - 1):0] ; 
                        end
                    endcase
                    if ((RESETMODE == "async")) 
                        begin : async
                            always
                                @(posedge rd_clk_i or 
                                    posedge rst_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            do_r <=  {RDATA_WIDTH{1'b0}} ;
                                        end
                                    else
                                        begin
                                            do_r <=  do_mix_w ;
                                        end
                                end
                        end
                    else
                        begin : sync
                            always
                                @(posedge rd_clk_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            do_r <=  {RDATA_WIDTH{1'b0}} ;
                                        end
                                    else
                                        begin
                                            do_r <=  do_mix_w ;
                                        end
                                end
                        end
                end
            assign rd_en_w = rd_en_i ; 
            assign empty_o = empty_r ; 
            assign almost_empty_o = aempty_r ; 
            assign almost_full_o = afull_r ; 
            assign full_o = full_r ; 
            assign one_err_det_o = ONEBITERR ; 
            assign two_err_det_o = TWOBITERR ; 
            assign cascade_chk_w = (IS_CASCADE ? full_cascade_i : 1'b0) ; 
            FIFO16K fifo16K (.DI(di_w), 
                        .CLKW(wr_clk_i), 
                        .CLKR(rd_clk_i), 
                        .WE(wr_en_i), 
                        .RE(rd_en_w), 
                        .RSTW(rst_i), 
                        .RPRST(rp_rst_i), 
                        .FULLI(FULL), 
                        .EMPTYI(EMPTY), 
                        .CSW({1'b1,
                            cascade_chk_w}), 
                        .CSR(2'b11), 
                        .DO(do_w), 
                        .ONEBITERR(ONEBITERR), 
                        .TWOBITERR(TWOBITERR), 
                        .ALMOSTFULL(ALMOSTFULL), 
                        .FULL(FULL), 
                        .ALMOSTEMPTY(ALMOSTEMPTY), 
                        .EMPTY(EMPTY)) ; 
            defparam fifo16K.DATA_WIDTH_W = DWID_W ; 
            defparam fifo16K.DATA_WIDTH_R = DWID_R ; 
            defparam fifo16K.OUTREG = "BYPASSED" ; 
            defparam fifo16K.RESETMODE = T_RST ; 
            defparam fifo16K.ASYNC_RST_RELEASE = T_REL ; 
            defparam fifo16K.ECC = (ECC_ENABLE ? "ENABLED" : "DISABLED") ; 
            defparam fifo16K.CSDECODE_W = "01" ; 
            defparam fifo16K.CSDECODE_R = "00" ; 
            defparam fifo16K.FULLBITS = W_FULL_FLAG_STR ; 
            defparam fifo16K.ALMOST_FULL = W_AFULL_FLAG_STR ; 
            defparam fifo16K.ALMOST_EMPTY = R_AEMPTY_FLAG_STR ; 
            defparam fifo16K.GSR = "DISABLED" ; 
        end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_soft_fifo_dc.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module FIFO_A2B_ipgen_lscc_soft_fifo_dc #(parameter IMPLEMENTATION = "EBR", 
        parameter WADDR_DEPTH = 512, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 36, 
        parameter RADDR_DEPTH = 512, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 36, 
        parameter REGMODE = "reg", 
        parameter RESETMODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter INIT_FILE = "none", 
        parameter INIT_MODE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 511, 
        parameter ALMOST_FULL_DEASSERT_LVL = 510, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 2, 
        parameter ECC_ENABLE = 0, 
        parameter ENABLE_DATA_COUNT_WR = "FALSE", 
        parameter ENABLE_DATA_COUNT_RD = "FALSE", 
        parameter FAMILY = "LIFCL") (
    //----------------------------
    // Inputs
    //----------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input rp_rst_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_th_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [WADDR_WIDTH:0] wr_data_cnt_o, 
    output [RADDR_WIDTH:0] rd_data_cnt_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    //--end_ports--
    //----------------------------
    // Local Parameters
    //----------------------------
    localparam G_WADDR_WIDTH = (WADDR_WIDTH + 1) ; 
    localparam G_RADDR_WIDTH = (RADDR_WIDTH + 1) ; 
    localparam CMP_WIDTH = ((WADDR_WIDTH >= RADDR_WIDTH) ? (RADDR_WIDTH + 1) : (WADDR_WIDTH + 1)) ; 
    genvar i0, 
        i1 ; 
    generate
        //----------------------------
        // Wire and Registers
        //----------------------------
        // -- Write-Synced Signals --
        reg full_r ; 
        reg full_ext_r ; 
        reg [WADDR_WIDTH:0] wr_addr_r ; 
        reg [WADDR_WIDTH:0] wr_addr_arith_r ; 
        reg [WADDR_WIDTH:0] wr_addr_nxt_c ; 
        wire [(WADDR_WIDTH - 1):0] wr_mem_addr_w = wr_addr_r[(WADDR_WIDTH - 1):0] ; 
        wire [WADDR_WIDTH:0] wr_addr_p1_w = (wr_addr_r + 1'b1) ; 
        reg [(G_RADDR_WIDTH - 1):0] rp_sync1_r ; 
        reg [(G_RADDR_WIDTH - 1):0] rp_sync2_r ; 
        wire [(G_WADDR_WIDTH - 1):0] wr_grey_w ; 
        reg [(G_WADDR_WIDTH - 1):0] wr_grey_sync_r ; 
        wire [RADDR_WIDTH:0] rp_sync_w ; 
        wire [(CMP_WIDTH - 1):0] wr_cmp_wr_w = wr_addr_p1_w[WADDR_WIDTH:((WADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [(CMP_WIDTH - 1):0] rd_cmp_wr_w = rp_sync_w[RADDR_WIDTH:((RADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [(CMP_WIDTH - 2):0] wr_cmp_mem_wr_w = wr_cmp_wr_w[(CMP_WIDTH - 2):0] ; 
        wire [(CMP_WIDTH - 2):0] rd_cmp_mem_wr_w = rd_cmp_wr_w[(CMP_WIDTH - 2):0] ; 
        wire [(CMP_WIDTH - 2):0] wr_cur_mem_wr_w = wr_mem_addr_w[(WADDR_WIDTH - 1):((WADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [WADDR_WIDTH:0] wr_sig_rd_w ; 
        wire [WADDR_WIDTH:0] wr_sig_diff0_w = (wr_addr_arith_r - wr_sig_rd_w) ; 
        reg full_nxt_c ; 
        // -- Read-Synced Signals --
        reg empty_r ; 
        reg empty_ext_r ; 
        reg [RADDR_WIDTH:0] rd_addr_r ; 
        reg [RADDR_WIDTH:0] rd_addr_arith_r ; 
        reg [RADDR_WIDTH:0] rd_addr_nxt_c ; 
        wire [(RADDR_WIDTH - 1):0] rd_mem_addr_w = rd_addr_r[(RADDR_WIDTH - 1):0] ; 
        wire [RADDR_WIDTH:0] rd_addr_p1_w = (rd_addr_r + 1'b1) ; 
        reg [(G_WADDR_WIDTH - 1):0] wp_sync1_r ; 
        reg [(G_WADDR_WIDTH - 1):0] wp_sync2_r ; 
        wire [(G_RADDR_WIDTH - 1):0] rd_grey_w ; 
        reg [(G_RADDR_WIDTH - 1):0] rd_grey_sync_r ; 
        wire [WADDR_WIDTH:0] wp_sync_w ; 
        wire [(CMP_WIDTH - 1):0] rd_cmp_rd_w = rd_addr_p1_w[RADDR_WIDTH:((RADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [(CMP_WIDTH - 1):0] wr_cmp_rd_w = wp_sync_w[WADDR_WIDTH:((WADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [(CMP_WIDTH - 2):0] wr_cmp_mem_rd_w = wr_cmp_rd_w[(CMP_WIDTH - 2):0] ; 
        wire [(CMP_WIDTH - 2):0] rd_cmp_mem_rd_w = rd_cmp_rd_w[(CMP_WIDTH - 2):0] ; 
        wire [(CMP_WIDTH - 2):0] rd_cur_mem_rd_w = rd_mem_addr_w[(RADDR_WIDTH - 1):((RADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [RADDR_WIDTH:0] rd_sig_wr_w ; 
        wire [RADDR_WIDTH:0] rd_sig_diff0_w = (rd_sig_wr_w - rd_addr_arith_r) ; 
        reg empty_nxt_c ; 
        wire [RADDR_WIDTH:0] full_addr_w ; 
        // -- Top-Level Assignments --
        assign full_o = full_ext_r ; 
        assign empty_o = empty_ext_r ; 
        // -- Global Signals -- 
        wire wr_fifo_en_w = (wr_en_i & (~full_r)) ; 
        wire rd_fifo_en_w = (rd_en_i & (~empty_r)) ; 
        //----------------------------------------
        // Register Initialization for Simulation
        //----------------------------------------
        genvar gri0 ; 
        //----------------------------
        // Behavioral Model
        //----------------------------
        // ----------------------
        // -- WRITE CONTROLLER --
        // ----------------------
        // -- wr_grey_encode --
        assign wr_grey_w = (wr_addr_nxt_c ^ (wr_addr_nxt_c >> 1)) ; 
        if ((RESETMODE == "sync")) 
            begin : wr_encode_sync
                always
                    @(posedge wr_clk_i)
                    begin
                        if (rst_i) 
                            begin
                                wr_grey_sync_r <=  {G_WADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                wr_grey_sync_r <=  wr_grey_w ;
                            end
                    end
            end
        else
            begin : wr_encode_async
                always
                    @(posedge wr_clk_i or 
                        posedge rst_i)
                    begin
                        if (rst_i) 
                            begin
                                wr_grey_sync_r <=  {G_WADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                wr_grey_sync_r <=  wr_grey_w ;
                            end
                    end
            end
        // -- rd_grey_decode --  
        for (gri0 = 0;(gri0 < G_RADDR_WIDTH);gri0 = (gri0 + 1))
        begin : genblk2
            assign rp_sync_w[gri0] = (^rp_sync2_r[(G_RADDR_WIDTH - 1):gri0]) ; 
        end
        // ---------------------------
        // -- Core Write Controller --
        // ---------------------------
        wire wr_sig_mv_w = (wr_en_i & (~full_r)) ; 
        wire full_cmp_w = (wr_cmp_mem_wr_w == rd_cmp_mem_wr_w) ; 
        wire full_rel_cmp_w = (wr_cur_mem_wr_w == rd_cmp_mem_wr_w) ; 
        wire full_max_w = (wr_cmp_wr_w[(CMP_WIDTH - 1)] ^ rd_cmp_wr_w[(CMP_WIDTH - 1)]) ; 
        always
            @(*)
            begin
                full_nxt_c = ((~rp_rst_i) & (wr_sig_mv_w ? (full_cmp_w & full_max_w) : (full_rel_cmp_w & full_r))) ;
            end
        always
            @(*)
            begin
                wr_addr_nxt_c = ((wr_sig_mv_w & (~rp_rst_i)) ? wr_addr_p1_w : wr_addr_r) ;
            end
        if ((RESETMODE == "sync")) 
            begin : sync_wr_controller
                always
                    @(posedge wr_clk_i)
                    begin
                        if (rst_i) 
                            begin
                                wr_addr_r <=  {WADDR_WIDTH{1'b0}} ;
                                wr_addr_arith_r <=  {WADDR_WIDTH{1'b0}} ;
                                full_r <=  1'b0 ;
                                full_ext_r <=  1'b0 ;
                            end
                        else
                            begin
                                wr_addr_r <=  wr_addr_nxt_c ;
                                wr_addr_arith_r <=  wr_addr_nxt_c ;
                                full_r <=  full_nxt_c ;
                                full_ext_r <=  full_nxt_c ;
                            end
                    end
            end
        else
            begin : async_wr_controller
                always
                    @(posedge wr_clk_i or 
                        posedge rst_i)
                    begin
                        if (rst_i) 
                            begin
                                wr_addr_r <=  {WADDR_WIDTH{1'b0}} ;
                                wr_addr_arith_r <=  {WADDR_WIDTH{1'b0}} ;
                                full_r <=  1'b0 ;
                                full_ext_r <=  1'b0 ;
                            end
                        else
                            begin
                                wr_addr_r <=  wr_addr_nxt_c ;
                                wr_addr_arith_r <=  wr_addr_nxt_c ;
                                full_r <=  full_nxt_c ;
                                full_ext_r <=  full_nxt_c ;
                            end
                    end
            end
        // -- Read to Write Synchronizer --
        if ((RESETMODE == "sync")) 
            begin : genblk4
                always
                    @(posedge wr_clk_i)
                    begin
                        if ((rst_i == 1'b1)) 
                            begin
                                rp_sync1_r <=  {G_RADDR_WIDTH{1'b0}} ;
                                rp_sync2_r <=  {G_RADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                rp_sync1_r <=  rd_grey_sync_r ;
                                rp_sync2_r <=  rp_sync1_r ;
                            end
                    end
            end
        else
            begin : genblk4
                always
                    @(posedge wr_clk_i or 
                        posedge rst_i)
                    begin
                        if ((rst_i == 1'b1)) 
                            begin
                                rp_sync1_r <=  {G_RADDR_WIDTH{1'b0}} ;
                                rp_sync2_r <=  {G_RADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                rp_sync1_r <=  rd_grey_sync_r ;
                                rp_sync2_r <=  rp_sync1_r ;
                            end
                    end
            end
        // -- Routing for WR difference signals --
        if ((WADDR_WIDTH > RADDR_WIDTH)) 
            begin : genblk5
                assign wr_sig_rd_w = {rp_sync_w,
                            {(WADDR_WIDTH - RADDR_WIDTH){1'b0}}} ; 
            end
        else
            begin : genblk5
                assign wr_sig_rd_w = rp_sync_w[RADDR_WIDTH:(RADDR_WIDTH - WADDR_WIDTH)] ; 
            end
        // -- Almost Full Flag Controller --
        if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
            begin : afull_flag_impl
                wire [(WADDR_WIDTH - 1):0] almost_full_tick_w = (((ALMOST_FULL_ASSERTION == "static-single") || (ALMOST_FULL_ASSERTION == "static-dual")) ? ALMOST_FULL_ASSERT_LVL : almost_full_th_i) ; 
                wire [(WADDR_WIDTH - 1):0] almost_full_tock_w = ((ALMOST_FULL_ASSERTION == "static-single") ? ALMOST_FULL_ASSERT_LVL : ((ALMOST_FULL_ASSERTION == "static-dual") ? ALMOST_FULL_DEASSERT_LVL : ((ALMOST_FULL_ASSERTION == "dynamic-single") ? almost_full_th_i : almost_full_clr_th_i))) ; 
                reg af_flag_r ; 
                reg af_flag_ext_r ; 
                wire af_flag_p_w ; 
                wire af_flag_n_w ; 
                wire af_flag_nxt_w ; 
                assign af_flag_p_w = (~(wr_sig_diff0_w < (almost_full_tick_w - wr_en_i))) ; 
                assign af_flag_n_w = (wr_sig_diff0_w > almost_full_tock_w) ; 
                assign af_flag_nxt_w = (af_flag_p_w | (af_flag_n_w & af_flag_r)) ; 
                assign almost_full_o = af_flag_ext_r ; 
                if ((RESETMODE == "sync")) 
                    begin : sync
                        always
                            @(posedge wr_clk_i)
                            begin
                                if ((rst_i == 1'b1)) 
                                    begin
                                        af_flag_r <=  1'b0 ;
                                        af_flag_ext_r <=  1'b0 ;
                                    end
                                else
                                    begin
                                        af_flag_r <=  af_flag_nxt_w ;
                                        af_flag_ext_r <=  af_flag_nxt_w ;
                                    end
                            end
                    end
                else
                    begin : async
                        always
                            @(posedge wr_clk_i or 
                                posedge rst_i)
                            begin
                                if ((rst_i == 1'b1)) 
                                    begin
                                        af_flag_r <=  1'b0 ;
                                        af_flag_ext_r <=  1'b0 ;
                                    end
                                else
                                    begin
                                        af_flag_r <=  af_flag_nxt_w ;
                                        af_flag_ext_r <=  af_flag_nxt_w ;
                                    end
                            end
                    end
            end
        else
            begin : genblk6
                assign almost_full_o = 1'b0 ; 
            end
        // -- Enable WR Data Count Controller --
        if ((ENABLE_DATA_COUNT_WR == "TRUE")) 
            begin : en_wr_cnt
                reg [WADDR_WIDTH:0] wr_counter_r ; 
                assign wr_data_cnt_o = wr_counter_r ; 
                if ((RESETMODE == "sync")) 
                    begin : genblk1
                        always
                            @(posedge wr_clk_i)
                            begin
                                if (rst_i) 
                                    begin
                                        wr_counter_r <=  {(WADDR_WIDTH + 1){1'b0}} ;
                                    end
                                else
                                    begin
                                        wr_counter_r <=  wr_sig_diff0_w ;
                                    end
                            end
                    end
                else
                    begin : genblk1
                        always
                            @(posedge wr_clk_i or 
                                posedge rst_i)
                            begin
                                if (rst_i) 
                                    begin
                                        wr_counter_r <=  {(WADDR_WIDTH + 1){1'b0}} ;
                                    end
                                else
                                    begin
                                        wr_counter_r <=  wr_sig_diff0_w ;
                                    end
                            end
                    end
            end
        else
            begin : genblk7
                assign wr_data_cnt_o = {(WADDR_WIDTH + 1){1'b0}} ; 
            end
        // ---------------------
        // -- READ CONTROLLER --
        // ---------------------
        // -- Full Address for rp_rst_i --
        if ((WADDR_WIDTH >= RADDR_WIDTH)) 
            begin : full_addr_e
                assign full_addr_w = {(~wp_sync_w[WADDR_WIDTH]),
                            wp_sync_w[(WADDR_WIDTH - 1):(WADDR_WIDTH - RADDR_WIDTH)]} ; 
            end
        else
            begin : full_addr_o
                assign full_addr_w = {(~wp_sync_w[WADDR_WIDTH]),
                            wp_sync_w[(WADDR_WIDTH - 1):0],
                            {(RADDR_WIDTH - WADDR_WIDTH){1'b0}}} ; 
            end
        // -- rd_grey_encode --
        assign rd_grey_w = (rd_addr_nxt_c ^ (rd_addr_nxt_c >> 1)) ; 
        if ((RESETMODE == "sync")) 
            begin : rd_encode_sync
                always
                    @(posedge rd_clk_i)
                    begin
                        if (rst_i) 
                            begin
                                rd_grey_sync_r <=  {G_RADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                rd_grey_sync_r <=  rd_grey_w ;
                            end
                    end
            end
        else
            begin : rd_encode_async
                always
                    @(posedge rd_clk_i or 
                        posedge rst_i)
                    begin
                        if (rst_i) 
                            begin
                                rd_grey_sync_r <=  {G_RADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                rd_grey_sync_r <=  rd_grey_w ;
                            end
                    end
            end
        // -- wr_grey_decode --
        for (gri0 = 0;(gri0 < G_WADDR_WIDTH);gri0 = (gri0 + 1))
        begin : genblk10
            assign wp_sync_w[gri0] = (^wp_sync2_r[(G_WADDR_WIDTH - 1):gri0]) ; 
        end
        // ---------------------------
        // -- Core Read Controller --
        // ---------------------------
        wire empty_cmp_w = (wr_cmp_rd_w == rd_cmp_rd_w) ; 
        wire empty_rel_cmp_w = (rd_cur_mem_rd_w == wr_cmp_mem_rd_w) ; 
        wire rd_sig_mv_w = (rd_en_i & (~empty_r)) ; 
        always
            @(*)
            begin
                rd_addr_nxt_c = (rp_rst_i ? full_addr_w : (rd_sig_mv_w ? rd_addr_p1_w : rd_addr_r)) ;
            end
        always
            @(*)
            begin
                empty_nxt_c = ((~rp_rst_i) & (rd_sig_mv_w ? empty_cmp_w : (empty_rel_cmp_w & empty_r))) ;
            end
        if ((RESETMODE == "sync")) 
            begin : sync_rd_controller
                always
                    @(posedge rd_clk_i)
                    begin
                        if (rst_i) 
                            begin
                                empty_r <=  1'b1 ;
                                empty_ext_r <=  1'b1 ;
                                rd_addr_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                                rd_addr_arith_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                            end
                        else
                            begin
                                empty_r <=  empty_nxt_c ;
                                empty_ext_r <=  empty_nxt_c ;
                                rd_addr_r <=  rd_addr_nxt_c ;
                                rd_addr_arith_r <=  rd_addr_nxt_c ;
                            end
                    end
            end
        else
            begin : async_rd_controller
                always
                    @(posedge rd_clk_i or 
                        posedge rst_i)
                    begin
                        if (rst_i) 
                            begin
                                empty_r <=  1'b1 ;
                                empty_ext_r <=  1'b1 ;
                                rd_addr_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                                rd_addr_arith_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                            end
                        else
                            begin
                                empty_r <=  empty_nxt_c ;
                                empty_ext_r <=  empty_nxt_c ;
                                rd_addr_r <=  rd_addr_nxt_c ;
                                rd_addr_arith_r <=  rd_addr_nxt_c ;
                            end
                    end
            end
        // -- Write to Read Synchronizer --
        if ((RESETMODE == "sync")) 
            begin : genblk12
                always
                    @(posedge rd_clk_i)
                    begin
                        if ((rst_i == 1'b1)) 
                            begin
                                wp_sync1_r <=  {G_WADDR_WIDTH{1'b0}} ;
                                wp_sync2_r <=  {G_WADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                wp_sync1_r <=  wr_grey_sync_r ;
                                wp_sync2_r <=  wp_sync1_r ;
                            end
                    end
            end
        else
            begin : genblk12
                always
                    @(posedge rd_clk_i or 
                        posedge rst_i)
                    begin
                        if ((rst_i == 1'b1)) 
                            begin
                                wp_sync1_r <=  {G_WADDR_WIDTH{1'b0}} ;
                                wp_sync2_r <=  {G_WADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                wp_sync1_r <=  wr_grey_sync_r ;
                                wp_sync2_r <=  wp_sync1_r ;
                            end
                    end
            end
        // -- Routing for RD difference signals --
        if ((RADDR_WIDTH > WADDR_WIDTH)) 
            begin : genblk13
                assign rd_sig_wr_w = {wp_sync_w,
                            {(RADDR_WIDTH - WADDR_WIDTH){1'b0}}} ; 
            end
        else
            begin : genblk13
                assign rd_sig_wr_w = wp_sync_w[WADDR_WIDTH:(WADDR_WIDTH - RADDR_WIDTH)] ; 
            end
        // -- Almost Empty Flag Controller --
        if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
            begin : aempty_flag_impl
                wire [(RADDR_WIDTH - 1):0] almost_empty_tick_w = (((ALMOST_EMPTY_ASSERTION == "static-single") || (ALMOST_EMPTY_ASSERTION == "static-dual")) ? ALMOST_EMPTY_ASSERT_LVL : almost_empty_th_i) ; 
                wire [(RADDR_WIDTH - 1):0] almost_empty_tock_w = ((ALMOST_EMPTY_ASSERTION == "static-single") ? ALMOST_EMPTY_ASSERT_LVL : ((ALMOST_EMPTY_ASSERTION == "static-dual") ? ALMOST_EMPTY_DEASSERT_LVL : ((ALMOST_EMPTY_ASSERTION == "dynamic-single") ? almost_empty_th_i : almost_empty_clr_th_i))) ; 
                reg ae_flag_r ; 
                reg ae_flag_ext_r ; 
                wire ae_flag_pos_w ; 
                wire ae_flag_neg_w ; 
                wire ae_flag_nxt_w ; 
                assign ae_flag_pos_w = (~(rd_sig_diff0_w > (almost_empty_tick_w + rd_en_i))) ; 
                assign ae_flag_neg_w = (rd_sig_diff0_w < almost_empty_tock_w) ; 
                assign ae_flag_nxt_w = (ae_flag_pos_w | (ae_flag_neg_w & ae_flag_r)) ; 
                assign almost_empty_o = ae_flag_ext_r ; 
                if ((RESETMODE == "sync")) 
                    begin : sync
                        always
                            @(posedge rd_clk_i)
                            begin
                                if (rst_i) 
                                    begin
                                        ae_flag_ext_r <=  1'b1 ;
                                        ae_flag_r <=  1'b1 ;
                                    end
                                else
                                    begin
                                        ae_flag_ext_r <=  ae_flag_nxt_w ;
                                        ae_flag_r <=  ae_flag_nxt_w ;
                                    end
                            end
                    end
                else
                    begin : async
                        always
                            @(posedge rd_clk_i or 
                                posedge rst_i)
                            begin
                                if (rst_i) 
                                    begin
                                        ae_flag_ext_r <=  1'b1 ;
                                        ae_flag_r <=  1'b1 ;
                                    end
                                else
                                    begin
                                        ae_flag_ext_r <=  ae_flag_nxt_w ;
                                        ae_flag_r <=  ae_flag_nxt_w ;
                                    end
                            end
                    end
            end
        else
            begin : genblk14
                assign almost_empty_o = 1'b0 ; 
            end
        // -- Enable RD Data Count Controller --
        if ((ENABLE_DATA_COUNT_RD == "TRUE")) 
            begin : en_rd_cnt
                reg [RADDR_WIDTH:0] rd_counter_r ; 
                assign rd_data_cnt_o = rd_counter_r ; 
                if ((RESETMODE == "sync")) 
                    begin : genblk1
                        always
                            @(posedge rd_clk_i)
                            begin
                                if (rst_i) 
                                    begin
                                        rd_counter_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                                    end
                                else
                                    begin
                                        rd_counter_r <=  rd_sig_diff0_w ;
                                    end
                            end
                    end
                else
                    begin : genblk1
                        always
                            @(posedge rd_clk_i or 
                                posedge rst_i)
                            begin
                                if (rst_i) 
                                    begin
                                        rd_counter_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                                    end
                                else
                                    begin
                                        rd_counter_r <=  rd_sig_diff0_w ;
                                    end
                            end
                    end
            end
        else
            begin : dis_rd_cnt
                assign rd_data_cnt_o = {(RADDR_WIDTH + 1){1'b0}} ; 
            end
        wire t_rd_fifo_en_w ; 
        reg rd_prev_r ; 
        if ((REGMODE == "noreg")) 
            begin : genblk16
                assign t_rd_fifo_en_w = rd_fifo_en_w ; 
            end
        else
            begin : genblk16
                assign t_rd_fifo_en_w = (rd_fifo_en_w | rd_prev_r) ; 
                if ((RESETMODE == "sync")) 
                    begin : genblk1
                        always
                            @(posedge rd_clk_i)
                            begin
                                if (rst_i) 
                                    begin
                                        rd_prev_r <=  1'b0 ;
                                    end
                                else
                                    begin
                                        rd_prev_r <=  rd_fifo_en_w ;
                                    end
                            end
                    end
                else
                    begin : genblk1
                        always
                            @(posedge rd_clk_i or 
                                posedge rst_i)
                            begin
                                if (rst_i) 
                                    begin
                                        rd_prev_r <=  1'b0 ;
                                    end
                                else
                                    begin
                                        rd_prev_r <=  rd_fifo_en_w ;
                                    end
                            end
                    end
            end
        // --------------------------
        // -- FIFO Memory Instance --
        // --------------------------
        if ((IMPLEMENTATION == "EBR")) 
            begin : EBR
                if ((FAMILY == "LIFCL")) 
                    begin : EBR_LIFCL
                        wire [(RDATA_WIDTH - 1):0] rd_data_ebr ; 
                        reg [(RDATA_WIDTH - 1):0] rd_data_ebr_r ; 
                        FIFO_A2B_ipgen_lscc_fifo_mem #(.FAMILY(FAMILY),
                                .WADDR_DEPTH(WADDR_DEPTH),
                                .WADDR_WIDTH(WADDR_WIDTH),
                                .WDATA_WIDTH(WDATA_WIDTH),
                                .RADDR_DEPTH(RADDR_DEPTH),
                                .RADDR_WIDTH(RADDR_WIDTH),
                                .RDATA_WIDTH(RDATA_WIDTH),
                                .REGMODE("noreg"),
                                .RESETMODE(RESETMODE),
                                .RESET_RELEASE("sync"),
                                .BYTE_ENABLE(0),
                                .BYTE_WIDTH(1),
                                .ECC_ENABLE(ECC_ENABLE)) u_fifo_mem0 (.wr_clk_i(wr_clk_i), 
                                    .rd_clk_i(rd_clk_i), 
                                    .rst_i(rp_rst_i), 
                                    .wr_clk_en_i(wr_fifo_en_w), 
                                    .rd_clk_en_i(t_rd_fifo_en_w), 
                                    .rd_out_clk_en_i(1'b1), 
                                    .wr_en_i(wr_fifo_en_w), 
                                    .wr_data_i(wr_data_i), 
                                    .wr_addr_i(wr_mem_addr_w), 
                                    .rd_en_i(rd_fifo_en_w), 
                                    .rd_addr_i(rd_mem_addr_w), 
                                    .ben_i(1'b1), 
                                    .rd_data_o(rd_data_ebr), 
                                    .one_err_det_o(one_err_det_o), 
                                    .two_err_det_o(two_err_det_o)) ; 
                        if ((REGMODE == "reg")) 
                            begin : genblk1
                                wire t_read_enable = rd_prev_r ; 
                                assign rd_data_o = rd_data_ebr_r ; 
                                if ((RESETMODE == "async")) 
                                    begin : async
                                        always
                                            @(posedge rd_clk_i or 
                                                posedge rp_rst_i)
                                            begin
                                                if (rp_rst_i) 
                                                    begin
                                                        rd_data_ebr_r <=  'h0 ;
                                                    end
                                                else
                                                    if (t_read_enable) 
                                                        begin
                                                            rd_data_ebr_r <=  rd_data_ebr ;
                                                        end
                                            end
                                    end
                                else
                                    begin : sync
                                        always
                                            @(posedge rd_clk_i)
                                            begin
                                                if (rp_rst_i) 
                                                    begin
                                                        rd_data_ebr_r <=  'h0 ;
                                                    end
                                                else
                                                    if (t_read_enable) 
                                                        begin
                                                            rd_data_ebr_r <=  rd_data_ebr ;
                                                        end
                                            end
                                    end
                            end
                        else
                            begin : genblk1
                                assign rd_data_o = rd_data_ebr ; 
                            end
                    end
                else
                    begin : EBR_OTHER
                        FIFO_A2B_ipgen_lscc_fifo_mem #(.FAMILY(FAMILY),
                                .WADDR_DEPTH(WADDR_DEPTH),
                                .WADDR_WIDTH(WADDR_WIDTH),
                                .WDATA_WIDTH(WDATA_WIDTH),
                                .RADDR_DEPTH(RADDR_DEPTH),
                                .RADDR_WIDTH(RADDR_WIDTH),
                                .RDATA_WIDTH(RDATA_WIDTH),
                                .REGMODE(REGMODE),
                                .RESETMODE(RESETMODE),
                                .RESET_RELEASE("sync"),
                                .BYTE_ENABLE(0),
                                .BYTE_WIDTH(1),
                                .ECC_ENABLE(ECC_ENABLE)) u_fifo_mem0 (.wr_clk_i(wr_clk_i), 
                                    .rd_clk_i(rd_clk_i), 
                                    .rst_i(rp_rst_i), 
                                    .wr_clk_en_i(wr_fifo_en_w), 
                                    .rd_clk_en_i(t_rd_fifo_en_w), 
                                    .rd_out_clk_en_i(1'b1), 
                                    .wr_en_i(wr_fifo_en_w), 
                                    .wr_data_i(wr_data_i), 
                                    .wr_addr_i(wr_mem_addr_w), 
                                    .rd_en_i(rd_fifo_en_w), 
                                    .rd_addr_i(rd_mem_addr_w), 
                                    .ben_i(1'b1), 
                                    .rd_data_o(rd_data_o), 
                                    .one_err_det_o(one_err_det_o), 
                                    .two_err_det_o(two_err_det_o)) ; 
                    end
            end
        else
            if ((FAMILY == "LIFCL")) 
                begin : DIST
                    (* syn_ramstyle="distributed" *) reg [(RDATA_WIDTH - 1):0] mem [((2 ** RADDR_WIDTH) - 1):0] ; 
                    wire [(RDATA_WIDTH - 1):0] mem_raw ; 
                    reg [(RDATA_WIDTH - 1):0] out_raw ; 
                    reg [(RDATA_WIDTH - 1):0] out_buffer ; 
                    wire write_enable = wr_fifo_en_w ; 
                    wire read_enable = t_rd_fifo_en_w ; 
                    wire t_read_enable = rd_prev_r ; 
                    assign rd_data_o = ((REGMODE == "noreg") ? out_raw : out_buffer) ; 
                    always
                        @(posedge wr_clk_i)
                        begin
                            if ((write_enable == 1'b1)) 
                                begin
                                    mem[wr_mem_addr_w] <=  wr_data_i ;
                                end
                        end
                    assign mem_raw = mem[rd_mem_addr_w] ; 
                    always
                        @(posedge rd_clk_i)
                        begin
                            if (read_enable) 
                                begin
                                    out_raw <=  mem_raw ;
                                end
                        end
                    if ((REGMODE == "reg")) 
                        begin : genblk1
                            if ((RESETMODE == "async")) 
                                begin : async
                                    always
                                        @(posedge rd_clk_i or 
                                            posedge rst_i)
                                        begin
                                            if (rst_i) 
                                                begin
                                                    out_buffer <=  'h0 ;
                                                end
                                            else
                                                if (t_read_enable) 
                                                    begin
                                                        out_buffer <=  out_raw ;
                                                    end
                                        end
                                end
                            else
                                begin : sync
                                    always
                                        @(posedge rd_clk_i)
                                        begin
                                            if (rst_i) 
                                                begin
                                                    out_buffer <=  'h0 ;
                                                end
                                            else
                                                if (t_read_enable) 
                                                    begin
                                                        out_buffer <=  out_raw ;
                                                    end
                                        end
                                end
                        end
                end
            else
                begin : REG
                    (* syn_ramstyle="registers" *) reg [(RDATA_WIDTH - 1):0] mem [((2 ** RADDR_WIDTH) - 1):0] ; 
                    wire [(RDATA_WIDTH - 1):0] mem_raw ; 
                    reg [(RDATA_WIDTH - 1):0] out_raw ; 
                    reg [(RDATA_WIDTH - 1):0] out_buffer ; 
                    wire write_enable = wr_fifo_en_w ; 
                    wire read_enable = t_rd_fifo_en_w ; 
                    wire t_read_enable = rd_prev_r ; 
                    assign rd_data_o = ((REGMODE == "noreg") ? out_raw : out_buffer) ; 
                    always
                        @(posedge wr_clk_i)
                        begin
                            if ((write_enable == 1'b1)) 
                                begin
                                    mem[wr_mem_addr_w] <=  wr_data_i ;
                                end
                        end
                    assign mem_raw = mem[rd_mem_addr_w] ; 
                    always
                        @(posedge rd_clk_i)
                        begin
                            if (read_enable) 
                                begin
                                    out_raw <=  mem_raw ;
                                end
                        end
                    if ((REGMODE == "reg")) 
                        begin : genblk1
                            if ((RESETMODE == "async")) 
                                begin : async
                                    always
                                        @(posedge rd_clk_i or 
                                            posedge rst_i)
                                        begin
                                            if (rst_i) 
                                                begin
                                                    out_buffer <=  'h0 ;
                                                end
                                            else
                                                if (t_read_enable) 
                                                    begin
                                                        out_buffer <=  out_raw ;
                                                    end
                                        end
                                end
                            else
                                begin : sync
                                    always
                                        @(posedge rd_clk_i)
                                        begin
                                            if (rst_i) 
                                                begin
                                                    out_buffer <=  'h0 ;
                                                end
                                            else
                                                if (t_read_enable) 
                                                    begin
                                                        out_buffer <=  out_raw ;
                                                    end
                                        end
                                end
                        end
                end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_fifo_mem.v
// Title                 :
// Dependencies          :
// Description           : Implements a pseudo Dual Port RAM using EBR.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.1.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module FIFO_A2B_ipgen_lscc_fifo_mem #(parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "18,1024", 
        parameter FAMILY = "common", 
        parameter WADDR_DEPTH = 1024, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 18, 
        parameter RADDR_DEPTH = 1024, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 18, 
        parameter REGMODE = "reg", 
        parameter GSR = "enable", 
        parameter RESETMODE = "sync", 
        parameter RESET_RELEASE = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter MODULE_TYPE = "ram_dp", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE = 1, 
        parameter BYTE_SIZE = 9, 
        parameter BYTE_WIDTH = (WDATA_WIDTH / BYTE_SIZE), 
        parameter PIPELINES = 0, 
        parameter ECC_ENABLE = 0, 
        parameter OUTPUT_CLK_EN = 0, 
        parameter BYTE_ENABLE_POL = "active-high", 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_40 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_41 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_42 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_43 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_44 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_45 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_46 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_47 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_48 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_49 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_50 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_51 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_52 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_53 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_54 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_55 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_56 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_57 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_58 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_59 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_60 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_61 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_62 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_63 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_64 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_65 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_66 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_67 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_68 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_69 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_70 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_71 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_72 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_73 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_74 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_75 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_76 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_77 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_78 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_79 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7F = "0x0000000000000000000000000000000000000000000000000000000000000000") (
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input rst_i, 
    input wr_clk_en_i, 
    input rd_clk_en_i, 
    input rd_out_clk_en_i, 
    input wr_en_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input [(WADDR_WIDTH - 1):0] wr_addr_i, 
    input rd_en_i, 
    input [(RADDR_WIDTH - 1):0] rd_addr_i, 
    input [(BYTE_WIDTH - 1):0] ben_i, 
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    localparam T_FAMILY = ((((((FAMILY == "LFD2NX") || (FAMILY == "LFCPNX")) || (FAMILY == "LFMXO5")) || (FAMILY == "UT24C")) || (FAMILY == "UT24CP")) ? "LIFCL" : FAMILY) ; 
    FIFO_A2B_ipgen_lscc_fifo_mem_main #(.MEM_ID(MEM_ID),
            .MEM_SIZE(MEM_SIZE),
            .FAMILY(T_FAMILY),
            .WADDR_DEPTH(WADDR_DEPTH),
            .WADDR_WIDTH(WADDR_WIDTH),
            .WDATA_WIDTH(WDATA_WIDTH),
            .RADDR_DEPTH(RADDR_DEPTH),
            .RADDR_WIDTH(RADDR_WIDTH),
            .RDATA_WIDTH(RDATA_WIDTH),
            .REGMODE(REGMODE),
            .GSR(GSR),
            .RESETMODE(RESETMODE),
            .RESET_RELEASE(RESET_RELEASE),
            .INIT_FILE(INIT_FILE),
            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
            .MODULE_TYPE(MODULE_TYPE),
            .INIT_MODE(INIT_MODE),
            .BYTE_ENABLE(BYTE_ENABLE),
            .BYTE_SIZE(BYTE_SIZE),
            .BYTE_WIDTH(BYTE_WIDTH),
            .PIPELINES(PIPELINES),
            .ECC_ENABLE(ECC_ENABLE),
            .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
            .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
            .INIT_VALUE_00(INIT_VALUE_00),
            .INIT_VALUE_01(INIT_VALUE_01),
            .INIT_VALUE_02(INIT_VALUE_02),
            .INIT_VALUE_03(INIT_VALUE_03),
            .INIT_VALUE_04(INIT_VALUE_04),
            .INIT_VALUE_05(INIT_VALUE_05),
            .INIT_VALUE_06(INIT_VALUE_06),
            .INIT_VALUE_07(INIT_VALUE_07),
            .INIT_VALUE_08(INIT_VALUE_08),
            .INIT_VALUE_09(INIT_VALUE_09),
            .INIT_VALUE_0A(INIT_VALUE_0A),
            .INIT_VALUE_0B(INIT_VALUE_0B),
            .INIT_VALUE_0C(INIT_VALUE_0C),
            .INIT_VALUE_0D(INIT_VALUE_0D),
            .INIT_VALUE_0E(INIT_VALUE_0E),
            .INIT_VALUE_0F(INIT_VALUE_0F),
            .INIT_VALUE_10(INIT_VALUE_10),
            .INIT_VALUE_11(INIT_VALUE_11),
            .INIT_VALUE_12(INIT_VALUE_12),
            .INIT_VALUE_13(INIT_VALUE_13),
            .INIT_VALUE_14(INIT_VALUE_14),
            .INIT_VALUE_15(INIT_VALUE_15),
            .INIT_VALUE_16(INIT_VALUE_16),
            .INIT_VALUE_17(INIT_VALUE_17),
            .INIT_VALUE_18(INIT_VALUE_18),
            .INIT_VALUE_19(INIT_VALUE_19),
            .INIT_VALUE_1A(INIT_VALUE_1A),
            .INIT_VALUE_1B(INIT_VALUE_1B),
            .INIT_VALUE_1C(INIT_VALUE_1C),
            .INIT_VALUE_1D(INIT_VALUE_1D),
            .INIT_VALUE_1E(INIT_VALUE_1E),
            .INIT_VALUE_1F(INIT_VALUE_1F),
            .INIT_VALUE_20(INIT_VALUE_20),
            .INIT_VALUE_21(INIT_VALUE_21),
            .INIT_VALUE_22(INIT_VALUE_22),
            .INIT_VALUE_23(INIT_VALUE_23),
            .INIT_VALUE_24(INIT_VALUE_24),
            .INIT_VALUE_25(INIT_VALUE_25),
            .INIT_VALUE_26(INIT_VALUE_26),
            .INIT_VALUE_27(INIT_VALUE_27),
            .INIT_VALUE_28(INIT_VALUE_28),
            .INIT_VALUE_29(INIT_VALUE_29),
            .INIT_VALUE_2A(INIT_VALUE_2A),
            .INIT_VALUE_2B(INIT_VALUE_2B),
            .INIT_VALUE_2C(INIT_VALUE_2C),
            .INIT_VALUE_2D(INIT_VALUE_2D),
            .INIT_VALUE_2E(INIT_VALUE_2E),
            .INIT_VALUE_2F(INIT_VALUE_2F),
            .INIT_VALUE_30(INIT_VALUE_30),
            .INIT_VALUE_31(INIT_VALUE_31),
            .INIT_VALUE_32(INIT_VALUE_32),
            .INIT_VALUE_33(INIT_VALUE_33),
            .INIT_VALUE_34(INIT_VALUE_34),
            .INIT_VALUE_35(INIT_VALUE_35),
            .INIT_VALUE_36(INIT_VALUE_36),
            .INIT_VALUE_37(INIT_VALUE_37),
            .INIT_VALUE_38(INIT_VALUE_38),
            .INIT_VALUE_39(INIT_VALUE_39),
            .INIT_VALUE_3A(INIT_VALUE_3A),
            .INIT_VALUE_3B(INIT_VALUE_3B),
            .INIT_VALUE_3C(INIT_VALUE_3C),
            .INIT_VALUE_3D(INIT_VALUE_3D),
            .INIT_VALUE_3E(INIT_VALUE_3E),
            .INIT_VALUE_3F(INIT_VALUE_3F),
            .INIT_VALUE_40(INIT_VALUE_40),
            .INIT_VALUE_41(INIT_VALUE_41),
            .INIT_VALUE_42(INIT_VALUE_42),
            .INIT_VALUE_43(INIT_VALUE_43),
            .INIT_VALUE_44(INIT_VALUE_44),
            .INIT_VALUE_45(INIT_VALUE_45),
            .INIT_VALUE_46(INIT_VALUE_46),
            .INIT_VALUE_47(INIT_VALUE_47),
            .INIT_VALUE_48(INIT_VALUE_48),
            .INIT_VALUE_49(INIT_VALUE_49),
            .INIT_VALUE_4A(INIT_VALUE_4A),
            .INIT_VALUE_4B(INIT_VALUE_4B),
            .INIT_VALUE_4C(INIT_VALUE_4C),
            .INIT_VALUE_4D(INIT_VALUE_4D),
            .INIT_VALUE_4E(INIT_VALUE_4E),
            .INIT_VALUE_4F(INIT_VALUE_4F),
            .INIT_VALUE_50(INIT_VALUE_50),
            .INIT_VALUE_51(INIT_VALUE_51),
            .INIT_VALUE_52(INIT_VALUE_52),
            .INIT_VALUE_53(INIT_VALUE_53),
            .INIT_VALUE_54(INIT_VALUE_54),
            .INIT_VALUE_55(INIT_VALUE_55),
            .INIT_VALUE_56(INIT_VALUE_56),
            .INIT_VALUE_57(INIT_VALUE_57),
            .INIT_VALUE_58(INIT_VALUE_58),
            .INIT_VALUE_59(INIT_VALUE_59),
            .INIT_VALUE_5A(INIT_VALUE_5A),
            .INIT_VALUE_5B(INIT_VALUE_5B),
            .INIT_VALUE_5C(INIT_VALUE_5C),
            .INIT_VALUE_5D(INIT_VALUE_5D),
            .INIT_VALUE_5E(INIT_VALUE_5E),
            .INIT_VALUE_5F(INIT_VALUE_5F),
            .INIT_VALUE_60(INIT_VALUE_60),
            .INIT_VALUE_61(INIT_VALUE_61),
            .INIT_VALUE_62(INIT_VALUE_62),
            .INIT_VALUE_63(INIT_VALUE_63),
            .INIT_VALUE_64(INIT_VALUE_64),
            .INIT_VALUE_65(INIT_VALUE_65),
            .INIT_VALUE_66(INIT_VALUE_66),
            .INIT_VALUE_67(INIT_VALUE_67),
            .INIT_VALUE_68(INIT_VALUE_68),
            .INIT_VALUE_69(INIT_VALUE_69),
            .INIT_VALUE_6A(INIT_VALUE_6A),
            .INIT_VALUE_6B(INIT_VALUE_6B),
            .INIT_VALUE_6C(INIT_VALUE_6C),
            .INIT_VALUE_6D(INIT_VALUE_6D),
            .INIT_VALUE_6E(INIT_VALUE_6E),
            .INIT_VALUE_6F(INIT_VALUE_6F),
            .INIT_VALUE_70(INIT_VALUE_70),
            .INIT_VALUE_71(INIT_VALUE_71),
            .INIT_VALUE_72(INIT_VALUE_72),
            .INIT_VALUE_73(INIT_VALUE_73),
            .INIT_VALUE_74(INIT_VALUE_74),
            .INIT_VALUE_75(INIT_VALUE_75),
            .INIT_VALUE_76(INIT_VALUE_76),
            .INIT_VALUE_77(INIT_VALUE_77),
            .INIT_VALUE_78(INIT_VALUE_78),
            .INIT_VALUE_79(INIT_VALUE_79),
            .INIT_VALUE_7A(INIT_VALUE_7A),
            .INIT_VALUE_7B(INIT_VALUE_7B),
            .INIT_VALUE_7C(INIT_VALUE_7C),
            .INIT_VALUE_7D(INIT_VALUE_7D),
            .INIT_VALUE_7E(INIT_VALUE_7E),
            .INIT_VALUE_7F(INIT_VALUE_7F)) mem_main (.wr_clk_i(wr_clk_i), 
                .rd_clk_i(rd_clk_i), 
                .rst_i(rst_i), 
                .wr_clk_en_i(wr_clk_en_i), 
                .rd_clk_en_i(rd_clk_en_i), 
                .rd_out_clk_en_i(rd_out_clk_en_i), 
                .wr_en_i(wr_en_i), 
                .wr_data_i(wr_data_i), 
                .wr_addr_i(wr_addr_i), 
                .rd_en_i(rd_en_i), 
                .rd_addr_i(rd_addr_i), 
                .ben_i(ben_i), 
                .rd_data_o(rd_data_o), 
                .one_err_det_o(one_err_det_o), 
                .two_err_det_o(two_err_det_o)) ; 
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_fifo_mem_main.v
// Title                 :
// Dependencies          :
// Description           : Top-level pseudo Dual Port RAM using EBR.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.1.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module FIFO_A2B_ipgen_lscc_fifo_mem_main #(parameter _FCODE_LIFCL_ = 1, 
        parameter _FCODE_ICE_ = 2, 
        parameter _FCODE_AP6_ = 3, 
        parameter _FCODE_COMMON_ = 0, 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "18,1024", 
        parameter FAMILY = "common", 
        parameter FAMILY_CODE = ((FAMILY == "LIFCL") ? _FCODE_LIFCL_ : ((FAMILY == "iCE40UP") ? _FCODE_ICE_ : ((FAMILY == "LATG1") ? _FCODE_AP6_ : ((FAMILY == "LAV-AT") ? _FCODE_AP6_ : _FCODE_COMMON_)))), 
        parameter WADDR_DEPTH = 1024, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 18, 
        parameter RADDR_DEPTH = 1024, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 18, 
        parameter REGMODE = "reg", 
        parameter GSR = "enable", 
        parameter RESETMODE = "sync", 
        parameter RESET_RELEASE = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter MODULE_TYPE = "ram_dp", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE = 1, 
        parameter BYTE_SIZE = ((BYTE_ENABLE == 1) ? getByteSize(WDATA_WIDTH,
                FAMILY_CODE) : WDATA_WIDTH), 
        parameter BYTE_WIDTH = (WDATA_WIDTH / BYTE_SIZE), 
        parameter PIPELINES = 0, 
        parameter ECC_ENABLE = 0, 
        parameter OUTPUT_CLK_EN = 0, 
        parameter BYTE_ENABLE_POL = "active-high", 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_40 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_41 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_42 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_43 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_44 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_45 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_46 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_47 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_48 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_49 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_50 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_51 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_52 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_53 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_54 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_55 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_56 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_57 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_58 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_59 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_60 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_61 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_62 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_63 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_64 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_65 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_66 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_67 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_68 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_69 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_70 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_71 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_72 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_73 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_74 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_75 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_76 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_77 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_78 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_79 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7F = "0x0000000000000000000000000000000000000000000000000000000000000000") (
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input rst_i, 
    input wr_clk_en_i, 
    input rd_clk_en_i, 
    input rd_out_clk_en_i, 
    input wr_en_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input [(WADDR_WIDTH - 1):0] wr_addr_i, 
    input rd_en_i, 
    input [(RADDR_WIDTH - 1):0] rd_addr_i, 
    input [(BYTE_WIDTH - 1):0] ben_i, 
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    // -----------------------------------------------------------------------------
    // Local Parameters
    // -----------------------------------------------------------------------------
    localparam IS_BYTE_ENABLE = (((BYTE_ENABLE == 1) && ((WDATA_WIDTH % BYTE_SIZE) == 0)) && (BYTE_WIDTH > 1)) ; 
    localparam IS_GSR_EN = ((GSR == "enable") ? "ENABLED" : "DISABLED") ; 
    localparam IS_ECC = (((ECC_ENABLE == "enable") || (ECC_ENABLE == "ENABLE")) ? "ENABLE" : "DISABLE") ; 
    localparam STRING_LENGTH = ((FAMILY == "iCE40UP") ? 66 : 82) ; 
    // -----------------------------------------------------------------------------
    // Generate Sequential Blocks
    // -----------------------------------------------------------------------------
    genvar i0, 
        i1, 
        i_0, 
        i_1 ; 
    generate
        if ((FAMILY == "common")) 
            begin : behavioral
                reg [(RDATA_WIDTH - 1):0] dataout_reg ; 
                reg [(RDATA_WIDTH - 1):0] dataout_reg_buffer ; 
                (* syn_ramstyle="block_ram" *) reg [(RDATA_WIDTH - 1):0] mem [((2 ** RADDR_WIDTH) - 1):0] ; 
                assign rd_data_o = ((REGMODE == "reg") ? dataout_reg : dataout_reg_buffer) ; 
                initial
                    begin
                        if (((INIT_MODE == "mem_file") && (INIT_FILE != "none"))) 
                            begin
                                if ((INIT_FILE_FORMAT == "hex")) 
                                    $readmemh (INIT_FILE,
                                            mem,
                                            0,
                                            (RADDR_DEPTH - 1)) ;
                                else
                                    $readmemb (INIT_FILE,
                                            mem,
                                            0,
                                            (RADDR_DEPTH - 1)) ;
                            end
                    end
                always
                    @(posedge wr_clk_i)
                    begin
                        if (((wr_clk_en_i == 1'b1) && (wr_en_i == 1'b1))) 
                            mem[wr_addr_i] <=  wr_data_i ;
                    end
                always
                    @(posedge rd_clk_i)
                    begin
                        if (((rd_clk_en_i == 1'b1) && (rd_en_i == 1'b1))) 
                            dataout_reg_buffer <=  mem[rd_addr_i] ;
                    end
                if ((REGMODE == "reg")) 
                    begin : genblk1
                        if ((RESETMODE == "sync")) 
                            begin : genblk1
                                always
                                    @(posedge rd_clk_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            dataout_reg <=  'h0 ;
                                        else
                                            if (((rd_out_clk_en_i == 1'b1) && (rd_en_i == 1'b1))) 
                                                dataout_reg <=  dataout_reg_buffer ;
                                    end
                            end
                        else
                            begin : genblk1
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            dataout_reg <=  'h0 ;
                                        else
                                            if (((rd_out_clk_en_i == 1'b1) && (rd_en_i == 1'b1))) 
                                                dataout_reg <=  dataout_reg_buffer ;
                                    end
                            end
                    end
            end
        else
            if (((RDATA_WIDTH == WDATA_WIDTH) && (RADDR_DEPTH == WADDR_DEPTH))) 
                begin : NON_MIX
                    localparam OPT_DATA_WIDTH = getMinimaData(RADDR_DEPTH,
                                RDATA_WIDTH,
                                IS_BYTE_ENABLE,
                                BYTE_SIZE,
                                ECC_ENABLE,
                                FAMILY_CODE) ; 
                    localparam OPT_ADDR_DEPTH = data_to_addr(OPT_DATA_WIDTH,
                                FAMILY_CODE) ; 
                    localparam OPT_ADDR_WIDTH = clog2(OPT_ADDR_DEPTH) ; 
                    localparam EBR_DATA = roundUP(RDATA_WIDTH,
                                OPT_DATA_WIDTH) ; 
                    localparam EBR_ADDR = roundUP(RADDR_DEPTH,
                                OPT_ADDR_DEPTH) ; 
                    localparam BYTE_WIDTH_IMPL = ((BYTE_ENABLE == 0) ? 1 : (((OPT_DATA_WIDTH == 72) | (OPT_DATA_WIDTH == 64)) ? 8 : (((OPT_DATA_WIDTH == 36) | (OPT_DATA_WIDTH == 32)) ? 4 : (((OPT_DATA_WIDTH == 18) | (OPT_DATA_WIDTH == 16)) ? 2 : 1)))) ; 
                    wire [(RDATA_WIDTH - 1):0] rd_data_raw_w [(EBR_ADDR - 1):0] ; 
                    wire [(EBR_ADDR - 1):0] one_err_det_raw_w ; 
                    wire [(EBR_ADDR - 1):0] two_err_det_raw_w ; 
                    for (i0 = 0;(i0 < EBR_ADDR);i0 = (i0 + 1))
                    begin : ADDR_ROUTE
                        wire [(RDATA_WIDTH - 1):0] raw_output_w ; 
                        assign rd_data_raw_w[i0] = raw_output_w ; 
                        wire chk_addr_r_w ; 
                        if ((EBR_ADDR > 1)) 
                            begin : genblk1
                                assign chk_addr_r_w = (rd_addr_i[(RADDR_WIDTH - 1):OPT_ADDR_WIDTH] == i0) ; 
                            end
                        else
                            begin : genblk1
                                assign chk_addr_r_w = 1'b1 ; 
                            end
                        wire [(OPT_ADDR_WIDTH - 1):0] act_addr_r_w ; 
                        if ((OPT_ADDR_WIDTH > RADDR_WIDTH)) 
                            begin : genblk2
                                assign act_addr_r_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                assign act_addr_r_w[(OPT_ADDR_WIDTH - 1):RADDR_WIDTH] = 'h000 ; 
                            end
                        else
                            begin : genblk2
                                assign act_addr_r_w = rd_addr_i[(OPT_ADDR_WIDTH - 1):0] ; 
                            end
                        wire chk_addr_w_w ; 
                        if ((EBR_ADDR > 1)) 
                            begin : genblk3
                                assign chk_addr_w_w = (wr_addr_i[(WADDR_WIDTH - 1):OPT_ADDR_WIDTH] == i0) ; 
                            end
                        else
                            begin : genblk3
                                assign chk_addr_w_w = 1'b1 ; 
                            end
                        wire [(OPT_ADDR_WIDTH - 1):0] act_addr_w_w ; 
                        if ((OPT_ADDR_WIDTH > WADDR_WIDTH)) 
                            begin : genblk4
                                assign act_addr_w_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                assign act_addr_w_w[(OPT_ADDR_WIDTH - 1):WADDR_WIDTH] = 'h000 ; 
                            end
                        else
                            begin : genblk4
                                assign act_addr_w_w = wr_addr_i[(OPT_ADDR_WIDTH - 1):0] ; 
                            end
                        wire [(EBR_DATA - 1):0] one_err_det_ind_w ; 
                        wire [(EBR_DATA - 1):0] two_err_det_ind_w ; 
                        if ((EBR_DATA == 1)) 
                            begin : genblk5
                                assign one_err_det_raw_w[i0] = one_err_det_ind_w[0] ; 
                                assign two_err_det_raw_w[i0] = two_err_det_ind_w[0] ; 
                            end
                        else
                            begin : genblk5
                                assign one_err_det_raw_w[i0] = (|one_err_det_ind_w) ; 
                                assign two_err_det_raw_w[i0] = (|two_err_det_ind_w) ; 
                            end
                        for (i1 = 0;(i1 < EBR_DATA);i1 = (i1 + 1))
                        begin : DATA_ROUTE
                            localparam ECO_POSX = (i1 * OPT_DATA_WIDTH) ; 
                            localparam ECO_POSY = (i0 * OPT_ADDR_DEPTH) ; 
                            wire [(OPT_DATA_WIDTH - 1):0] act_in_w ; 
                            wire [(OPT_DATA_WIDTH - 1):0] act_out_w ; 
                            wire one_err_det_ebr_w ; 
                            wire two_err_det_ebr_w ; 
                            wire [(BYTE_WIDTH_IMPL - 1):0] act_ben_w ; 
                            assign one_err_det_ind_w[i1] = one_err_det_ebr_w ; 
                            assign two_err_det_ind_w[i1] = two_err_det_ebr_w ; 
                            if (((OPT_DATA_WIDTH * (i1 + 1)) <= RDATA_WIDTH)) 
                                begin : genblk1
                                    assign act_in_w = wr_data_i[(((i1 + 1) * OPT_DATA_WIDTH) - 1):(i1 * OPT_DATA_WIDTH)] ; 
                                    assign raw_output_w[(((i1 + 1) * OPT_DATA_WIDTH) - 1):(i1 * OPT_DATA_WIDTH)] = act_out_w ; 
                                end
                            else
                                begin : genblk1
                                    assign act_in_w[(WDATA_WIDTH - (1 + (i1 * OPT_DATA_WIDTH))):0] = wr_data_i[(WDATA_WIDTH - 1):(i1 * OPT_DATA_WIDTH)] ; 
                                    if ((OPT_DATA_WIDTH > (WDATA_WIDTH - (i1 * OPT_DATA_WIDTH)))) 
                                        begin : genblk1
                                            assign act_in_w[(OPT_DATA_WIDTH - 1):(WDATA_WIDTH - (i1 * OPT_DATA_WIDTH))] = {(OPT_DATA_WIDTH - (WDATA_WIDTH - (i1 * OPT_DATA_WIDTH))){1'b0}} ; 
                                        end
                                    assign raw_output_w[(RDATA_WIDTH - 1):(i1 * OPT_DATA_WIDTH)] = act_out_w[(RDATA_WIDTH - (1 + (i1 * OPT_DATA_WIDTH))):0] ; 
                                end
                            if ((IS_BYTE_ENABLE == 0)) 
                                begin : genblk2
                                    assign act_ben_w = {BYTE_WIDTH_IMPL{1'b1}} ; 
                                end
                            else
                                if ((OPT_DATA_WIDTH >= 8)) 
                                    begin : genblk2
                                        if ((BYTE_WIDTH_IMPL > 1)) 
                                            begin : genblk1
                                                if ((((i1 + 1) * BYTE_WIDTH_IMPL) <= BYTE_WIDTH)) 
                                                    begin : genblk1
                                                        assign act_ben_w = ben_i[(((i1 + 1) * BYTE_WIDTH_IMPL) - 1):(i1 * BYTE_WIDTH_IMPL)] ; 
                                                    end
                                                else
                                                    begin : genblk1
                                                        assign act_ben_w[(BYTE_WIDTH_IMPL - 1):(BYTE_WIDTH - (i1 * BYTE_WIDTH_IMPL))] = {(BYTE_WIDTH_IMPL - (BYTE_WIDTH - (i1 * BYTE_WIDTH_IMPL))){1'b1}} ; 
                                                        assign act_ben_w[(BYTE_WIDTH - (1 + (i1 * BYTE_WIDTH_IMPL))):0] = ben_i[(BYTE_WIDTH - 1):(i1 * BYTE_WIDTH_IMPL)] ; 
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                assign act_ben_w = ben_i[i1] ; 
                                            end
                                    end
                                else
                                    begin : genblk2
                                        assign act_ben_w = ben_i[(((i1 * OPT_DATA_WIDTH) * BYTE_WIDTH) / WDATA_WIDTH)] ; 
                                    end
                            wire f_wr_en_w = (chk_addr_w_w & wr_en_i) ; 
                            wire f_rd_en_w = (chk_addr_r_w & rd_en_i) ; 
                            if ((INIT_MODE == "mem_file")) 
                                begin : mem_init
                                    FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                            .MEM_SIZE(MEM_SIZE),
                                            .POSx(ECO_POSX),
                                            .POSy(ECO_POSY),
                                            .FAMILY(FAMILY),
                                            ._FCODE_ICE_(_FCODE_ICE_),
                                            ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                            ._FCODE_AP6_(_FCODE_AP6_),
                                            ._FCODE_COMMON_(_FCODE_COMMON_),
                                            .DATA_WIDTH_W(OPT_DATA_WIDTH),
                                            .DATA_WIDTH_R(OPT_DATA_WIDTH),
                                            .REGMODE(REGMODE),
                                            .RESETMODE(RESETMODE),
                                            .RESET_RELEASE(RESET_RELEASE),
                                            .INIT_MODE(INIT_MODE),
                                            .BYTE_ENABLE(IS_BYTE_ENABLE),
                                            .ECC_ENABLE(ECC_ENABLE),
                                            .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                            .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                            .INIT_VALUE_00(INIT_VALUE_00[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_01(INIT_VALUE_01[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_02(INIT_VALUE_02[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_03(INIT_VALUE_03[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_04(INIT_VALUE_04[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_05(INIT_VALUE_05[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_06(INIT_VALUE_06[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_07(INIT_VALUE_07[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_08(INIT_VALUE_08[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_09(INIT_VALUE_09[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0A(INIT_VALUE_0A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0B(INIT_VALUE_0B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0C(INIT_VALUE_0C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0D(INIT_VALUE_0D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0E(INIT_VALUE_0E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0F(INIT_VALUE_0F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                .rd_clk_i(rd_clk_i), 
                                                .rst_i(rst_i), 
                                                .wr_clk_en_i(wr_clk_en_i), 
                                                .rd_clk_en_i(rd_clk_en_i), 
                                                .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                .wr_en_i(f_wr_en_w), 
                                                .wr_data_i(act_in_w), 
                                                .wr_addr_i(act_addr_w_w), 
                                                .rd_en_i(f_rd_en_w), 
                                                .rd_addr_i(act_addr_r_w), 
                                                .ben_i(act_ben_w), 
                                                .rd_data_o(act_out_w), 
                                                .one_err_det_o(one_err_det_ebr_w), 
                                                .two_err_det_o(two_err_det_ebr_w)) ; 
                                end
                            else
                                begin : no_init
                                    FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                            .MEM_SIZE(MEM_SIZE),
                                            .POSx(ECO_POSX),
                                            .POSy(ECO_POSY),
                                            .FAMILY(FAMILY),
                                            ._FCODE_ICE_(_FCODE_ICE_),
                                            ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                            ._FCODE_AP6_(_FCODE_AP6_),
                                            ._FCODE_COMMON_(_FCODE_COMMON_),
                                            .DATA_WIDTH_W(OPT_DATA_WIDTH),
                                            .DATA_WIDTH_R(OPT_DATA_WIDTH),
                                            .REGMODE(REGMODE),
                                            .RESETMODE(RESETMODE),
                                            .RESET_RELEASE(RESET_RELEASE),
                                            .INIT_MODE(INIT_MODE),
                                            .BYTE_ENABLE(IS_BYTE_ENABLE),
                                            .ECC_ENABLE(ECC_ENABLE),
                                            .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                            .BYTE_ENABLE_POL(BYTE_ENABLE_POL)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                .rd_clk_i(rd_clk_i), 
                                                .rst_i(rst_i), 
                                                .wr_clk_en_i(wr_clk_en_i), 
                                                .rd_clk_en_i(rd_clk_en_i), 
                                                .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                .wr_en_i(f_wr_en_w), 
                                                .wr_data_i(act_in_w), 
                                                .wr_addr_i(act_addr_w_w), 
                                                .rd_en_i(f_rd_en_w), 
                                                .rd_addr_i(act_addr_r_w), 
                                                .ben_i(act_ben_w), 
                                                .rd_data_o(act_out_w), 
                                                .one_err_det_o(one_err_det_ebr_w), 
                                                .two_err_det_o(two_err_det_ebr_w)) ; 
                                end
                        end
                    end
                    if ((EBR_ADDR == 1)) 
                        begin : genblk2
                            assign rd_data_o = rd_data_raw_w[0] ; 
                            assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_raw_w[0] : 1'b0) ; 
                            assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_raw_w[0] : 1'b0) ; 
                        end
                    else
                        begin : genblk2
                            reg [(RDATA_WIDTH - 1):0] rd_out_buff_r ; 
                            reg [(RADDR_WIDTH - 1):0] rd_addr_0_r = {RADDR_WIDTH{1'b0}} ; 
                            reg one_err_det_r ; 
                            reg two_err_det_r ; 
                            assign rd_data_o = rd_out_buff_r ; 
                            assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_r : 1'b0) ; 
                            assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_r : 1'b0) ; 
                            if ((REGMODE == "noreg")) 
                                begin : _nreg
                                    if ((RESETMODE == "sync")) 
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                        end
                                                end
                                        end
                                    else
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i or 
                                                    posedge rst_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                        end
                                                end
                                        end
                                end
                            else
                                begin : _reg
                                    reg [(RADDR_WIDTH - 1):0] rd_addr_1_r = {RADDR_WIDTH{1'b0}} ; 
                                    if ((RESETMODE == "sync")) 
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                            rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            rd_addr_0_r <=  rd_addr_1_r ;
                                                            rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                        end
                                                end
                                        end
                                    else
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i or 
                                                    posedge rst_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                            rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            rd_addr_0_r <=  rd_addr_1_r ;
                                                            rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                        end
                                                end
                                        end
                                end
                            always
                                @(*)
                                begin
                                    rd_out_buff_r = rd_data_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):OPT_ADDR_WIDTH]] ;
                                    one_err_det_r = one_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):OPT_ADDR_WIDTH]] ;
                                    two_err_det_r = two_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):OPT_ADDR_WIDTH]] ;
                                end
                        end
                end
            else
                if ((IS_BYTE_ENABLE == 0)) 
                    begin : MIX_NO_BYTE_EN
                        localparam MAX_DATA = ((WDATA_WIDTH > RDATA_WIDTH) ? WDATA_WIDTH : RDATA_WIDTH) ; 
                        localparam MAX_PORT = ((WDATA_WIDTH > RDATA_WIDTH) ? "W" : "R") ; 
                        localparam MIN_DEPTH = ((MAX_PORT == "W") ? WADDR_DEPTH : RADDR_DEPTH) ; 
                        localparam Q_FACTOR = ((MAX_PORT == "W") ? (WDATA_WIDTH / RDATA_WIDTH) : (RDATA_WIDTH / WDATA_WIDTH)) ; 
                        localparam PROC_MAX_DATA = procData(MAX_DATA,
                                    ECC_ENABLE,
                                    FAMILY_CODE) ; 
                        localparam PROC_MIN_DEPTH = (2 ** clog2(MIN_DEPTH)) ; 
                        localparam PROC_MIN_DATA = (PROC_MAX_DATA / Q_FACTOR) ; 
                        localparam PROC_MAX_DEPTH = (PROC_MIN_DEPTH * Q_FACTOR) ; 
                        localparam W_PORT_USE = ((MAX_PORT == "W") ? PROC_MAX_DATA : PROC_MIN_DATA) ; 
                        localparam W_DEPTH_USE = ((MAX_PORT == "W") ? PROC_MIN_DEPTH : PROC_MAX_DEPTH) ; 
                        localparam W_DEPTH_WIDTH_USE = clog2(W_DEPTH_USE) ; 
                        localparam R_PORT_USE = ((MAX_PORT == "R") ? PROC_MAX_DATA : PROC_MIN_DATA) ; 
                        localparam R_DEPTH_USE = ((MAX_PORT == "R") ? PROC_MIN_DEPTH : PROC_MAX_DEPTH) ; 
                        localparam R_DEPTH_WIDTH_USE = clog2(R_DEPTH_USE) ; 
                        localparam W_DATA_WIDTH_IMPL = getCASE1DataImpl(W_DEPTH_USE,
                                    W_PORT_USE,
                                    R_DEPTH_USE,
                                    R_PORT_USE,
                                    1'b1,
                                    0,
                                    ECC_ENABLE,
                                    FAMILY_CODE) ; 
                        localparam W_ADDR_DEPTH_IMPL = data_to_addr(W_DATA_WIDTH_IMPL,
                                    FAMILY_CODE) ; 
                        localparam W_ADDR_WIDTH_IMPL = clog2(W_ADDR_DEPTH_IMPL) ; 
                        localparam R_DATA_WIDTH_IMPL = getCASE1DataImpl(W_DEPTH_USE,
                                    W_PORT_USE,
                                    R_DEPTH_USE,
                                    R_PORT_USE,
                                    1'b0,
                                    0,
                                    ECC_ENABLE,
                                    FAMILY_CODE) ; 
                        localparam R_ADDR_DEPTH_IMPL = data_to_addr(R_DATA_WIDTH_IMPL,
                                    FAMILY_CODE) ; 
                        localparam R_ADDR_WIDTH_IMPL = clog2(R_ADDR_DEPTH_IMPL) ; 
                        localparam EBR_ADDR = roundUP(W_DEPTH_USE,
                                    W_ADDR_DEPTH_IMPL) ; 
                        localparam EBR_DATA = roundUP(W_PORT_USE,
                                    W_DATA_WIDTH_IMPL) ; 
                        wire [(W_DEPTH_WIDTH_USE - 1):0] wr_addr_buff_w ; 
                        wire [(R_DEPTH_WIDTH_USE - 1):0] rd_addr_buff_w ; 
                        if ((W_DEPTH_WIDTH_USE > WADDR_WIDTH)) 
                            begin : genblk1
                                assign wr_addr_buff_w[(W_DEPTH_WIDTH_USE - 1):WADDR_WIDTH] = 'h0000 ; 
                            end
                        assign wr_addr_buff_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                        if ((R_DEPTH_WIDTH_USE > RADDR_WIDTH)) 
                            begin : genblk2
                                assign rd_addr_buff_w[(R_DEPTH_WIDTH_USE - 1):RADDR_WIDTH] = 'h0000 ; 
                            end
                        assign rd_addr_buff_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                        wire [(W_PORT_USE - 1):0] input_buff_w ; 
                        wire [(R_PORT_USE - 1):0] output_buff_w ; 
                        wire [(R_PORT_USE - 1):0] rd_data_raw_w [(EBR_ADDR - 1):0] ; 
                        wire [(W_PORT_USE - 1):0] master_data_in_w ; 
                        wire [(R_PORT_USE - 1):0] master_data_out_w ; 
                        if ((EBR_DATA > 1)) 
                            begin : genblk3
                                if ((W_PORT_USE > R_PORT_USE)) 
                                    begin : genblk1
                                        assign rd_data_o = output_buff_w[(RDATA_WIDTH - 1):0] ; 
                                        assign output_buff_w = master_data_out_w ; 
                                        wire [(R_PORT_USE - 1):0] inp_buff_seg_w [((W_PORT_USE / R_PORT_USE) - 1):0] ; 
                                        for (i_0 = 0;(i_0 < (W_PORT_USE / R_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk1
                                            assign inp_buff_seg_w[i_0] = wr_data_i[((RDATA_WIDTH * (i_0 + 1)) - 1):(RDATA_WIDTH * i_0)] ; 
                                        end
                                        for (i_0 = 0;(i_0 < (W_PORT_USE / R_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk2
                                            assign input_buff_w[(((i_0 * R_PORT_USE) + R_PORT_USE) - 1):(i_0 * R_PORT_USE)] = inp_buff_seg_w[i_0] ; 
                                        end
                                        wire [(R_DATA_WIDTH_IMPL - 1):0] master_data_ind_w [((W_PORT_USE / R_DATA_WIDTH_IMPL) - 1):0] ; 
                                        for (i_0 = 0;(i_0 < EBR_DATA);i_0 = (i_0 + 1))
                                        begin : genblk3
                                            for (i_1 = 0;(i_1 < (W_PORT_USE / (EBR_DATA * R_DATA_WIDTH_IMPL)));i_1 = (i_1 + 1))
                                            begin : genblk1
                                                assign master_data_ind_w[(((W_PORT_USE / (EBR_DATA * R_DATA_WIDTH_IMPL)) * i_0) + i_1)] = input_buff_w[((((i_0 * R_DATA_WIDTH_IMPL) + ((i_1 * EBR_DATA) * R_DATA_WIDTH_IMPL)) + R_DATA_WIDTH_IMPL) - 1):((i_0 * R_DATA_WIDTH_IMPL) + ((i_1 * EBR_DATA) * R_DATA_WIDTH_IMPL))] ; 
                                            end
                                        end
                                        for (i_0 = 0;(i_0 < (W_PORT_USE / R_DATA_WIDTH_IMPL));i_0 = (i_0 + 1))
                                        begin : genblk4
                                            assign master_data_in_w[(((i_0 * R_DATA_WIDTH_IMPL) + R_DATA_WIDTH_IMPL) - 1):(i_0 * R_DATA_WIDTH_IMPL)] = master_data_ind_w[i_0] ; 
                                        end
                                    end
                                else
                                    begin : genblk1
                                        if ((W_PORT_USE > WDATA_WIDTH)) 
                                            begin : genblk1
                                                assign input_buff_w[(W_PORT_USE - 1):WDATA_WIDTH] = 'h0000 ; 
                                            end
                                        assign input_buff_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                        assign master_data_in_w = input_buff_w ; 
                                        wire [(W_PORT_USE - 1):0] out_buff_seg_w [((R_PORT_USE / W_PORT_USE) - 1):0] ; 
                                        for (i_0 = 0;(i_0 < (R_PORT_USE / W_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk2
                                            assign rd_data_o[((WDATA_WIDTH * (i_0 + 1)) - 1):(WDATA_WIDTH * i_0)] = out_buff_seg_w[i_0] ; 
                                        end
                                        for (i_0 = 0;(i_0 < (R_PORT_USE / W_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk3
                                            assign out_buff_seg_w[i_0] = output_buff_w[(((i_0 + 1) * W_PORT_USE) - 1):(i_0 * W_PORT_USE)] ; 
                                        end
                                        wire [(W_DATA_WIDTH_IMPL - 1):0] master_data_ind_out_w [((R_PORT_USE / W_DATA_WIDTH_IMPL) - 1):0] ; 
                                        for (i_0 = 0;(i_0 < (R_PORT_USE / W_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk4
                                            for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                            begin : genblk1
                                                assign master_data_ind_out_w[((i_0 * EBR_DATA) + i_1)] = master_data_out_w[((((i_1 * R_DATA_WIDTH_IMPL) + (i_0 * W_DATA_WIDTH_IMPL)) + W_DATA_WIDTH_IMPL) - 1):((i_1 * R_DATA_WIDTH_IMPL) + (i_0 * W_DATA_WIDTH_IMPL))] ; 
                                            end
                                        end
                                        for (i_0 = 0;(i_0 < (R_PORT_USE / W_DATA_WIDTH_IMPL));i_0 = (i_0 + 1))
                                        begin : genblk5
                                            assign output_buff_w[(((i_0 * W_DATA_WIDTH_IMPL) + W_DATA_WIDTH_IMPL) - 1):(i_0 * W_DATA_WIDTH_IMPL)] = master_data_ind_out_w[i_0] ; 
                                        end
                                    end
                            end
                        else
                            if ((EBR_ADDR > 1)) 
                                begin : genblk3
                                    localparam Q_SRD_x = (R_PORT_USE / W_PORT_USE) ; 
                                    localparam Q_SWR_x = (W_PORT_USE / R_PORT_USE) ; 
                                    if ((R_PORT_USE < W_PORT_USE)) 
                                        begin : genblk1
                                            for (i_0 = 0;(i_0 < Q_SWR_x);i_0 = (i_0 + 1))
                                            begin : genblk1
                                                assign master_data_in_w[(((i_0 * R_PORT_USE) + RDATA_WIDTH) - 1):(i_0 * R_PORT_USE)] = wr_data_i[(((i_0 * RDATA_WIDTH) + RDATA_WIDTH) - 1):(i_0 * RDATA_WIDTH)] ; 
                                                if ((R_PORT_USE != RDATA_WIDTH)) 
                                                    begin : genblk1
                                                        assign master_data_in_w[(((i_0 * R_PORT_USE) + R_PORT_USE) - 1):((i_0 * R_PORT_USE) + RDATA_WIDTH)] = {(R_PORT_USE - RDATA_WIDTH){1'b0}} ; 
                                                    end
                                            end
                                            assign rd_data_o = master_data_out_w[(RDATA_WIDTH - 1):0] ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign master_data_in_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                            for (i_0 = 0;(i_0 < Q_SRD_x);i_0 = (i_0 + 1))
                                            begin : genblk1
                                                assign rd_data_o[(((i_0 * WDATA_WIDTH) + WDATA_WIDTH) - 1):(i_0 * WDATA_WIDTH)] = master_data_out_w[(((i_0 * W_PORT_USE) + WDATA_WIDTH) - 1):(i_0 * W_PORT_USE)] ; 
                                            end
                                        end
                                end
                        if (((EBR_ADDR == 1) && (EBR_DATA == 1))) 
                            begin : SINGLE_IMPL
                                localparam W_SINGULAR_DATA_x = getSingularCase(W_PORT_USE,
                                            FAMILY_CODE) ; 
                                localparam R_SINGULAR_DATA_x = getSingularCase(R_PORT_USE,
                                            FAMILY_CODE) ; 
                                localparam W_SINGULAR_ADDR_WIDTH = clog2(data_to_addr(W_SINGULAR_DATA_x,
                                                FAMILY_CODE)) ; 
                                localparam R_SINGULAR_ADDR_WIDTH = clog2(data_to_addr(R_SINGULAR_DATA_x,
                                                FAMILY_CODE)) ; 
                                localparam Q_SRD_x = (R_SINGULAR_DATA_x / W_SINGULAR_DATA_x) ; 
                                localparam Q_SWR_x = (W_SINGULAR_DATA_x / R_SINGULAR_DATA_x) ; 
                                wire [(W_SINGULAR_DATA_x - 1):0] single_wire_in_w ; 
                                wire [(R_SINGULAR_DATA_x - 1):0] single_wire_out_w ; 
                                wire [(W_SINGULAR_ADDR_WIDTH - 1):0] single_wr_addr_w ; 
                                wire [(R_SINGULAR_ADDR_WIDTH - 1):0] single_rd_addr_w ; 
                                if ((R_SINGULAR_DATA_x < W_SINGULAR_DATA_x)) 
                                    begin : genblk1
                                        for (i0 = 0;(i0 < Q_SWR_x);i0 = (i0 + 1))
                                        begin : genblk1
                                            assign single_wire_in_w[(((i0 * R_SINGULAR_DATA_x) + RDATA_WIDTH) - 1):(i0 * R_SINGULAR_DATA_x)] = wr_data_i[(((i0 * RDATA_WIDTH) + RDATA_WIDTH) - 1):(i0 * RDATA_WIDTH)] ; 
                                            if ((R_SINGULAR_DATA_x != RDATA_WIDTH)) 
                                                begin : genblk1
                                                    assign single_wire_in_w[(((i0 * R_SINGULAR_DATA_x) + R_SINGULAR_DATA_x) - 1):((i0 * R_SINGULAR_DATA_x) + RDATA_WIDTH)] = {(R_SINGULAR_DATA_x - RDATA_WIDTH){1'b0}} ; 
                                                end
                                        end
                                        assign rd_data_o = single_wire_out_w[(RDATA_WIDTH - 1):0] ; 
                                    end
                                else
                                    begin : genblk1
                                        assign single_wire_in_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                        for (i0 = 0;(i0 < Q_SRD_x);i0 = (i0 + 1))
                                        begin : genblk1
                                            assign rd_data_o[(((i0 * WDATA_WIDTH) + WDATA_WIDTH) - 1):(i0 * WDATA_WIDTH)] = single_wire_out_w[(((i0 * W_SINGULAR_DATA_x) + WDATA_WIDTH) - 1):(i0 * W_SINGULAR_DATA_x)] ; 
                                        end
                                    end
                                if ((W_SINGULAR_ADDR_WIDTH > WADDR_WIDTH)) 
                                    begin : genblk2
                                        assign single_wr_addr_w[(W_SINGULAR_ADDR_WIDTH - 1):WADDR_WIDTH] = 'h0000 ; 
                                    end
                                assign single_wr_addr_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                if ((R_SINGULAR_ADDR_WIDTH > RADDR_WIDTH)) 
                                    begin : genblk3
                                        assign single_rd_addr_w[(R_SINGULAR_ADDR_WIDTH - 1):RADDR_WIDTH] = 'h0000 ; 
                                    end
                                assign single_rd_addr_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                if ((INIT_MODE == "mem_file")) 
                                    begin : mem_init
                                        FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                                .MEM_SIZE(MEM_SIZE),
                                                .FAMILY(FAMILY),
                                                ._FCODE_ICE_(_FCODE_ICE_),
                                                ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                ._FCODE_AP6_(_FCODE_AP6_),
                                                ._FCODE_COMMON_(_FCODE_COMMON_),
                                                .DATA_WIDTH_W(W_SINGULAR_DATA_x),
                                                .DATA_WIDTH_R(R_SINGULAR_DATA_x),
                                                .REGMODE(REGMODE),
                                                .RESETMODE(RESETMODE),
                                                .RESET_RELEASE(RESET_RELEASE),
                                                .BYTE_ENABLE(0),
                                                .ECC_ENABLE(ECC_ENABLE),
                                                .INIT_MODE(INIT_MODE),
                                                .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                .INIT_VALUE_00(INIT_VALUE_00),
                                                .INIT_VALUE_01(INIT_VALUE_01),
                                                .INIT_VALUE_02(INIT_VALUE_02),
                                                .INIT_VALUE_03(INIT_VALUE_03),
                                                .INIT_VALUE_04(INIT_VALUE_04),
                                                .INIT_VALUE_05(INIT_VALUE_05),
                                                .INIT_VALUE_06(INIT_VALUE_06),
                                                .INIT_VALUE_07(INIT_VALUE_07),
                                                .INIT_VALUE_08(INIT_VALUE_08),
                                                .INIT_VALUE_09(INIT_VALUE_09),
                                                .INIT_VALUE_0A(INIT_VALUE_0A),
                                                .INIT_VALUE_0B(INIT_VALUE_0B),
                                                .INIT_VALUE_0C(INIT_VALUE_0C),
                                                .INIT_VALUE_0D(INIT_VALUE_0D),
                                                .INIT_VALUE_0E(INIT_VALUE_0E),
                                                .INIT_VALUE_0F(INIT_VALUE_0F),
                                                .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10 : "0x00")),
                                                .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11 : "0x00")),
                                                .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12 : "0x00")),
                                                .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13 : "0x00")),
                                                .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14 : "0x00")),
                                                .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15 : "0x00")),
                                                .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16 : "0x00")),
                                                .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17 : "0x00")),
                                                .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18 : "0x00")),
                                                .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19 : "0x00")),
                                                .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A : "0x00")),
                                                .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B : "0x00")),
                                                .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C : "0x00")),
                                                .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D : "0x00")),
                                                .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E : "0x00")),
                                                .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F : "0x00")),
                                                .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20 : "0x00")),
                                                .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21 : "0x00")),
                                                .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22 : "0x00")),
                                                .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23 : "0x00")),
                                                .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24 : "0x00")),
                                                .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25 : "0x00")),
                                                .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26 : "0x00")),
                                                .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27 : "0x00")),
                                                .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28 : "0x00")),
                                                .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29 : "0x00")),
                                                .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A : "0x00")),
                                                .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B : "0x00")),
                                                .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C : "0x00")),
                                                .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D : "0x00")),
                                                .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E : "0x00")),
                                                .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F : "0x00")),
                                                .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30 : "0x00")),
                                                .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31 : "0x00")),
                                                .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32 : "0x00")),
                                                .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33 : "0x00")),
                                                .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34 : "0x00")),
                                                .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35 : "0x00")),
                                                .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36 : "0x00")),
                                                .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37 : "0x00")),
                                                .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38 : "0x00")),
                                                .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39 : "0x00")),
                                                .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A : "0x00")),
                                                .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B : "0x00")),
                                                .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C : "0x00")),
                                                .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D : "0x00")),
                                                .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E : "0x00")),
                                                .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F : "0x00")),
                                                .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40 : "0x00")),
                                                .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41 : "0x00")),
                                                .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42 : "0x00")),
                                                .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43 : "0x00")),
                                                .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44 : "0x00")),
                                                .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45 : "0x00")),
                                                .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46 : "0x00")),
                                                .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47 : "0x00")),
                                                .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48 : "0x00")),
                                                .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49 : "0x00")),
                                                .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A : "0x00")),
                                                .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B : "0x00")),
                                                .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C : "0x00")),
                                                .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D : "0x00")),
                                                .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E : "0x00")),
                                                .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F : "0x00")),
                                                .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50 : "0x00")),
                                                .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51 : "0x00")),
                                                .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52 : "0x00")),
                                                .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53 : "0x00")),
                                                .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54 : "0x00")),
                                                .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55 : "0x00")),
                                                .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56 : "0x00")),
                                                .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57 : "0x00")),
                                                .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58 : "0x00")),
                                                .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59 : "0x00")),
                                                .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A : "0x00")),
                                                .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B : "0x00")),
                                                .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C : "0x00")),
                                                .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D : "0x00")),
                                                .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E : "0x00")),
                                                .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F : "0x00")),
                                                .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60 : "0x00")),
                                                .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61 : "0x00")),
                                                .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62 : "0x00")),
                                                .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63 : "0x00")),
                                                .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64 : "0x00")),
                                                .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65 : "0x00")),
                                                .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66 : "0x00")),
                                                .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67 : "0x00")),
                                                .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68 : "0x00")),
                                                .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69 : "0x00")),
                                                .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A : "0x00")),
                                                .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B : "0x00")),
                                                .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C : "0x00")),
                                                .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D : "0x00")),
                                                .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E : "0x00")),
                                                .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F : "0x00")),
                                                .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70 : "0x00")),
                                                .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71 : "0x00")),
                                                .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72 : "0x00")),
                                                .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73 : "0x00")),
                                                .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74 : "0x00")),
                                                .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75 : "0x00")),
                                                .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76 : "0x00")),
                                                .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77 : "0x00")),
                                                .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78 : "0x00")),
                                                .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79 : "0x00")),
                                                .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A : "0x00")),
                                                .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B : "0x00")),
                                                .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C : "0x00")),
                                                .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D : "0x00")),
                                                .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E : "0x00")),
                                                .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                    .rd_clk_i(rd_clk_i), 
                                                    .rst_i(rst_i), 
                                                    .wr_clk_en_i(wr_clk_en_i), 
                                                    .rd_clk_en_i(rd_clk_en_i), 
                                                    .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                    .wr_en_i(wr_en_i), 
                                                    .wr_data_i(single_wire_in_w), 
                                                    .wr_addr_i(single_wr_addr_w), 
                                                    .rd_en_i(rd_en_i), 
                                                    .rd_addr_i(single_rd_addr_w), 
                                                    .ben_i(1'b1), 
                                                    .rd_data_o(single_wire_out_w), 
                                                    .one_err_det_o(one_err_det_o), 
                                                    .two_err_det_o(two_err_det_o)) ; 
                                    end
                                else
                                    begin : no_init
                                        FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                                .MEM_SIZE(MEM_SIZE),
                                                .FAMILY(FAMILY),
                                                ._FCODE_ICE_(_FCODE_ICE_),
                                                ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                ._FCODE_AP6_(_FCODE_AP6_),
                                                ._FCODE_COMMON_(_FCODE_COMMON_),
                                                .DATA_WIDTH_W(W_SINGULAR_DATA_x),
                                                .DATA_WIDTH_R(R_SINGULAR_DATA_x),
                                                .REGMODE(REGMODE),
                                                .RESETMODE(RESETMODE),
                                                .RESET_RELEASE(RESET_RELEASE),
                                                .BYTE_ENABLE(0),
                                                .ECC_ENABLE(ECC_ENABLE),
                                                .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                .INIT_MODE(INIT_MODE)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                    .rd_clk_i(rd_clk_i), 
                                                    .rst_i(rst_i), 
                                                    .wr_clk_en_i(wr_clk_en_i), 
                                                    .rd_clk_en_i(rd_clk_en_i), 
                                                    .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                    .wr_en_i(wr_en_i), 
                                                    .wr_data_i(single_wire_in_w), 
                                                    .wr_addr_i(single_wr_addr_w), 
                                                    .rd_en_i(rd_en_i), 
                                                    .rd_addr_i(single_rd_addr_w), 
                                                    .ben_i(1'b1), 
                                                    .rd_data_o(single_wire_out_w), 
                                                    .one_err_det_o(one_err_det_o), 
                                                    .two_err_det_o(two_err_det_o)) ; 
                                    end
                            end
                        else
                            begin : MULT_IMPL
                                wire [(EBR_ADDR - 1):0] one_err_det_raw_w ; 
                                wire [(EBR_ADDR - 1):0] two_err_det_raw_w ; 
                                for (i0 = 0;(i0 < EBR_ADDR);i0 = (i0 + 1))
                                begin : ADDR_x
                                    wire [(R_PORT_USE - 1):0] raw_output_w ; 
                                    assign rd_data_raw_w[i0] = raw_output_w ; 
                                    wire chk_addr_wr_w ; 
                                    if ((EBR_ADDR > 1)) 
                                        begin : genblk1
                                            assign chk_addr_wr_w = (wr_addr_i[(WADDR_WIDTH - 1):W_ADDR_WIDTH_IMPL] == i0) ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign chk_addr_wr_w = 1'b1 ; 
                                        end
                                    wire [(W_ADDR_WIDTH_IMPL - 1):0] act_wr_addr_w ; 
                                    if ((W_ADDR_WIDTH_IMPL > WADDR_WIDTH)) 
                                        begin : genblk2
                                            assign act_wr_addr_w[(W_ADDR_WIDTH_IMPL - 1):WADDR_WIDTH] = 'h0000 ; 
                                            assign act_wr_addr_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                        end
                                    else
                                        begin : genblk2
                                            assign act_wr_addr_w = wr_addr_i[(W_ADDR_WIDTH_IMPL - 1):0] ; 
                                        end
                                    wire chk_addr_rd_w ; 
                                    if ((EBR_ADDR > 1)) 
                                        begin : genblk3
                                            assign chk_addr_rd_w = (rd_addr_i[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL] == i0) ; 
                                        end
                                    else
                                        begin : genblk3
                                            assign chk_addr_rd_w = 1'b1 ; 
                                        end
                                    wire [(R_ADDR_WIDTH_IMPL - 1):0] act_rd_addr_w ; 
                                    if ((R_ADDR_WIDTH_IMPL > RADDR_WIDTH)) 
                                        begin : genblk4
                                            assign act_rd_addr_w[(R_ADDR_WIDTH_IMPL - 1):RADDR_WIDTH] = 'h0000 ; 
                                            assign act_rd_addr_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                        end
                                    else
                                        begin : genblk4
                                            assign act_rd_addr_w = rd_addr_i[(R_ADDR_WIDTH_IMPL - 1):0] ; 
                                        end
                                    wire [(EBR_DATA - 1):0] one_err_det_ind_w ; 
                                    wire [(EBR_DATA - 1):0] two_err_det_ind_w ; 
                                    if ((EBR_DATA == 1)) 
                                        begin : genblk5
                                            assign one_err_det_raw_w[i0] = one_err_det_ind_w[0] ; 
                                            assign two_err_det_raw_w[i0] = two_err_det_ind_w[0] ; 
                                        end
                                    else
                                        begin : genblk5
                                            assign one_err_det_raw_w[i0] = (|one_err_det_ind_w) ; 
                                            assign two_err_det_raw_w[i0] = (|two_err_det_ind_w) ; 
                                        end
                                    for (i1 = 0;(i1 < EBR_DATA);i1 = (i1 + 1))
                                    begin : DATA_x
                                        localparam ECO_POSX = (i1 * W_DATA_WIDTH_IMPL) ; 
                                        localparam ECO_POSY = (i0 * W_ADDR_DEPTH_IMPL) ; 
                                        wire [(W_DATA_WIDTH_IMPL - 1):0] act_wr_data_w ; 
                                        wire [(R_DATA_WIDTH_IMPL - 1):0] act_rd_data_w ; 
                                        wire one_err_det_ebr_w ; 
                                        wire two_err_det_ebr_w ; 
                                        assign one_err_det_ind_w[i1] = one_err_det_ebr_w ; 
                                        assign two_err_det_ind_w[i1] = two_err_det_ebr_w ; 
                                        if (((W_DATA_WIDTH_IMPL * (i1 + 1)) <= W_PORT_USE)) 
                                            begin : genblk1
                                                assign act_wr_data_w = master_data_in_w[((W_DATA_WIDTH_IMPL * (i1 + 1)) - 1):(W_DATA_WIDTH_IMPL * i1)] ; 
                                            end
                                        else
                                            begin : genblk1
                                                assign act_wr_data_w[(W_DATA_WIDTH_IMPL - 1):(W_PORT_USE - (i1 * W_DATA_WIDTH_IMPL))] = 'h0000 ; 
                                                assign act_wr_data_w[(W_PORT_USE - (1 + (W_DATA_WIDTH_IMPL * i1))):0] = master_data_in_w[(W_PORT_USE - 1):(W_DATA_WIDTH_IMPL * i1)] ; 
                                            end
                                        if (((R_DATA_WIDTH_IMPL * (i1 + 1)) <= R_PORT_USE)) 
                                            begin : genblk2
                                                assign raw_output_w[((R_DATA_WIDTH_IMPL * (i1 + 1)) - 1):(R_DATA_WIDTH_IMPL * i1)] = act_rd_data_w ; 
                                            end
                                        else
                                            begin : genblk2
                                                assign raw_output_w[(R_PORT_USE - 1):(R_DATA_WIDTH_IMPL * i1)] = act_rd_data_w[(R_PORT_USE - (1 + (R_DATA_WIDTH_IMPL * i1))):0] ; 
                                            end
                                        wire f_wr_en_w = (chk_addr_wr_w & wr_en_i) ; 
                                        wire f_rd_en_w = (chk_addr_rd_w & rd_en_i) ; 
                                        if ((INIT_MODE == "mem_file")) 
                                            begin : mem_init
                                                FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .POSx(ECO_POSX),
                                                        .POSy(ECO_POSY),
                                                        .FAMILY(FAMILY),
                                                        ._FCODE_ICE_(_FCODE_ICE_),
                                                        ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                        ._FCODE_AP6_(_FCODE_AP6_),
                                                        ._FCODE_COMMON_(_FCODE_COMMON_),
                                                        .DATA_WIDTH_W(W_DATA_WIDTH_IMPL),
                                                        .DATA_WIDTH_R(R_DATA_WIDTH_IMPL),
                                                        .REGMODE(REGMODE),
                                                        .RESETMODE(RESETMODE),
                                                        .RESET_RELEASE(RESET_RELEASE),
                                                        .BYTE_ENABLE(0),
                                                        .ECC_ENABLE(ECC_ENABLE),
                                                        .INIT_MODE(INIT_MODE),
                                                        .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                        .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                                        .INIT_VALUE_00(INIT_VALUE_00[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_01(INIT_VALUE_01[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_02(INIT_VALUE_02[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_03(INIT_VALUE_03[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_04(INIT_VALUE_04[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_05(INIT_VALUE_05[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_06(INIT_VALUE_06[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_07(INIT_VALUE_07[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_08(INIT_VALUE_08[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_09(INIT_VALUE_09[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0A(INIT_VALUE_0A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0B(INIT_VALUE_0B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0C(INIT_VALUE_0C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0D(INIT_VALUE_0D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0E(INIT_VALUE_0E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0F(INIT_VALUE_0F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                            .rd_clk_i(rd_clk_i), 
                                                            .rst_i(rst_i), 
                                                            .wr_clk_en_i(wr_clk_en_i), 
                                                            .rd_clk_en_i(rd_clk_en_i), 
                                                            .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                            .wr_en_i(f_wr_en_w), 
                                                            .wr_data_i(act_wr_data_w), 
                                                            .wr_addr_i(act_wr_addr_w), 
                                                            .rd_en_i(f_rd_en_w), 
                                                            .rd_addr_i(act_rd_addr_w), 
                                                            .ben_i(1'b1), 
                                                            .rd_data_o(act_rd_data_w), 
                                                            .one_err_det_o(one_err_det_ebr_w), 
                                                            .two_err_det_o(two_err_det_ebr_w)) ; 
                                            end
                                        else
                                            begin : no_init
                                                FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .POSx(ECO_POSX),
                                                        .POSy(ECO_POSY),
                                                        .FAMILY(FAMILY),
                                                        ._FCODE_ICE_(_FCODE_ICE_),
                                                        ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                        ._FCODE_AP6_(_FCODE_AP6_),
                                                        ._FCODE_COMMON_(_FCODE_COMMON_),
                                                        .DATA_WIDTH_W(W_DATA_WIDTH_IMPL),
                                                        .DATA_WIDTH_R(R_DATA_WIDTH_IMPL),
                                                        .INIT_MODE(INIT_MODE),
                                                        .REGMODE(REGMODE),
                                                        .RESETMODE(RESETMODE),
                                                        .RESET_RELEASE(RESET_RELEASE),
                                                        .BYTE_ENABLE(0),
                                                        .ECC_ENABLE(ECC_ENABLE),
                                                        .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                        .BYTE_ENABLE_POL(BYTE_ENABLE_POL)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                            .rd_clk_i(rd_clk_i), 
                                                            .rst_i(rst_i), 
                                                            .wr_clk_en_i(wr_clk_en_i), 
                                                            .rd_clk_en_i(rd_clk_en_i), 
                                                            .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                            .wr_en_i(f_wr_en_w), 
                                                            .wr_data_i(act_wr_data_w), 
                                                            .wr_addr_i(act_wr_addr_w), 
                                                            .rd_en_i(f_rd_en_w), 
                                                            .rd_addr_i(act_rd_addr_w), 
                                                            .ben_i(1'b1), 
                                                            .rd_data_o(act_rd_data_w), 
                                                            .one_err_det_o(one_err_det_ebr_w), 
                                                            .two_err_det_o(two_err_det_ebr_w)) ; 
                                            end
                                    end
                                end
                                if ((EBR_ADDR == 1)) 
                                    begin : genblk2
                                        assign master_data_out_w = rd_data_raw_w[0] ; 
                                        assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_raw_w[0] : 1'b0) ; 
                                        assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_raw_w[0] : 1'b0) ; 
                                    end
                                else
                                    begin : genblk2
                                        reg [(R_PORT_USE - 1):0] rd_out_buff_r ; 
                                        reg [(RADDR_WIDTH - 1):0] rd_addr_0_r ; 
                                        reg one_err_det_r ; 
                                        reg two_err_det_r ; 
                                        assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_r : 1'b0) ; 
                                        assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_r : 1'b0) ; 
                                        if ((REGMODE == "noreg")) 
                                            begin : _nreg
                                                if ((RESETMODE == "sync")) 
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                                    end
                                                            end
                                                    end
                                                else
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i or 
                                                                posedge rst_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                                    end
                                                            end
                                                    end
                                            end
                                        else
                                            begin : _reg
                                                reg [(RADDR_WIDTH - 1):0] rd_addr_1_r = {RADDR_WIDTH{1'b0}} ; 
                                                if ((RESETMODE == "sync")) 
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                        rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        rd_addr_0_r <=  rd_addr_1_r ;
                                                                        rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                                    end
                                                            end
                                                    end
                                                else
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i or 
                                                                posedge rst_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                        rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        rd_addr_0_r <=  rd_addr_1_r ;
                                                                        rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                                    end
                                                            end
                                                    end
                                            end
                                        always
                                            @(*)
                                            begin
                                                rd_out_buff_r = rd_data_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                one_err_det_r = one_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                two_err_det_r = two_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                            end
                                        assign master_data_out_w = rd_out_buff_r ; 
                                    end
                            end
                    end
                else
                    begin : MIX_W_BYTE_EN
                        localparam MAX_DATA = ((RDATA_WIDTH > WDATA_WIDTH) ? RDATA_WIDTH : WDATA_WIDTH) ; 
                        localparam MIN_DATA = ((RDATA_WIDTH > WDATA_WIDTH) ? WDATA_WIDTH : RDATA_WIDTH) ; 
                        if ((is_byte_enable_good(MAX_DATA,
                                MIN_DATA,
                                FAMILY_CODE) == 1)) 
                            begin : BYTE_PASS
                                localparam W_DATA_WIDTH_IMPL = getCASE1DataImpl_wBen(WADDR_DEPTH,
                                            WDATA_WIDTH,
                                            RADDR_DEPTH,
                                            RDATA_WIDTH,
                                            1,
                                            FAMILY_CODE) ; 
                                localparam W_ADDR_DEPTH_IMPL = data_to_addr(W_DATA_WIDTH_IMPL,
                                            FAMILY_CODE) ; 
                                localparam W_ADDR_WIDTH_IMPL = clog2(W_ADDR_DEPTH_IMPL) ; 
                                localparam R_DATA_WIDTH_IMPL = getCASE1DataImpl_wBen(WADDR_DEPTH,
                                            WDATA_WIDTH,
                                            RADDR_DEPTH,
                                            RDATA_WIDTH,
                                            0,
                                            FAMILY_CODE) ; 
                                localparam R_ADDR_DEPTH_IMPL = data_to_addr(R_DATA_WIDTH_IMPL,
                                            FAMILY_CODE) ; 
                                localparam R_ADDR_WIDTH_IMPL = clog2(R_ADDR_DEPTH_IMPL) ; 
                                localparam EBR_ADDR = roundUP(WADDR_DEPTH,
                                            W_ADDR_DEPTH_IMPL) ; 
                                localparam EBR_DATA = roundUP(WDATA_WIDTH,
                                            W_DATA_WIDTH_IMPL) ; 
                                localparam TRUE_BYTE_WIDTH = getTrueByteWidth(W_DATA_WIDTH_IMPL,
                                            FAMILY_CODE) ; 
                                wire [(RDATA_WIDTH - 1):0] rd_data_raw_w [(EBR_ADDR - 1):0] ; 
                                wire [(BYTE_WIDTH - 1):0] byte_en_buffer_w ; 
                                wire [(WDATA_WIDTH - 1):0] master_data_in_w ; 
                                wire [(RDATA_WIDTH - 1):0] master_data_out_w ; 
                                if ((EBR_DATA > 1)) 
                                    begin : WIRE_chk
                                        if ((WDATA_WIDTH > RDATA_WIDTH)) 
                                            begin : W_OVR_R
                                                assign rd_data_o = master_data_out_w ; 
                                                wire [(R_DATA_WIDTH_IMPL - 1):0] master_data_ind_w [((WDATA_WIDTH / R_DATA_WIDTH_IMPL) - 1):0] ; 
                                                for (i_0 = 0;(i_0 < EBR_DATA);i_0 = (i_0 + 1))
                                                begin : genblk1
                                                    for (i_1 = 0;(i_1 < (WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL)));i_1 = (i_1 + 1))
                                                    begin : genblk1
                                                        assign master_data_ind_w[(((WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL)) * i_0) + i_1)] = wr_data_i[((((i_0 * R_DATA_WIDTH_IMPL) + ((i_1 * EBR_DATA) * R_DATA_WIDTH_IMPL)) + R_DATA_WIDTH_IMPL) - 1):((i_0 * R_DATA_WIDTH_IMPL) + ((i_1 * EBR_DATA) * R_DATA_WIDTH_IMPL))] ; 
                                                    end
                                                end
                                                localparam BYTE_EN_BUFF = (TRUE_BYTE_WIDTH / (WDATA_WIDTH / RDATA_WIDTH)) ; 
                                                for (i_0 = 0;(i_0 < (WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL)));i_0 = (i_0 + 1))
                                                begin : genblk2
                                                    for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                                    begin : genblk1
                                                        assign byte_en_buffer_w[(((((i_1 * (WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL))) + i_0) * BYTE_EN_BUFF) + BYTE_EN_BUFF) - 1):(((i_1 * (WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL))) + i_0) * BYTE_EN_BUFF)] = ben_i[(((((i_0 * EBR_DATA) + i_1) * BYTE_EN_BUFF) + BYTE_EN_BUFF) - 1):(((i_0 * EBR_DATA) + i_1) * BYTE_EN_BUFF)] ; 
                                                    end
                                                end
                                                for (i_0 = 0;(i_0 < (WDATA_WIDTH / R_DATA_WIDTH_IMPL));i_0 = (i_0 + 1))
                                                begin : genblk3
                                                    assign master_data_in_w[(((i_0 * R_DATA_WIDTH_IMPL) + R_DATA_WIDTH_IMPL) - 1):(i_0 * R_DATA_WIDTH_IMPL)] = master_data_ind_w[i_0] ; 
                                                end
                                            end
                                        else
                                            begin : R_OVR_W
                                                assign master_data_in_w = wr_data_i ; 
                                                assign byte_en_buffer_w = ben_i ; 
                                                wire [(W_DATA_WIDTH_IMPL - 1):0] master_data_ind_out [((RDATA_WIDTH / W_DATA_WIDTH_IMPL) - 1):0] ; 
                                                for (i_0 = 0;(i_0 < (RDATA_WIDTH / WDATA_WIDTH));i_0 = (i_0 + 1))
                                                begin : genblk1
                                                    for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                                    begin : genblk1
                                                        assign master_data_ind_out[(i_1 + (i_0 * EBR_DATA))] = master_data_out_w[((((i_0 * W_DATA_WIDTH_IMPL) + (i_1 * R_DATA_WIDTH_IMPL)) + W_DATA_WIDTH_IMPL) - 1):((i_0 * W_DATA_WIDTH_IMPL) + (i_1 * R_DATA_WIDTH_IMPL))] ; 
                                                    end
                                                end
                                                for (i_0 = 0;(i_0 < (RDATA_WIDTH / W_DATA_WIDTH_IMPL));i_0 = (i_0 + 1))
                                                begin : genblk2
                                                    assign rd_data_o[(((i_0 + 1) * W_DATA_WIDTH_IMPL) - 1):(i_0 * W_DATA_WIDTH_IMPL)] = master_data_ind_out[i_0] ; 
                                                end
                                            end
                                    end
                                else
                                    if ((EBR_ADDR > 1)) 
                                        begin : genblk1
                                            assign master_data_in_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                            assign byte_en_buffer_w[(TRUE_BYTE_WIDTH - 1):0] = ben_i ; 
                                            assign rd_data_o = master_data_out_w[(RDATA_WIDTH - 1):0] ; 
                                        end
                                if (((EBR_ADDR == 1) && (EBR_DATA == 1))) 
                                    begin : SINGLE_IMPL
                                        localparam W_SINGULAR_DATA_x = WDATA_WIDTH ; 
                                        localparam W_SINGULAR_ADDR_x = clog2(data_to_addr(W_SINGULAR_DATA_x,
                                                        FAMILY_CODE)) ; 
                                        localparam R_SINGULAR_DATA_x = RDATA_WIDTH ; 
                                        localparam R_SINGULAR_ADDR_x = clog2(data_to_addr(R_SINGULAR_DATA_x,
                                                        FAMILY_CODE)) ; 
                                        wire [(W_SINGULAR_DATA_x - 1):0] single_true_wr_in_w ; 
                                        wire [(R_SINGULAR_DATA_x - 1):0] single_true_rd_out_w ; 
                                        wire [(W_SINGULAR_ADDR_x - 1):0] single_true_wr_addr_w ; 
                                        wire [(R_SINGULAR_ADDR_x - 1):0] single_true_rd_addr_w ; 
                                        assign single_true_wr_in_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                        if ((W_SINGULAR_ADDR_x > WADDR_WIDTH)) 
                                            begin : genblk1
                                                assign single_true_wr_addr_w[(W_SINGULAR_ADDR_x - 1):WADDR_WIDTH] = 'h0000 ; 
                                            end
                                        assign single_true_wr_addr_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                        assign rd_data_o = single_true_rd_out_w ; 
                                        if ((R_SINGULAR_ADDR_x > RADDR_WIDTH)) 
                                            begin : genblk2
                                                assign single_true_rd_addr_w[(R_SINGULAR_ADDR_x - 1):RADDR_WIDTH] = 'h0000 ; 
                                            end
                                        assign single_true_rd_addr_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                        if ((INIT_MODE == "mem_file")) 
                                            begin : mem_init
                                                FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .FAMILY(FAMILY),
                                                        ._FCODE_ICE_(_FCODE_ICE_),
                                                        ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                        ._FCODE_AP6_(_FCODE_AP6_),
                                                        ._FCODE_COMMON_(_FCODE_COMMON_),
                                                        .DATA_WIDTH_W(W_SINGULAR_DATA_x),
                                                        .DATA_WIDTH_R(R_SINGULAR_DATA_x),
                                                        .REGMODE(REGMODE),
                                                        .RESETMODE(RESETMODE),
                                                        .RESET_RELEASE(RESET_RELEASE),
                                                        .BYTE_ENABLE(1),
                                                        .ECC_ENABLE(ECC_ENABLE),
                                                        .INIT_MODE(INIT_MODE),
                                                        .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                        .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                                        .INIT_VALUE_00(INIT_VALUE_00),
                                                        .INIT_VALUE_01(INIT_VALUE_01),
                                                        .INIT_VALUE_02(INIT_VALUE_02),
                                                        .INIT_VALUE_03(INIT_VALUE_03),
                                                        .INIT_VALUE_04(INIT_VALUE_04),
                                                        .INIT_VALUE_05(INIT_VALUE_05),
                                                        .INIT_VALUE_06(INIT_VALUE_06),
                                                        .INIT_VALUE_07(INIT_VALUE_07),
                                                        .INIT_VALUE_08(INIT_VALUE_08),
                                                        .INIT_VALUE_09(INIT_VALUE_09),
                                                        .INIT_VALUE_0A(INIT_VALUE_0A),
                                                        .INIT_VALUE_0B(INIT_VALUE_0B),
                                                        .INIT_VALUE_0C(INIT_VALUE_0C),
                                                        .INIT_VALUE_0D(INIT_VALUE_0D),
                                                        .INIT_VALUE_0E(INIT_VALUE_0E),
                                                        .INIT_VALUE_0F(INIT_VALUE_0F),
                                                        .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10 : "0x00")),
                                                        .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11 : "0x00")),
                                                        .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12 : "0x00")),
                                                        .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13 : "0x00")),
                                                        .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14 : "0x00")),
                                                        .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15 : "0x00")),
                                                        .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16 : "0x00")),
                                                        .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17 : "0x00")),
                                                        .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18 : "0x00")),
                                                        .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19 : "0x00")),
                                                        .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A : "0x00")),
                                                        .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B : "0x00")),
                                                        .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C : "0x00")),
                                                        .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D : "0x00")),
                                                        .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E : "0x00")),
                                                        .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F : "0x00")),
                                                        .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20 : "0x00")),
                                                        .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21 : "0x00")),
                                                        .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22 : "0x00")),
                                                        .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23 : "0x00")),
                                                        .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24 : "0x00")),
                                                        .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25 : "0x00")),
                                                        .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26 : "0x00")),
                                                        .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27 : "0x00")),
                                                        .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28 : "0x00")),
                                                        .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29 : "0x00")),
                                                        .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A : "0x00")),
                                                        .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B : "0x00")),
                                                        .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C : "0x00")),
                                                        .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D : "0x00")),
                                                        .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E : "0x00")),
                                                        .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F : "0x00")),
                                                        .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30 : "0x00")),
                                                        .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31 : "0x00")),
                                                        .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32 : "0x00")),
                                                        .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33 : "0x00")),
                                                        .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34 : "0x00")),
                                                        .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35 : "0x00")),
                                                        .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36 : "0x00")),
                                                        .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37 : "0x00")),
                                                        .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38 : "0x00")),
                                                        .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39 : "0x00")),
                                                        .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A : "0x00")),
                                                        .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B : "0x00")),
                                                        .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C : "0x00")),
                                                        .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D : "0x00")),
                                                        .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E : "0x00")),
                                                        .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F : "0x00")),
                                                        .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40 : "0x00")),
                                                        .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41 : "0x00")),
                                                        .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42 : "0x00")),
                                                        .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43 : "0x00")),
                                                        .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44 : "0x00")),
                                                        .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45 : "0x00")),
                                                        .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46 : "0x00")),
                                                        .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47 : "0x00")),
                                                        .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48 : "0x00")),
                                                        .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49 : "0x00")),
                                                        .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A : "0x00")),
                                                        .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B : "0x00")),
                                                        .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C : "0x00")),
                                                        .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D : "0x00")),
                                                        .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E : "0x00")),
                                                        .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F : "0x00")),
                                                        .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50 : "0x00")),
                                                        .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51 : "0x00")),
                                                        .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52 : "0x00")),
                                                        .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53 : "0x00")),
                                                        .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54 : "0x00")),
                                                        .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55 : "0x00")),
                                                        .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56 : "0x00")),
                                                        .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57 : "0x00")),
                                                        .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58 : "0x00")),
                                                        .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59 : "0x00")),
                                                        .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A : "0x00")),
                                                        .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B : "0x00")),
                                                        .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C : "0x00")),
                                                        .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D : "0x00")),
                                                        .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E : "0x00")),
                                                        .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F : "0x00")),
                                                        .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60 : "0x00")),
                                                        .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61 : "0x00")),
                                                        .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62 : "0x00")),
                                                        .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63 : "0x00")),
                                                        .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64 : "0x00")),
                                                        .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65 : "0x00")),
                                                        .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66 : "0x00")),
                                                        .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67 : "0x00")),
                                                        .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68 : "0x00")),
                                                        .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69 : "0x00")),
                                                        .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A : "0x00")),
                                                        .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B : "0x00")),
                                                        .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C : "0x00")),
                                                        .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D : "0x00")),
                                                        .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E : "0x00")),
                                                        .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F : "0x00")),
                                                        .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70 : "0x00")),
                                                        .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71 : "0x00")),
                                                        .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72 : "0x00")),
                                                        .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73 : "0x00")),
                                                        .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74 : "0x00")),
                                                        .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75 : "0x00")),
                                                        .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76 : "0x00")),
                                                        .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77 : "0x00")),
                                                        .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78 : "0x00")),
                                                        .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79 : "0x00")),
                                                        .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A : "0x00")),
                                                        .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B : "0x00")),
                                                        .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C : "0x00")),
                                                        .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D : "0x00")),
                                                        .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E : "0x00")),
                                                        .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                            .rd_clk_i(rd_clk_i), 
                                                            .rst_i(rst_i), 
                                                            .wr_clk_en_i(wr_clk_en_i), 
                                                            .rd_clk_en_i(rd_clk_en_i), 
                                                            .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                            .wr_en_i(wr_en_i), 
                                                            .wr_data_i(single_true_wr_in_w), 
                                                            .wr_addr_i(single_true_wr_addr_w), 
                                                            .rd_en_i(rd_en_i), 
                                                            .rd_addr_i(single_true_rd_addr_w), 
                                                            .ben_i(ben_i), 
                                                            .rd_data_o(single_true_rd_out_w), 
                                                            .one_err_det_o(one_err_det_o), 
                                                            .two_err_det_o(two_err_det_o)) ; 
                                            end
                                        else
                                            begin : no_init
                                                FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .FAMILY(FAMILY),
                                                        ._FCODE_ICE_(_FCODE_ICE_),
                                                        ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                        ._FCODE_AP6_(_FCODE_AP6_),
                                                        ._FCODE_COMMON_(_FCODE_COMMON_),
                                                        .DATA_WIDTH_W(W_SINGULAR_DATA_x),
                                                        .DATA_WIDTH_R(R_SINGULAR_DATA_x),
                                                        .REGMODE(REGMODE),
                                                        .RESETMODE(RESETMODE),
                                                        .RESET_RELEASE(RESET_RELEASE),
                                                        .BYTE_ENABLE(1),
                                                        .ECC_ENABLE(ECC_ENABLE),
                                                        .INIT_MODE(INIT_MODE),
                                                        .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                        .BYTE_ENABLE_POL(BYTE_ENABLE_POL)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                            .rd_clk_i(rd_clk_i), 
                                                            .rst_i(rst_i), 
                                                            .wr_clk_en_i(wr_clk_en_i), 
                                                            .rd_clk_en_i(rd_clk_en_i), 
                                                            .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                            .wr_en_i(wr_en_i), 
                                                            .wr_data_i(single_true_wr_in_w), 
                                                            .wr_addr_i(single_true_wr_addr_w), 
                                                            .rd_en_i(rd_en_i), 
                                                            .rd_addr_i(single_true_rd_addr_w), 
                                                            .ben_i(ben_i), 
                                                            .rd_data_o(single_true_rd_out_w), 
                                                            .one_err_det_o(one_err_det_o), 
                                                            .two_err_det_o(two_err_det_o)) ; 
                                            end
                                    end
                                else
                                    begin : MULT_IMPL
                                        wire [(EBR_ADDR - 1):0] one_err_det_raw_w ; 
                                        wire [(EBR_ADDR - 1):0] two_err_det_raw_w ; 
                                        for (i0 = 0;(i0 < EBR_ADDR);i0 = (i0 + 1))
                                        begin : ADDR_x
                                            wire [(RDATA_WIDTH - 1):0] raw_output_w ; 
                                            assign rd_data_raw_w[i0] = raw_output_w ; 
                                            wire chk_addr_wr_w ; 
                                            if ((EBR_ADDR > 1)) 
                                                begin : genblk1
                                                    assign chk_addr_wr_w = (wr_addr_i[(WADDR_WIDTH - 1):W_ADDR_WIDTH_IMPL] == i0) ; 
                                                end
                                            else
                                                begin : genblk1
                                                    assign chk_addr_wr_w = 1'b1 ; 
                                                end
                                            wire [(W_ADDR_WIDTH_IMPL - 1):0] act_wr_addr_w ; 
                                            if ((W_ADDR_WIDTH_IMPL > WADDR_WIDTH)) 
                                                begin : genblk2
                                                    assign act_wr_addr_w[(W_ADDR_WIDTH_IMPL - 1):WADDR_WIDTH] = 'h0000 ; 
                                                    assign act_wr_addr_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                                end
                                            else
                                                begin : genblk2
                                                    assign act_wr_addr_w = wr_addr_i[(W_ADDR_WIDTH_IMPL - 1):0] ; 
                                                end
                                            wire chk_addr_rd_w ; 
                                            if ((EBR_ADDR > 1)) 
                                                begin : genblk3
                                                    assign chk_addr_rd_w = (rd_addr_i[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL] == i0) ; 
                                                end
                                            else
                                                begin : genblk3
                                                    assign chk_addr_rd_w = 1'b1 ; 
                                                end
                                            wire [(R_ADDR_WIDTH_IMPL - 1):0] act_rd_addr_w ; 
                                            if ((R_ADDR_WIDTH_IMPL > RADDR_WIDTH)) 
                                                begin : genblk4
                                                    assign act_rd_addr_w[(R_ADDR_WIDTH_IMPL - 1):RADDR_WIDTH] = 'h0000 ; 
                                                    assign act_rd_addr_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                                end
                                            else
                                                begin : genblk4
                                                    assign act_rd_addr_w = rd_addr_i[(R_ADDR_WIDTH_IMPL - 1):0] ; 
                                                end
                                            wire [(EBR_DATA - 1):0] one_err_det_ind_w ; 
                                            wire [(EBR_DATA - 1):0] two_err_det_ind_w ; 
                                            if ((EBR_DATA == 1)) 
                                                begin : genblk5
                                                    assign one_err_det_raw_w[i0] = one_err_det_ind_w[0] ; 
                                                    assign two_err_det_raw_w[i0] = two_err_det_ind_w[0] ; 
                                                end
                                            else
                                                begin : genblk5
                                                    assign one_err_det_raw_w[i0] = (|one_err_det_ind_w) ; 
                                                    assign two_err_det_raw_w[i0] = (|two_err_det_ind_w) ; 
                                                end
                                            for (i1 = 0;(i1 < EBR_DATA);i1 = (i1 + 1))
                                            begin : DATA_x
                                                localparam ECO_POSX = (i1 * W_DATA_WIDTH_IMPL) ; 
                                                localparam ECO_POSY = (i0 * W_ADDR_DEPTH_IMPL) ; 
                                                wire [(W_DATA_WIDTH_IMPL - 1):0] act_wr_data_w ; 
                                                wire [(R_DATA_WIDTH_IMPL - 1):0] act_rd_data_w ; 
                                                wire [(TRUE_BYTE_WIDTH - 1):0] act_ben_w ; 
                                                wire one_err_det_ebr_w ; 
                                                wire two_err_det_ebr_w ; 
                                                assign one_err_det_ind_w[i1] = one_err_det_ebr_w ; 
                                                assign two_err_det_ind_w[i1] = two_err_det_ebr_w ; 
                                                if (((W_DATA_WIDTH_IMPL * (i1 + 1)) <= WDATA_WIDTH)) 
                                                    begin : genblk1
                                                        assign act_wr_data_w = master_data_in_w[((W_DATA_WIDTH_IMPL * (i1 + 1)) - 1):(W_DATA_WIDTH_IMPL * i1)] ; 
                                                    end
                                                else
                                                    begin : genblk1
                                                        assign act_wr_data_w[(W_DATA_WIDTH_IMPL - 1):(WDATA_WIDTH - (i1 * W_DATA_WIDTH_IMPL))] = 'h0000 ; 
                                                        assign act_wr_data_w[(WDATA_WIDTH - (1 + (W_DATA_WIDTH_IMPL * i1))):0] = master_data_in_w[(WDATA_WIDTH - 1):(W_DATA_WIDTH_IMPL * i1)] ; 
                                                    end
                                                if (((R_DATA_WIDTH_IMPL * (i1 + 1)) <= RDATA_WIDTH)) 
                                                    begin : genblk2
                                                        assign raw_output_w[((R_DATA_WIDTH_IMPL * (i1 + 1)) - 1):(R_DATA_WIDTH_IMPL * i1)] = act_rd_data_w ; 
                                                    end
                                                else
                                                    begin : genblk2
                                                        assign raw_output_w[(RDATA_WIDTH - 1):(R_DATA_WIDTH_IMPL * i1)] = act_rd_data_w[(RDATA_WIDTH - (1 + (R_DATA_WIDTH_IMPL * i1))):0] ; 
                                                    end
                                                if ((TRUE_BYTE_WIDTH > 1)) 
                                                    begin : genblk3
                                                        if ((((i1 + 1) * TRUE_BYTE_WIDTH) <= BYTE_WIDTH)) 
                                                            begin : genblk1
                                                                assign act_ben_w = byte_en_buffer_w[(((i1 + 1) * TRUE_BYTE_WIDTH) - 1):(i1 * TRUE_BYTE_WIDTH)] ; 
                                                            end
                                                        else
                                                            begin : genblk1
                                                                assign act_ben_w[(BYTE_WIDTH - (1 + (i1 * TRUE_BYTE_WIDTH))):0] = byte_en_buffer_w[(BYTE_WIDTH - 1):(i1 * TRUE_BYTE_WIDTH)] ; 
                                                                assign act_ben_w[(TRUE_BYTE_WIDTH - 1):(BYTE_WIDTH - (i1 * TRUE_BYTE_WIDTH))] = {(TRUE_BYTE_WIDTH - (BYTE_WIDTH - (i1 * TRUE_BYTE_WIDTH))){1'b1}} ; 
                                                            end
                                                    end
                                                else
                                                    begin : genblk3
                                                        assign act_ben_w[0] = byte_en_buffer_w[i1] ; 
                                                    end
                                                wire f_wr_en_w = (chk_addr_wr_w & wr_en_i) ; 
                                                wire f_rd_en_w = (chk_addr_rd_w & rd_en_i) ; 
                                                if ((INIT_MODE == "mem_file")) 
                                                    begin : mem_init
                                                        FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                                                .MEM_SIZE(MEM_SIZE),
                                                                .POSx(ECO_POSX),
                                                                .POSy(ECO_POSY),
                                                                .FAMILY(FAMILY),
                                                                ._FCODE_ICE_(_FCODE_ICE_),
                                                                ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                                ._FCODE_AP6_(_FCODE_AP6_),
                                                                ._FCODE_COMMON_(_FCODE_COMMON_),
                                                                .DATA_WIDTH_W(W_DATA_WIDTH_IMPL),
                                                                .DATA_WIDTH_R(R_DATA_WIDTH_IMPL),
                                                                .REGMODE(REGMODE),
                                                                .RESETMODE(RESETMODE),
                                                                .RESET_RELEASE(RESET_RELEASE),
                                                                .BYTE_ENABLE(1),
                                                                .ECC_ENABLE(ECC_ENABLE),
                                                                .INIT_MODE(INIT_MODE),
                                                                .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                                .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                                                .INIT_VALUE_00(INIT_VALUE_00[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_01(INIT_VALUE_01[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_02(INIT_VALUE_02[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_03(INIT_VALUE_03[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_04(INIT_VALUE_04[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_05(INIT_VALUE_05[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_06(INIT_VALUE_06[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_07(INIT_VALUE_07[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_08(INIT_VALUE_08[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_09(INIT_VALUE_09[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0A(INIT_VALUE_0A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0B(INIT_VALUE_0B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0C(INIT_VALUE_0C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0D(INIT_VALUE_0D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0E(INIT_VALUE_0E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0F(INIT_VALUE_0F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                                    .rd_clk_i(rd_clk_i), 
                                                                    .rst_i(rst_i), 
                                                                    .wr_clk_en_i(wr_clk_en_i), 
                                                                    .rd_clk_en_i(rd_clk_en_i), 
                                                                    .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                                    .wr_en_i(f_wr_en_w), 
                                                                    .wr_data_i(act_wr_data_w), 
                                                                    .wr_addr_i(act_wr_addr_w), 
                                                                    .rd_en_i(f_rd_en_w), 
                                                                    .rd_addr_i(act_rd_addr_w), 
                                                                    .ben_i(act_ben_w), 
                                                                    .rd_data_o(act_rd_data_w), 
                                                                    .one_err_det_o(one_err_det_ebr_w), 
                                                                    .two_err_det_o(two_err_det_ebr_w)) ; 
                                                    end
                                                else
                                                    begin : no_init
                                                        FIFO_A2B_ipgen_lscc_fifo_mem_core #(.MEM_ID(MEM_ID),
                                                                .MEM_SIZE(MEM_SIZE),
                                                                .POSx(ECO_POSX),
                                                                .POSy(ECO_POSY),
                                                                .FAMILY(FAMILY),
                                                                ._FCODE_ICE_(_FCODE_ICE_),
                                                                ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                                ._FCODE_AP6_(_FCODE_AP6_),
                                                                ._FCODE_COMMON_(_FCODE_COMMON_),
                                                                .DATA_WIDTH_W(W_DATA_WIDTH_IMPL),
                                                                .DATA_WIDTH_R(R_DATA_WIDTH_IMPL),
                                                                .REGMODE(REGMODE),
                                                                .RESETMODE(RESETMODE),
                                                                .RESET_RELEASE(RESET_RELEASE),
                                                                .BYTE_ENABLE(1),
                                                                .ECC_ENABLE(ECC_ENABLE),
                                                                .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                                .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                                                .INIT_MODE(INIT_MODE)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                                    .rd_clk_i(rd_clk_i), 
                                                                    .rst_i(rst_i), 
                                                                    .wr_clk_en_i(wr_clk_en_i), 
                                                                    .rd_clk_en_i(rd_clk_en_i), 
                                                                    .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                                    .wr_en_i(f_wr_en_w), 
                                                                    .wr_data_i(act_wr_data_w), 
                                                                    .wr_addr_i(act_wr_addr_w), 
                                                                    .rd_en_i(f_rd_en_w), 
                                                                    .rd_addr_i(act_rd_addr_w), 
                                                                    .ben_i(act_ben_w), 
                                                                    .rd_data_o(act_rd_data_w), 
                                                                    .one_err_det_o(one_err_det_ebr_w), 
                                                                    .two_err_det_o(two_err_det_ebr_w)) ; 
                                                    end
                                            end
                                        end
                                        if ((EBR_ADDR == 1)) 
                                            begin : genblk2
                                                assign master_data_out_w = rd_data_raw_w[0] ; 
                                                assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_raw_w[0] : 1'b0) ; 
                                                assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_raw_w[0] : 1'b0) ; 
                                            end
                                        else
                                            begin : genblk2
                                                reg [(RDATA_WIDTH - 1):0] rd_out_buff_r ; 
                                                reg one_err_det_r = 1'b0 ; 
                                                reg two_err_det_r = 1'b0 ; 
                                                reg [(RADDR_WIDTH - 1):0] rd_addr_0_r ; 
                                                assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_r : 1'b0) ; 
                                                assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_r : 1'b0) ; 
                                                if ((REGMODE == "noreg")) 
                                                    begin : _nreg
                                                        if ((RESETMODE == "sync")) 
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                                            end
                                                                    end
                                                            end
                                                        else
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i or 
                                                                        posedge rst_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                                            end
                                                                    end
                                                            end
                                                    end
                                                else
                                                    begin : _reg
                                                        reg [(RADDR_WIDTH - 1):0] rd_addr_1_r ; 
                                                        if ((RESETMODE == "sync")) 
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                                rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                rd_addr_0_r <=  rd_addr_1_r ;
                                                                                rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                                            end
                                                                    end
                                                            end
                                                        else
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                                rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                rd_addr_0_r <=  rd_addr_1_r ;
                                                                                rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                                            end
                                                                    end
                                                            end
                                                    end
                                                always
                                                    @(*)
                                                    begin
                                                        rd_out_buff_r = rd_data_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                        one_err_det_r = one_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                        two_err_det_r = two_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                    end
                                                assign master_data_out_w = rd_out_buff_r ; 
                                            end
                                    end
                            end
                    end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [1:0] checkINIT ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                checkINIT = 1 ;
            _FCODE_AP6_ : 
                checkINIT = 2 ;
            default : 
                checkINIT = 0 ;
            endcase 
        end
    endfunction
    function [31:0] getTrueByteWidth ; 
        input [31:0] dwid_in ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                getTrueByteWidth = (((dwid_in == 36) || (dwid_in == 32)) ? 4 : (((dwid_in == 18) || (dwid_in == 16)) ? 2 : 1)) ;
            _FCODE_ICE_ : 
                getTrueByteWidth = ((dwid_in == 16) ? 2 : 1) ;
            _FCODE_AP6_ : 
                getTrueByteWidth = (((dwid_in == 72) || (dwid_in == 64)) ? 8 : (((dwid_in == 36) || (dwid_in == 32)) ? 4 : (((dwid_in == 18) || (dwid_in == 16)) ? 2 : 1))) ;
            default : 
                getTrueByteWidth = 1 ;
            endcase 
        end
    endfunction
    function [31:0] procData ; 
        input [31:0] TARGET_DATA ; 
        input isECC ; 
        input [31:0] FAMILY_CODE ; 
        begin
            procData = 1 ;
            while ((procData < TARGET_DATA))
                begin
                    case (FAMILY_CODE)
                    _FCODE_LIFCL_ : 
                        begin
                            if (isECC) 
                                begin
                                    if ((procData < 32)) 
                                        begin
                                            procData = 32 ;
                                        end
                                    else
                                        begin
                                            procData = (procData * 2) ;
                                        end
                                end
                            else
                                begin
                                    if ((procData < 8)) 
                                        begin
                                            procData = (procData * 2) ;
                                        end
                                    else
                                        begin
                                            if ((procData == 8)) 
                                                begin
                                                    procData = 9 ;
                                                end
                                            else
                                                if (((procData % 9) == 0)) 
                                                    begin
                                                        procData = ((procData / 9) * 16) ;
                                                    end
                                                else
                                                    begin
                                                        procData = ((procData / 8) * 9) ;
                                                    end
                                        end
                                end
                        end
                    _FCODE_ICE_ : 
                        procData = (procData * 2) ;
                    _FCODE_AP6_ : 
                        begin
                            if (isECC) 
                                begin
                                    if ((procData < 64)) 
                                        begin
                                            procData = 64 ;
                                        end
                                    else
                                        begin
                                            procData = (procData * 2) ;
                                        end
                                end
                            else
                                begin
                                    if ((procData < 8)) 
                                        begin
                                            procData = (procData * 2) ;
                                        end
                                    else
                                        begin
                                            if ((procData == 8)) 
                                                begin
                                                    procData = 9 ;
                                                end
                                            else
                                                if (((procData % 9) == 0)) 
                                                    begin
                                                        procData = ((procData / 9) * 16) ;
                                                    end
                                                else
                                                    begin
                                                        procData = ((procData / 8) * 9) ;
                                                    end
                                        end
                                end
                        end
                    default : 
                        procData = TARGET_DATA ;
                    endcase 
                end
        end
    endfunction
    function [31:0] getSingularCase ; 
        input [31:0] port_use ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    if ((port_use > 32)) 
                        getSingularCase = 36 ;
                    else
                        if ((port_use > 18)) 
                            getSingularCase = 32 ;
                        else
                            if ((port_use > 16)) 
                                getSingularCase = 18 ;
                            else
                                if ((port_use > 9)) 
                                    getSingularCase = 16 ;
                                else
                                    if ((port_use > 8)) 
                                        getSingularCase = 9 ;
                                    else
                                        getSingularCase = (2 ** clog2(port_use)) ;
                end
            _FCODE_ICE_ : 
                getSingularCase = (2 ** clog2(port_use)) ;
            _FCODE_AP6_ : 
                begin
                    if ((port_use > 64)) 
                        getSingularCase = 72 ;
                    else
                        if ((port_use > 36)) 
                            getSingularCase = 64 ;
                        else
                            if ((port_use > 32)) 
                                getSingularCase = 36 ;
                            else
                                if ((port_use > 18)) 
                                    getSingularCase = 32 ;
                                else
                                    if ((port_use > 16)) 
                                        getSingularCase = 18 ;
                                    else
                                        if ((port_use > 9)) 
                                            getSingularCase = 16 ;
                                        else
                                            if ((port_use > 8)) 
                                                getSingularCase = 9 ;
                                            else
                                                getSingularCase = (2 ** clog2(port_use)) ;
                end
            default : 
                getSingularCase = 8 ;
            endcase 
        end
    endfunction
    function [31:0] getCASE1DataImpl ; 
        input [31:0] wr_addr_depth ; 
        input [31:0] wr_data_width ; 
        input [31:0] rd_addr_depth ; 
        input [31:0] rd_data_width ; 
        input is_taking_write_port ; 
        input is_taking_total_ebr ; 
        input is_ecc ; 
        input [31:0] family_code ; 
        reg [5:0] num0, 
            num1, 
            limit ; 
        reg [31:0] divisor, 
            wr_addr_div, 
            wr_data_div, 
            rd_addr_div, 
            rd_data_div ; 
        reg [31:0] wr_addr_chk, 
            wr_data_chk, 
            rd_addr_chk, 
            rd_data_chk ; 
        reg [31:0] EBR_usage, 
            prod ; 
        begin
            divisor = ((wr_addr_depth > rd_addr_depth) ? (wr_addr_depth / rd_addr_depth) : (rd_addr_depth / wr_addr_depth)) ;
            EBR_usage = 32'hffffffff ;
            getCASE1DataImpl = 0 ;
            if ((is_ecc == 1)) 
                begin
                    if ((is_taking_write_port == 1)) 
                        begin
                            if ((family_code == _FCODE_AP6_)) 
                                getCASE1DataImpl = 64 ;
                            else
                                getCASE1DataImpl = 32 ;
                        end
                    else
                        begin
                            if ((family_code == _FCODE_AP6_)) 
                                getCASE1DataImpl = (64 / divisor) ;
                            else
                                getCASE1DataImpl = (32 / divisor) ;
                        end
                end
            else
                begin
                    if ((((family_code == _FCODE_LIFCL_) && (divisor <= 4)) || ((family_code == _FCODE_AP6_) && (divisor <= 8)))) 
                        begin
                            limit = ((family_code == _FCODE_LIFCL_) ? 3 : 4) ;
                            for (num0 = 0 ; (num0 < limit) ; num0 = (num0 + 1))
                                begin
                                    wr_data_div = getDatabase(9,
                                            num0,
                                            family_code) ;
                                    wr_addr_div = data_to_addr(wr_data_div,
                                            family_code) ;
                                    wr_addr_chk = roundUP(wr_addr_depth,
                                            wr_addr_div) ;
                                    wr_data_chk = roundUP(wr_data_width,
                                            wr_data_div) ;
                                    for (num1 = 0 ; (num1 < limit) ; num1 = (num1 + 1))
                                        begin
                                            rd_data_div = getDatabase(9,
                                                    num1,
                                                    family_code) ;
                                            rd_addr_div = data_to_addr(rd_data_div,
                                                    family_code) ;
                                            rd_addr_chk = roundUP(rd_addr_depth,
                                                    rd_addr_div) ;
                                            rd_data_chk = roundUP(rd_data_width,
                                                    rd_data_div) ;
                                            if (((wr_addr_chk == rd_addr_chk) && (wr_data_chk == rd_data_chk))) 
                                                begin
                                                    if ((((wr_data_width % wr_data_div) == 0) && ((rd_data_width % rd_data_div) == 0))) 
                                                        begin
                                                            prod = (wr_addr_chk * wr_data_chk) ;
                                                            if ((prod < EBR_usage)) 
                                                                begin
                                                                    EBR_usage = prod ;
                                                                    if ((is_taking_total_ebr == 1'b1)) 
                                                                        getCASE1DataImpl = EBR_usage ;
                                                                    else
                                                                        if ((is_taking_write_port == 1'b1)) 
                                                                            getCASE1DataImpl = wr_data_div ;
                                                                        else
                                                                            getCASE1DataImpl = rd_data_div ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
                    limit = ((family_code == _FCODE_LIFCL_) ? 6 : 7) ;
                    for (num0 = 0 ; (num0 < limit) ; num0 = (num0 + 1))
                        begin
                            wr_data_div = getDatabase(8,
                                    num0,
                                    family_code) ;
                            wr_addr_div = data_to_addr(wr_data_div,
                                    family_code) ;
                            wr_addr_chk = roundUP(wr_addr_depth,
                                    wr_addr_div) ;
                            wr_data_chk = roundUP(wr_data_width,
                                    wr_data_div) ;
                            for (num1 = 0 ; (num1 < limit) ; num1 = (num1 + 1))
                                begin
                                    rd_data_div = getDatabase(8,
                                            num1,
                                            family_code) ;
                                    rd_addr_div = data_to_addr(rd_data_div,
                                            family_code) ;
                                    rd_addr_chk = roundUP(rd_addr_depth,
                                            rd_addr_div) ;
                                    rd_data_chk = roundUP(rd_data_width,
                                            rd_data_div) ;
                                    if (((wr_addr_chk == rd_addr_chk) && (wr_data_chk == rd_data_chk))) 
                                        begin
                                            if ((((wr_data_width % wr_data_div) == 0) && ((rd_data_width % rd_data_div) == 0))) 
                                                begin
                                                    prod = (wr_addr_chk * wr_data_chk) ;
                                                    if ((prod < EBR_usage)) 
                                                        begin
                                                            EBR_usage = prod ;
                                                            if ((is_taking_total_ebr == 1'b1)) 
                                                                getCASE1DataImpl = EBR_usage ;
                                                            else
                                                                if ((is_taking_write_port == 1'b1)) 
                                                                    getCASE1DataImpl = wr_data_div ;
                                                                else
                                                                    getCASE1DataImpl = rd_data_div ;
                                                        end
                                                end
                                        end
                                end
                        end
                end
        end
    endfunction
    function [31:0] getCASE1DataImpl_wBen ; 
        input [31:0] wr_addr_depth ; 
        input [31:0] wr_data_width ; 
        input [31:0] rd_addr_depth ; 
        input [31:0] rd_data_width ; 
        input is_taking_write_port ; 
        input [31:0] family_code ; 
        reg [5:0] num0, 
            num1, 
            limit ; 
        reg [31:0] wr_addr_div, 
            wr_data_div, 
            rd_addr_div, 
            rd_data_div ; 
        reg [31:0] wr_addr_chk, 
            wr_data_chk, 
            rd_addr_chk, 
            rd_data_chk ; 
        reg [31:0] EBR_usage, 
            prod ; 
        begin
            if ((family_code == _FCODE_ICE_)) 
                begin
                    if ((wr_data_width > rd_data_width)) 
                        begin
                            if ((is_taking_write_port == 1)) 
                                getCASE1DataImpl_wBen = 16 ;
                            else
                                getCASE1DataImpl_wBen = 8 ;
                        end
                    else
                        begin
                            if ((is_taking_write_port == 1)) 
                                getCASE1DataImpl_wBen = 8 ;
                            else
                                getCASE1DataImpl_wBen = 16 ;
                        end
                end
            else
                if (((family_code == _FCODE_LIFCL_) || (family_code == _FCODE_AP6_))) 
                    begin
                        EBR_usage = 32'hffffffff ;
                        getCASE1DataImpl_wBen = 0 ;
                        limit = ((family_code == _FCODE_LIFCL_) ? 3 : 4) ;
                        if (((wr_data_width % 9) == 0)) 
                            begin
                                for (num0 = 0 ; (num0 < limit) ; num0 = (num0 + 1))
                                    begin
                                        wr_data_div = getDatabase_wBen(9,
                                                num0,
                                                family_code) ;
                                        wr_addr_div = data_to_addr(wr_data_div,
                                                family_code) ;
                                        wr_addr_chk = roundUP(wr_addr_depth,
                                                wr_addr_div) ;
                                        wr_data_chk = roundUP(wr_data_width,
                                                wr_data_div) ;
                                        for (num1 = 0 ; (num1 < limit) ; num1 = (num1 + 1))
                                            begin
                                                rd_data_div = getDatabase_wBen(9,
                                                        num1,
                                                        family_code) ;
                                                rd_addr_div = data_to_addr(rd_data_div,
                                                        family_code) ;
                                                rd_addr_chk = roundUP(rd_addr_depth,
                                                        rd_addr_div) ;
                                                rd_data_chk = roundUP(rd_data_width,
                                                        rd_data_div) ;
                                                if (((wr_addr_chk == rd_addr_chk) && (wr_data_chk == rd_data_chk))) 
                                                    begin
                                                        if ((((wr_data_width % wr_data_div) == 0) && ((rd_data_width % rd_data_div) == 0))) 
                                                            begin
                                                                prod = (wr_addr_chk * wr_data_chk) ;
                                                                if ((prod < EBR_usage)) 
                                                                    begin
                                                                        EBR_usage = prod ;
                                                                        if ((is_taking_write_port == 1'b1)) 
                                                                            getCASE1DataImpl_wBen = wr_data_div ;
                                                                        else
                                                                            getCASE1DataImpl_wBen = rd_data_div ;
                                                                    end
                                                            end
                                                    end
                                            end
                                    end
                            end
                        else
                            begin
                                for (num0 = 0 ; (num0 < limit) ; num0 = (num0 + 1))
                                    begin
                                        wr_data_div = getDatabase_wBen(8,
                                                num0,
                                                family_code) ;
                                        wr_addr_div = data_to_addr(wr_data_div,
                                                family_code) ;
                                        wr_addr_chk = roundUP(wr_addr_depth,
                                                wr_addr_div) ;
                                        wr_data_chk = roundUP(wr_data_width,
                                                wr_data_div) ;
                                        for (num1 = 0 ; (num1 < limit) ; num1 = (num1 + 1))
                                            begin
                                                rd_data_div = getDatabase_wBen(8,
                                                        num1,
                                                        family_code) ;
                                                rd_addr_div = data_to_addr(rd_data_div,
                                                        family_code) ;
                                                rd_addr_chk = roundUP(rd_addr_depth,
                                                        rd_addr_div) ;
                                                rd_data_chk = roundUP(rd_data_width,
                                                        rd_data_div) ;
                                                if (((wr_addr_chk == rd_addr_chk) && (wr_data_chk == rd_data_chk))) 
                                                    begin
                                                        if ((((wr_data_width % wr_data_div) == 0) && ((rd_data_width % rd_data_div) == 0))) 
                                                            begin
                                                                prod = (wr_addr_chk * wr_data_chk) ;
                                                                if ((prod < EBR_usage)) 
                                                                    begin
                                                                        EBR_usage = prod ;
                                                                        if ((is_taking_write_port == 1'b1)) 
                                                                            getCASE1DataImpl_wBen = wr_data_div ;
                                                                        else
                                                                            getCASE1DataImpl_wBen = rd_data_div ;
                                                                    end
                                                            end
                                                    end
                                            end
                                    end
                            end
                    end
        end
    endfunction
    function [31:0] getDatabase ; 
        input [31:0] base_count ; 
        input [31:0] index ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (base_count)
                    9 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 9 ;
                            1 : 
                                getDatabase = 18 ;
                            default : 
                                getDatabase = 36 ;
                            endcase 
                        end
                    8 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 1 ;
                            1 : 
                                getDatabase = 2 ;
                            2 : 
                                getDatabase = 4 ;
                            3 : 
                                getDatabase = 8 ;
                            4 : 
                                getDatabase = 16 ;
                            default : 
                                getDatabase = 32 ;
                            endcase 
                        end
                    default : 
                        getDatabase = 16 ;
                    endcase 
                end
            _FCODE_ICE_ : 
                begin
                    case (index)
                    0 : 
                        getDatabase = 2 ;
                    1 : 
                        getDatabase = 4 ;
                    2 : 
                        getDatabase = 8 ;
                    default : 
                        getDatabase = 16 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (base_count)
                    9 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 9 ;
                            1 : 
                                getDatabase = 18 ;
                            2 : 
                                getDatabase = 36 ;
                            default : 
                                getDatabase = 72 ;
                            endcase 
                        end
                    8 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 1 ;
                            1 : 
                                getDatabase = 2 ;
                            2 : 
                                getDatabase = 4 ;
                            3 : 
                                getDatabase = 8 ;
                            4 : 
                                getDatabase = 16 ;
                            5 : 
                                getDatabase = 32 ;
                            default : 
                                getDatabase = 64 ;
                            endcase 
                        end
                    default : 
                        getDatabase = 16 ;
                    endcase 
                end
            default : 
                getDatabase = 8 ;
            endcase 
        end
    endfunction
    function [31:0] getDatabase_wBen ; 
        input [31:0] base_count ; 
        input [31:0] index ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (base_count)
                    9 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase_wBen = 9 ;
                            1 : 
                                getDatabase_wBen = 18 ;
                            default : 
                                getDatabase_wBen = 36 ;
                            endcase 
                        end
                    8 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase_wBen = 8 ;
                            1 : 
                                getDatabase_wBen = 16 ;
                            default : 
                                getDatabase_wBen = 32 ;
                            endcase 
                        end
                    default : 
                        getDatabase_wBen = 16 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (base_count)
                    9 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase_wBen = 9 ;
                            1 : 
                                getDatabase_wBen = 18 ;
                            2 : 
                                getDatabase_wBen = 36 ;
                            default : 
                                getDatabase_wBen = 72 ;
                            endcase 
                        end
                    8 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase_wBen = 8 ;
                            1 : 
                                getDatabase_wBen = 16 ;
                            2 : 
                                getDatabase_wBen = 32 ;
                            default : 
                                getDatabase_wBen = 64 ;
                            endcase 
                        end
                    default : 
                        getDatabase_wBen = 16 ;
                    endcase 
                end
            default : 
                getDatabase_wBen = 8 ;
            endcase 
        end
    endfunction
    function [31:0] data_to_addr ; 
        input [31:0] data_size ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (data_size)
                    36 : 
                        data_to_addr = 512 ;
                    32 : 
                        data_to_addr = 512 ;
                    18 : 
                        data_to_addr = 1024 ;
                    16 : 
                        data_to_addr = 1024 ;
                    9 : 
                        data_to_addr = 2048 ;
                    8 : 
                        data_to_addr = 2048 ;
                    4 : 
                        data_to_addr = 4096 ;
                    2 : 
                        data_to_addr = 8192 ;
                    default : 
                        data_to_addr = 16384 ;
                    endcase 
                end
            _FCODE_ICE_ : 
                begin
                    case (data_size)
                    16 : 
                        data_to_addr = 256 ;
                    8 : 
                        data_to_addr = 512 ;
                    4 : 
                        data_to_addr = 1024 ;
                    2 : 
                        data_to_addr = 2048 ;
                    default : 
                        data_to_addr = 4096 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (data_size)
                    72 : 
                        data_to_addr = 512 ;
                    64 : 
                        data_to_addr = 512 ;
                    36 : 
                        data_to_addr = 1024 ;
                    32 : 
                        data_to_addr = 1024 ;
                    18 : 
                        data_to_addr = 2048 ;
                    16 : 
                        data_to_addr = 2048 ;
                    9 : 
                        data_to_addr = 4096 ;
                    8 : 
                        data_to_addr = 4096 ;
                    4 : 
                        data_to_addr = 8192 ;
                    2 : 
                        data_to_addr = 16384 ;
                    default : 
                        data_to_addr = 32768 ;
                    endcase 
                end
            default : 
                data_to_addr = 1024 ;
            endcase 
        end
    endfunction
    function [31:0] addr_to_data ; 
        input [31:0] addr_size ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (addr_size)
                    512 : 
                        addr_to_data = 36 ;
                    1024 : 
                        addr_to_data = 18 ;
                    2048 : 
                        addr_to_data = 9 ;
                    4096 : 
                        addr_to_data = 4 ;
                    8192 : 
                        addr_to_data = 2 ;
                    default : 
                        addr_to_data = 1 ;
                    endcase 
                end
            _FCODE_ICE_ : 
                begin
                    case (addr_size)
                    256 : 
                        addr_to_data = 16 ;
                    512 : 
                        addr_to_data = 8 ;
                    1024 : 
                        addr_to_data = 4 ;
                    2048 : 
                        addr_to_data = 2 ;
                    default : 
                        addr_to_data = 1 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (addr_size)
                    512 : 
                        addr_to_data = 72 ;
                    1024 : 
                        addr_to_data = 36 ;
                    2048 : 
                        addr_to_data = 18 ;
                    4096 : 
                        addr_to_data = 9 ;
                    8192 : 
                        addr_to_data = 4 ;
                    16384 : 
                        addr_to_data = 2 ;
                    default : 
                        addr_to_data = 1 ;
                    endcase 
                end
            default : 
                addr_to_data = 1024 ;
            endcase 
        end
    endfunction
    function [31:0] getMinimaData ; 
        input [31:0] depth_impl ; 
        input [31:0] width_impl ; 
        input is_byte_enable ; 
        input [31:0] byte_size ; 
        input is_ecc ; 
        input [31:0] family_code ; 
        reg [31:0] temp_00, 
            temp_01, 
            temp_02, 
            temp_03, 
            temp_04, 
            temp_05, 
            temp_06 ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    if (is_ecc) 
                        begin
                            getMinimaData = 32 ;
                        end
                    else
                        begin
                            temp_00 = EBR_impl(depth_impl,
                                    width_impl,
                                    512,
                                    36) ;
                            temp_01 = EBR_impl(depth_impl,
                                    width_impl,
                                    1024,
                                    18) ;
                            temp_02 = EBR_impl(depth_impl,
                                    width_impl,
                                    2048,
                                    9) ;
                            temp_03 = EBR_impl(depth_impl,
                                    width_impl,
                                    4096,
                                    4) ;
                            temp_04 = EBR_impl(depth_impl,
                                    width_impl,
                                    8192,
                                    2) ;
                            temp_05 = EBR_impl(depth_impl,
                                    width_impl,
                                    16384,
                                    1) ;
                            if (((is_byte_enable == 1) && ((width_impl % 9) != 0))) 
                                begin
                                    temp_00 = EBR_impl(depth_impl,
                                            width_impl,
                                            512,
                                            32) ;
                                    temp_01 = EBR_impl(depth_impl,
                                            width_impl,
                                            1024,
                                            16) ;
                                    temp_02 = EBR_impl(depth_impl,
                                            width_impl,
                                            2048,
                                            8) ;
                                    if ((((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03)) && (temp_00 < temp_04)) && (temp_00 < temp_05))) 
                                        getMinimaData = 32 ;
                                    else
                                        if (((((temp_01 < temp_02) && (temp_01 < temp_03)) && (temp_01 < temp_04)) && (temp_01 < temp_05))) 
                                            getMinimaData = 16 ;
                                        else
                                            if ((((temp_02 < temp_03) && (temp_02 < temp_04)) && (temp_02 < temp_05))) 
                                                getMinimaData = 8 ;
                                            else
                                                if (((temp_03 < temp_04) && (temp_03 < temp_05))) 
                                                    getMinimaData = 4 ;
                                                else
                                                    if ((temp_04 < temp_05)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                end
                            else
                                begin
                                    if ((((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03)) && (temp_00 < temp_04)) && (temp_00 < temp_05))) 
                                        getMinimaData = 36 ;
                                    else
                                        if (((((temp_01 < temp_02) && (temp_01 < temp_03)) && (temp_01 < temp_04)) && (temp_01 < temp_05))) 
                                            getMinimaData = 18 ;
                                        else
                                            if ((((temp_02 < temp_03) && (temp_02 < temp_04)) && (temp_02 < temp_05))) 
                                                getMinimaData = 9 ;
                                            else
                                                if (((temp_03 < temp_04) && (temp_03 < temp_05))) 
                                                    getMinimaData = 4 ;
                                                else
                                                    if ((temp_04 < temp_05)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                end
                        end
                end
            _FCODE_ICE_ : 
                begin
                    temp_00 = EBR_impl(depth_impl,
                            width_impl,
                            256,
                            16) ;
                    temp_01 = EBR_impl(depth_impl,
                            width_impl,
                            512,
                            8) ;
                    temp_02 = EBR_impl(depth_impl,
                            width_impl,
                            1024,
                            4) ;
                    temp_03 = EBR_impl(depth_impl,
                            width_impl,
                            2048,
                            2) ;
                    if ((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03))) 
                        getMinimaData = 16 ;
                    else
                        if (((temp_01 < temp_02) && (temp_01 < temp_03))) 
                            getMinimaData = 8 ;
                        else
                            if ((temp_02 < temp_03)) 
                                getMinimaData = 4 ;
                            else
                                getMinimaData = 2 ;
                end
            _FCODE_AP6_ : 
                begin
                    if (is_ecc) 
                        begin
                            getMinimaData = 64 ;
                        end
                    else
                        begin
                            temp_00 = EBR_impl(depth_impl,
                                    width_impl,
                                    512,
                                    72) ;
                            temp_01 = EBR_impl(depth_impl,
                                    width_impl,
                                    1024,
                                    36) ;
                            temp_02 = EBR_impl(depth_impl,
                                    width_impl,
                                    2048,
                                    18) ;
                            temp_03 = EBR_impl(depth_impl,
                                    width_impl,
                                    4096,
                                    9) ;
                            temp_04 = EBR_impl(depth_impl,
                                    width_impl,
                                    8192,
                                    4) ;
                            temp_05 = EBR_impl(depth_impl,
                                    width_impl,
                                    16384,
                                    2) ;
                            temp_06 = EBR_impl(depth_impl,
                                    width_impl,
                                    32768,
                                    1) ;
                            if (((is_byte_enable == 1) && ((width_impl % 9) != 0))) 
                                begin
                                    temp_00 = EBR_impl(depth_impl,
                                            width_impl,
                                            512,
                                            64) ;
                                    temp_01 = EBR_impl(depth_impl,
                                            width_impl,
                                            1024,
                                            32) ;
                                    temp_02 = EBR_impl(depth_impl,
                                            width_impl,
                                            2048,
                                            16) ;
                                    temp_03 = EBR_impl(depth_impl,
                                            width_impl,
                                            4096,
                                            8) ;
                                    if (((((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03)) && (temp_00 < temp_04)) && (temp_00 < temp_05)) && (temp_00 < temp_06))) 
                                        getMinimaData = 64 ;
                                    else
                                        if ((((((temp_01 < temp_02) && (temp_01 < temp_03)) && (temp_01 < temp_04)) && (temp_01 < temp_05)) && (temp_01 < temp_06))) 
                                            getMinimaData = 32 ;
                                        else
                                            if (((((temp_02 < temp_03) && (temp_02 < temp_04)) && (temp_02 < temp_05)) && (temp_02 < temp_06))) 
                                                getMinimaData = 16 ;
                                            else
                                                if ((((temp_03 < temp_04) && (temp_03 < temp_05)) && (temp_03 < temp_06))) 
                                                    getMinimaData = 8 ;
                                                else
                                                    if (((temp_04 < temp_05) && (temp_04 < temp_06))) 
                                                        getMinimaData = 4 ;
                                                    else
                                                        if ((temp_05 < temp_06)) 
                                                            getMinimaData = 2 ;
                                                        else
                                                            getMinimaData = 1 ;
                                end
                            else
                                begin
                                    if (((((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03)) && (temp_00 < temp_04)) && (temp_00 < temp_05)) && (temp_00 < temp_06))) 
                                        getMinimaData = 72 ;
                                    else
                                        if ((((((temp_01 < temp_02) && (temp_01 < temp_03)) && (temp_01 < temp_04)) && (temp_01 < temp_05)) && (temp_01 < temp_06))) 
                                            getMinimaData = 36 ;
                                        else
                                            if (((((temp_02 < temp_03) && (temp_02 < temp_04)) && (temp_02 < temp_05)) && (temp_02 < temp_06))) 
                                                getMinimaData = 18 ;
                                            else
                                                if ((((temp_03 < temp_04) && (temp_03 < temp_05)) && (temp_03 < temp_06))) 
                                                    getMinimaData = 9 ;
                                                else
                                                    if (((temp_04 < temp_05) && (temp_04 < temp_06))) 
                                                        getMinimaData = 4 ;
                                                    else
                                                        if ((temp_05 < temp_06)) 
                                                            getMinimaData = 2 ;
                                                        else
                                                            getMinimaData = 1 ;
                                end
                        end
                end
            default : 
                getMinimaData = 8 ;
            endcase 
        end
    endfunction
    function [31:0] getByteSize ; 
        input [31:0] data_width ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                begin
                    if (((data_width % 9) == 0)) 
                        getByteSize = 9 ;
                    else
                        getByteSize = 8 ;
                end
            _FCODE_ICE_ : 
                getByteSize = 8 ;
            _FCODE_AP6_ : 
                begin
                    if (((data_width % 9) == 0)) 
                        getByteSize = 9 ;
                    else
                        getByteSize = 8 ;
                end
            default : 
                getByteSize = 8 ;
            endcase 
        end
    endfunction
    function is_byte_enable_good ; 
        input [31:0] max_data ; 
        input [31:0] min_data ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_ICE_ : 
                is_byte_enable_good = ((((max_data / min_data) == 2) && ((max_data % 16) == 0)) ? 1'b1 : 1'b0) ;
            _FCODE_LIFCL_ : 
                begin
                    if (((max_data / min_data) == 4)) 
                        is_byte_enable_good = ((((max_data % 36) == 0) || ((max_data % 32) == 0)) ? 1'b1 : 1'b0) ;
                    else
                        if (((max_data / min_data) == 2)) 
                            is_byte_enable_good = ((((max_data % 16) == 0) || ((max_data % 18) == 0)) ? 1'b1 : 1'b0) ;
                        else
                            is_byte_enable_good = 1'b0 ;
                end
            _FCODE_AP6_ : 
                begin
                    if (((max_data / min_data) == 8)) 
                        is_byte_enable_good = ((((max_data % 72) == 0) || ((max_data % 64) == 0)) ? 1'b1 : 1'b0) ;
                    else
                        if (((max_data / min_data) == 4)) 
                            is_byte_enable_good = ((((max_data % 36) == 0) || ((max_data % 32) == 0)) ? 1'b1 : 1'b0) ;
                        else
                            if (((max_data / min_data) == 2)) 
                                is_byte_enable_good = ((((max_data % 16) == 0) || ((max_data % 18) == 0)) ? 1'b1 : 1'b0) ;
                            else
                                is_byte_enable_good = 1'b0 ;
                end
            default : 
                is_byte_enable_good = 1'b0 ;
            endcase 
        end
    endfunction
    function [31:0] EBR_impl ; 
        input [31:0] DEPTH_IMPL ; 
        input [31:0] WIDTH_IMPL ; 
        input [31:0] ADDR_DEPTH_X ; 
        input [31:0] DATA_WIDTH_X ; 
        begin
            EBR_impl = (roundUP(DEPTH_IMPL,
                    ADDR_DEPTH_X) * roundUP(WIDTH_IMPL,
                    DATA_WIDTH_X)) ;
        end
    endfunction
    function [31:0] roundUP ; 
        input [31:0] dividend ; 
        input [31:0] divisor ; 
        begin
            if ((divisor == 1)) 
                begin
                    roundUP = dividend ;
                end
            else
                if ((divisor == dividend)) 
                    begin
                        roundUP = 1 ;
                    end
                else
                    begin
                        roundUP = ((dividend / divisor) + (((dividend % divisor) == 0) ? 0 : 1)) ;
                    end
        end
    endfunction
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



//=============================================================================
// lscc_fifo_mem.v
// Local Variables:
// verilog-library-directories: ("../../common")
// End:
//=============================================================================
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED 
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement. 
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02 
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS         
// Project               : Radiant Software 1.1
// File                  : lscc_fifo_mem_core.v
// Title                 : 
// Dependencies          : 
// Description           : Implements a single pseudo dual port memory instance.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             : 
// Mod. Date             : 
// Changes Made          : Initial release.
// =============================================================================
module FIFO_A2B_ipgen_lscc_fifo_mem_core #(parameter _FCODE_LIFCL_ = 1, 
        parameter _FCODE_ICE_ = 2, 
        parameter _FCODE_AP6_ = 3, 
        parameter _FCODE_COMMON_ = 0, 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "[18,1024]", 
        parameter FAMILY = "common", 
        parameter FAMILY_CODE = ((FAMILY == "LIFCL") ? _FCODE_LIFCL_ : ((FAMILY == "iCE40UP") ? _FCODE_ICE_ : ((FAMILY == "LATG1") ? _FCODE_AP6_ : ((FAMILY == "LAV-AT") ? _FCODE_AP6_ : _FCODE_COMMON_)))), 
        parameter DATA_WIDTH_W = 36, 
        parameter ADDR_WIDTH_W = getAddrWidth(DATA_WIDTH_W,
                FAMILY_CODE), 
        parameter DATA_WIDTH_R = 36, 
        parameter ADDR_WIDTH_R = getAddrWidth(DATA_WIDTH_R,
                FAMILY_CODE), 
        parameter REGMODE = "reg", 
        parameter GSR = "enabled", 
        parameter RESETMODE = "sync", 
        parameter RESET_RELEASE = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE = 0, 
        parameter BYTE_WIDTH = ((BYTE_ENABLE == 1) ? getByteWidth(DATA_WIDTH_W,
                FAMILY_CODE) : 1), 
        parameter ECC_ENABLE = 0, 
        parameter CSDECODE_W = 0, 
        parameter CSDECODE_R = 0, 
        parameter OPTIMIZATION = "speed", 
        parameter OUTPUT_CLK_EN = 0, 
        parameter BYTE_ENABLE_POL = "active-high", 
        parameter POSx = 0, 
        parameter POSy = 0, 
        parameter STRING_SIZE = calculateStringSize(POSx,
                POSy), 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_40 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_41 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_42 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_43 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_44 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_45 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_46 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_47 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_48 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_49 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_50 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_51 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_52 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_53 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_54 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_55 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_56 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_57 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_58 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_59 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_60 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_61 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_62 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_63 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_64 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_65 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_66 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_67 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_68 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_69 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_70 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_71 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_72 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_73 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_74 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_75 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_76 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_77 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_78 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_79 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7F = "0x0000000000000000000000000000000000000000000000000000000000000000") (
    //unused
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input rst_i, 
    input wr_clk_en_i, 
    input rd_clk_en_i, 
    input rd_out_clk_en_i, 
    input wr_en_i, 
    input [(DATA_WIDTH_W - 1):0] wr_data_i, 
    input [(ADDR_WIDTH_W - 1):0] wr_addr_i, 
    input rd_en_i, 
    input [(ADDR_WIDTH_R - 1):0] rd_addr_i, 
    input [(BYTE_WIDTH - 1):0] ben_i, 
    output [(DATA_WIDTH_R - 1):0] rd_data_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    // -----------------------------------------------------------------------------
    // Local Parameters
    // -----------------------------------------------------------------------------
    localparam POS_X0 = (POSx % 10) ; 
    localparam POS_X1 = ((POSx / 10) % 10) ; 
    localparam POS_X2 = ((POSx / 100) % 10) ; 
    localparam POS_X3 = ((POSx / 1000) % 10) ; 
    localparam POS_X4 = ((POSx / 10000) % 10) ; 
    localparam POS_X5 = ((POSx / 100000) % 10) ; 
    localparam POS_X6 = ((POSx / 1000000) % 10) ; 
    localparam POS_X7 = ((POSx / 10000000) % 10) ; 
    localparam POS_Y0 = (POSy % 10) ; 
    localparam POS_Y1 = ((POSy / 10) % 10) ; 
    localparam POS_Y2 = ((POSy / 100) % 10) ; 
    localparam POS_Y3 = ((POSy / 1000) % 10) ; 
    localparam POS_Y4 = ((POSy / 10000) % 10) ; 
    localparam POS_Y5 = ((POSy / 100000) % 10) ; 
    localparam POS_Y6 = ((POSy / 1000000) % 10) ; 
    localparam POS_Y7 = ((POSy / 10000000) % 10) ; 
    localparam [79:0] NUM_STRING = "9876543210" ; 
    localparam BLOCK_POS = getStringFromPos(POSx,
                POSy) ; 
    localparam BLOCK_SIZE = ((DATA_WIDTH_W == 72) ? "[72,512]" : ((DATA_WIDTH_W == 64) ? "[64,512]" : ((DATA_WIDTH_W == 36) ? (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? "[36,1024]" : "[36,512]") : ((DATA_WIDTH_W == 32) ? (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? "[32,1024]" : "[32,512]") : ((DATA_WIDTH_W == 18) ? (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? "[18,2048]" : "[18,1024]") : ((DATA_WIDTH_W == 16) ? (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? "[16,2048]" : "[16,1024]") : ((DATA_WIDTH_W == 9) ? (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? "[9,4096]" : "[9,2048]") : ((DATA_WIDTH_W == 8) ? (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? "[8,4096]" : "[8,2048]") : ((DATA_WIDTH_W == 4) ? (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? "[4,8192]" : "[4,4096]") : ((DATA_WIDTH_W == 2) ? (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? "[2,16384]" : "[2,8192]") : (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? "[1,32768]" : "[1,16384]"))))))))))) ; 
    // -----------------------------------------------------------------------------
    // Generate Sequential Blocks
    // -----------------------------------------------------------------------------
    genvar i0 ; 
    generate
        if ((FAMILY_CODE == _FCODE_ICE_)) 
            begin : ICE_MEM
                wire [10:0] raddr_w ; 
                wire [10:0] waddr_w ; 
                wire [15:0] wdata_w ; 
                wire [15:0] rdata_w ; 
                wire [15:0] mask_w ; 
                wire [15:0] mask_t_w ; 
                wire [(DATA_WIDTH_R - 1):0] rd_data_w ; 
                for (i0 = 0;(i0 < 16);i0 = (i0 + 1))
                begin : genblk1
                    if ((i0 < 8)) 
                        begin: genblk1
                            assign mask_w[i0] = ((BYTE_ENABLE == 0) ? 1'b0 : ((DATA_WIDTH_W == 16) ? (~ben_i[0]) : 1'b0)) ; 
                        end
                    else
                        begin: genblk1
                            assign mask_w[i0] = ((BYTE_ENABLE == 0) ? 1'b0 : ((DATA_WIDTH_W == 16) ? (~ben_i[1]) : 1'b0)) ; 
                        end
                end
                if ((DATA_WIDTH_R == 16)) 
                    begin : genblk2
                        assign mask_t_w = mask_w ; 
                    end
                else
                    if ((DATA_WIDTH_R == 8)) 
                        begin : genblk2
                            assign mask_t_w[0] = mask_w[0] ; 
                            assign mask_t_w[2] = mask_w[1] ; 
                            assign mask_t_w[4] = mask_w[2] ; 
                            assign mask_t_w[6] = mask_w[3] ; 
                            assign mask_t_w[8] = mask_w[4] ; 
                            assign mask_t_w[10] = mask_w[5] ; 
                            assign mask_t_w[12] = mask_w[6] ; 
                            assign mask_t_w[14] = mask_w[7] ; 
                            assign mask_t_w[1] = mask_w[8] ; 
                            assign mask_t_w[3] = mask_w[9] ; 
                            assign mask_t_w[5] = mask_w[10] ; 
                            assign mask_t_w[7] = mask_w[11] ; 
                            assign mask_t_w[9] = mask_w[12] ; 
                            assign mask_t_w[11] = mask_w[13] ; 
                            assign mask_t_w[13] = mask_w[14] ; 
                            assign mask_t_w[15] = mask_w[15] ; 
                        end
                    else
                        if ((DATA_WIDTH_R == 4)) 
                            begin : genblk2
                                assign mask_t_w[0] = mask_w[0] ; 
                                assign mask_t_w[4] = mask_w[1] ; 
                                assign mask_t_w[8] = mask_w[2] ; 
                                assign mask_t_w[12] = mask_w[3] ; 
                                assign mask_t_w[1] = mask_w[4] ; 
                                assign mask_t_w[5] = mask_w[5] ; 
                                assign mask_t_w[9] = mask_w[6] ; 
                                assign mask_t_w[13] = mask_w[7] ; 
                                assign mask_t_w[2] = mask_w[8] ; 
                                assign mask_t_w[6] = mask_w[9] ; 
                                assign mask_t_w[10] = mask_w[10] ; 
                                assign mask_t_w[14] = mask_w[11] ; 
                                assign mask_t_w[3] = mask_w[12] ; 
                                assign mask_t_w[7] = mask_w[13] ; 
                                assign mask_t_w[11] = mask_w[14] ; 
                                assign mask_t_w[15] = mask_w[15] ; 
                            end
                        else
                            begin : genblk2
                                assign mask_t_w[0] = mask_w[0] ; 
                                assign mask_t_w[8] = mask_w[1] ; 
                                assign mask_t_w[1] = mask_w[2] ; 
                                assign mask_t_w[9] = mask_w[3] ; 
                                assign mask_t_w[2] = mask_w[4] ; 
                                assign mask_t_w[10] = mask_w[5] ; 
                                assign mask_t_w[3] = mask_w[6] ; 
                                assign mask_t_w[11] = mask_w[7] ; 
                                assign mask_t_w[4] = mask_w[8] ; 
                                assign mask_t_w[12] = mask_w[9] ; 
                                assign mask_t_w[5] = mask_w[10] ; 
                                assign mask_t_w[13] = mask_w[11] ; 
                                assign mask_t_w[6] = mask_w[12] ; 
                                assign mask_t_w[14] = mask_w[13] ; 
                                assign mask_t_w[7] = mask_w[14] ; 
                                assign mask_t_w[15] = mask_w[15] ; 
                            end
                if ((ADDR_WIDTH_R < 11)) 
                    begin: genblk3
                        assign raddr_w[10:ADDR_WIDTH_R] = {(11 - ADDR_WIDTH_R){1'b0}} ; 
                    end
                if ((ADDR_WIDTH_W < 11)) 
                    begin: genblk4
                        assign waddr_w[10:ADDR_WIDTH_W] = {(11 - ADDR_WIDTH_W){1'b0}} ; 
                    end
                if (((DATA_WIDTH_W == 16) && (DATA_WIDTH_R == 16))) 
                    begin : genblk5
                        assign wdata_w = wr_data_i ; 
                        assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                        assign raddr_w[(ADDR_WIDTH_R - 1):0] = rd_addr_i ; 
                        assign rd_data_w = rdata_w ; 
                    end
                else
                    if (((DATA_WIDTH_W == 16) && (DATA_WIDTH_R == 8))) 
                        begin : genblk5
                            assign wdata_w[0] = wr_data_i[0] ; 
                            assign wdata_w[2] = wr_data_i[1] ; 
                            assign wdata_w[4] = wr_data_i[2] ; 
                            assign wdata_w[6] = wr_data_i[3] ; 
                            assign wdata_w[8] = wr_data_i[4] ; 
                            assign wdata_w[10] = wr_data_i[5] ; 
                            assign wdata_w[12] = wr_data_i[6] ; 
                            assign wdata_w[14] = wr_data_i[7] ; 
                            assign wdata_w[1] = wr_data_i[8] ; 
                            assign wdata_w[3] = wr_data_i[9] ; 
                            assign wdata_w[5] = wr_data_i[10] ; 
                            assign wdata_w[7] = wr_data_i[11] ; 
                            assign wdata_w[9] = wr_data_i[12] ; 
                            assign wdata_w[11] = wr_data_i[13] ; 
                            assign wdata_w[13] = wr_data_i[14] ; 
                            assign wdata_w[15] = wr_data_i[15] ; 
                            assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                            assign raddr_w = {rd_addr_i[0],
                                        rd_addr_i[(ADDR_WIDTH_R - 1):1]} ; 
                            assign rd_data_w[7] = rdata_w[14] ; 
                            assign rd_data_w[6] = rdata_w[12] ; 
                            assign rd_data_w[5] = rdata_w[10] ; 
                            assign rd_data_w[4] = rdata_w[8] ; 
                            assign rd_data_w[3] = rdata_w[6] ; 
                            assign rd_data_w[2] = rdata_w[4] ; 
                            assign rd_data_w[1] = rdata_w[2] ; 
                            assign rd_data_w[0] = rdata_w[0] ; 
                        end
                    else
                        if (((DATA_WIDTH_W == 16) && (DATA_WIDTH_R == 4))) 
                            begin : genblk5
                                assign wdata_w[0] = wr_data_i[0] ; 
                                assign wdata_w[4] = wr_data_i[1] ; 
                                assign wdata_w[8] = wr_data_i[2] ; 
                                assign wdata_w[12] = wr_data_i[3] ; 
                                assign wdata_w[1] = wr_data_i[4] ; 
                                assign wdata_w[5] = wr_data_i[5] ; 
                                assign wdata_w[9] = wr_data_i[6] ; 
                                assign wdata_w[13] = wr_data_i[7] ; 
                                assign wdata_w[2] = wr_data_i[8] ; 
                                assign wdata_w[6] = wr_data_i[9] ; 
                                assign wdata_w[10] = wr_data_i[10] ; 
                                assign wdata_w[14] = wr_data_i[11] ; 
                                assign wdata_w[3] = wr_data_i[12] ; 
                                assign wdata_w[7] = wr_data_i[13] ; 
                                assign wdata_w[11] = wr_data_i[14] ; 
                                assign wdata_w[15] = wr_data_i[15] ; 
                                assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                                assign raddr_w = {rd_addr_i[1:0],
                                            rd_addr_i[(ADDR_WIDTH_R - 1):2]} ; 
                                assign rd_data_w[3] = rdata_w[13] ; 
                                assign rd_data_w[2] = rdata_w[9] ; 
                                assign rd_data_w[1] = rdata_w[5] ; 
                                assign rd_data_w[0] = rdata_w[1] ; 
                            end
                        else
                            if (((DATA_WIDTH_W == 16) && (DATA_WIDTH_R == 2))) 
                                begin : genblk5
                                    assign wdata_w[0] = wr_data_i[0] ; 
                                    assign wdata_w[8] = wr_data_i[1] ; 
                                    assign wdata_w[1] = wr_data_i[2] ; 
                                    assign wdata_w[9] = wr_data_i[3] ; 
                                    assign wdata_w[2] = wr_data_i[4] ; 
                                    assign wdata_w[10] = wr_data_i[5] ; 
                                    assign wdata_w[3] = wr_data_i[6] ; 
                                    assign wdata_w[11] = wr_data_i[7] ; 
                                    assign wdata_w[4] = wr_data_i[8] ; 
                                    assign wdata_w[12] = wr_data_i[9] ; 
                                    assign wdata_w[5] = wr_data_i[10] ; 
                                    assign wdata_w[13] = wr_data_i[11] ; 
                                    assign wdata_w[6] = wr_data_i[12] ; 
                                    assign wdata_w[14] = wr_data_i[13] ; 
                                    assign wdata_w[7] = wr_data_i[14] ; 
                                    assign wdata_w[15] = wr_data_i[15] ; 
                                    assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                                    assign raddr_w = {rd_addr_i[2:0],
                                                rd_addr_i[(ADDR_WIDTH_R - 1):3]} ; 
                                    assign rd_data_w[1] = rdata_w[11] ; 
                                    assign rd_data_w[0] = rdata_w[3] ; 
                                end
                            else
                                if (((DATA_WIDTH_W == 8) && (DATA_WIDTH_R == 16))) 
                                    begin : genblk5
                                        assign wdata_w[0] = wr_data_i[0] ; 
                                        assign wdata_w[2] = wr_data_i[1] ; 
                                        assign wdata_w[4] = wr_data_i[2] ; 
                                        assign wdata_w[6] = wr_data_i[3] ; 
                                        assign wdata_w[8] = wr_data_i[4] ; 
                                        assign wdata_w[10] = wr_data_i[5] ; 
                                        assign wdata_w[12] = wr_data_i[6] ; 
                                        assign wdata_w[14] = wr_data_i[7] ; 
                                        assign wdata_w[1] = 1'b0 ; 
                                        assign wdata_w[3] = 1'b0 ; 
                                        assign wdata_w[5] = 1'b0 ; 
                                        assign wdata_w[7] = 1'b0 ; 
                                        assign wdata_w[9] = 1'b0 ; 
                                        assign wdata_w[11] = 1'b0 ; 
                                        assign wdata_w[13] = 1'b0 ; 
                                        assign wdata_w[15] = 1'b0 ; 
                                        assign waddr_w = {wr_addr_i[0],
                                                    wr_addr_i[(ADDR_WIDTH_W - 1):1]} ; 
                                        assign raddr_w = rd_addr_i ; 
                                        assign rd_data_w[0] = rdata_w[0] ; 
                                        assign rd_data_w[1] = rdata_w[2] ; 
                                        assign rd_data_w[2] = rdata_w[4] ; 
                                        assign rd_data_w[3] = rdata_w[6] ; 
                                        assign rd_data_w[4] = rdata_w[8] ; 
                                        assign rd_data_w[5] = rdata_w[10] ; 
                                        assign rd_data_w[6] = rdata_w[12] ; 
                                        assign rd_data_w[7] = rdata_w[14] ; 
                                        assign rd_data_w[8] = rdata_w[1] ; 
                                        assign rd_data_w[9] = rdata_w[3] ; 
                                        assign rd_data_w[10] = rdata_w[5] ; 
                                        assign rd_data_w[11] = rdata_w[7] ; 
                                        assign rd_data_w[12] = rdata_w[9] ; 
                                        assign rd_data_w[13] = rdata_w[11] ; 
                                        assign rd_data_w[14] = rdata_w[13] ; 
                                        assign rd_data_w[15] = rdata_w[15] ; 
                                    end
                                else
                                    if (((DATA_WIDTH_W == 8) && (DATA_WIDTH_R == 8))) 
                                        begin : genblk5
                                            assign wdata_w[0] = wr_data_i[0] ; 
                                            assign wdata_w[2] = wr_data_i[1] ; 
                                            assign wdata_w[4] = wr_data_i[2] ; 
                                            assign wdata_w[6] = wr_data_i[3] ; 
                                            assign wdata_w[8] = wr_data_i[4] ; 
                                            assign wdata_w[10] = wr_data_i[5] ; 
                                            assign wdata_w[12] = wr_data_i[6] ; 
                                            assign wdata_w[14] = wr_data_i[7] ; 
                                            assign wdata_w[1] = 1'b0 ; 
                                            assign wdata_w[3] = 1'b0 ; 
                                            assign wdata_w[5] = 1'b0 ; 
                                            assign wdata_w[7] = 1'b0 ; 
                                            assign wdata_w[9] = 1'b0 ; 
                                            assign wdata_w[11] = 1'b0 ; 
                                            assign wdata_w[13] = 1'b0 ; 
                                            assign wdata_w[15] = 1'b0 ; 
                                            assign waddr_w = {wr_addr_i} ; 
                                            assign raddr_w = {rd_addr_i} ; 
                                            assign rd_data_w[0] = rdata_w[0] ; 
                                            assign rd_data_w[1] = rdata_w[2] ; 
                                            assign rd_data_w[2] = rdata_w[4] ; 
                                            assign rd_data_w[3] = rdata_w[6] ; 
                                            assign rd_data_w[4] = rdata_w[8] ; 
                                            assign rd_data_w[5] = rdata_w[10] ; 
                                            assign rd_data_w[6] = rdata_w[12] ; 
                                            assign rd_data_w[7] = rdata_w[14] ; 
                                        end
                                    else
                                        if (((DATA_WIDTH_W == 8) && (DATA_WIDTH_R == 4))) 
                                            begin : genblk5
                                                assign wdata_w[0] = wr_data_i[0] ; 
                                                assign wdata_w[4] = wr_data_i[1] ; 
                                                assign wdata_w[8] = wr_data_i[2] ; 
                                                assign wdata_w[12] = wr_data_i[3] ; 
                                                assign wdata_w[2] = wr_data_i[4] ; 
                                                assign wdata_w[6] = wr_data_i[5] ; 
                                                assign wdata_w[10] = wr_data_i[6] ; 
                                                assign wdata_w[14] = wr_data_i[7] ; 
                                                assign wdata_w[1] = 1'b0 ; 
                                                assign wdata_w[3] = 1'b0 ; 
                                                assign wdata_w[5] = 1'b0 ; 
                                                assign wdata_w[7] = 1'b0 ; 
                                                assign wdata_w[9] = 1'b0 ; 
                                                assign wdata_w[11] = 1'b0 ; 
                                                assign wdata_w[13] = 1'b0 ; 
                                                assign wdata_w[15] = 1'b0 ; 
                                                assign waddr_w = {wr_addr_i} ; 
                                                assign raddr_w = {rd_addr_i[0],
                                                            rd_addr_i[(ADDR_WIDTH_R - 1):1]} ; 
                                                assign rd_data_w[0] = rdata_w[1] ; 
                                                assign rd_data_w[1] = rdata_w[5] ; 
                                                assign rd_data_w[2] = rdata_w[9] ; 
                                                assign rd_data_w[3] = rdata_w[13] ; 
                                            end
                                        else
                                            if (((DATA_WIDTH_W == 8) && (DATA_WIDTH_R == 2))) 
                                                begin : genblk5
                                                    assign wdata_w[0] = wr_data_i[0] ; 
                                                    assign wdata_w[8] = wr_data_i[1] ; 
                                                    assign wdata_w[2] = wr_data_i[2] ; 
                                                    assign wdata_w[10] = wr_data_i[3] ; 
                                                    assign wdata_w[4] = wr_data_i[4] ; 
                                                    assign wdata_w[12] = wr_data_i[5] ; 
                                                    assign wdata_w[6] = wr_data_i[6] ; 
                                                    assign wdata_w[14] = wr_data_i[7] ; 
                                                    assign wdata_w[1] = 1'b0 ; 
                                                    assign wdata_w[3] = 1'b0 ; 
                                                    assign wdata_w[5] = 1'b0 ; 
                                                    assign wdata_w[7] = 1'b0 ; 
                                                    assign wdata_w[9] = 1'b0 ; 
                                                    assign wdata_w[11] = 1'b0 ; 
                                                    assign wdata_w[13] = 1'b0 ; 
                                                    assign wdata_w[15] = 1'b0 ; 
                                                    assign waddr_w = {wr_addr_i} ; 
                                                    assign raddr_w = {rd_addr_i[1:0],
                                                                rd_addr_i[(ADDR_WIDTH_R - 1):2]} ; 
                                                    assign rd_data_w[1] = rdata_w[11] ; 
                                                    assign rd_data_w[0] = rdata_w[3] ; 
                                                end
                                            else
                                                if (((DATA_WIDTH_W == 4) && (DATA_WIDTH_R == 16))) 
                                                    begin : genblk5
                                                        assign wdata_w[1] = wr_data_i[0] ; 
                                                        assign wdata_w[5] = wr_data_i[1] ; 
                                                        assign wdata_w[9] = wr_data_i[2] ; 
                                                        assign wdata_w[13] = wr_data_i[3] ; 
                                                        assign wdata_w[0] = 1'b0 ; 
                                                        assign wdata_w[4:2] = 3'b000 ; 
                                                        assign wdata_w[8:6] = 3'b000 ; 
                                                        assign wdata_w[12:10] = 3'b000 ; 
                                                        assign wdata_w[15:14] = 2'b00 ; 
                                                        assign waddr_w = {wr_addr_i[1:0],
                                                                    wr_addr_i[(ADDR_WIDTH_W - 1):2]} ; 
                                                        assign raddr_w = rd_addr_i ; 
                                                        assign rd_data_w[0] = rdata_w[0] ; 
                                                        assign rd_data_w[1] = rdata_w[4] ; 
                                                        assign rd_data_w[2] = rdata_w[8] ; 
                                                        assign rd_data_w[3] = rdata_w[12] ; 
                                                        assign rd_data_w[4] = rdata_w[1] ; 
                                                        assign rd_data_w[5] = rdata_w[5] ; 
                                                        assign rd_data_w[6] = rdata_w[9] ; 
                                                        assign rd_data_w[7] = rdata_w[13] ; 
                                                        assign rd_data_w[8] = rdata_w[2] ; 
                                                        assign rd_data_w[9] = rdata_w[6] ; 
                                                        assign rd_data_w[10] = rdata_w[10] ; 
                                                        assign rd_data_w[11] = rdata_w[14] ; 
                                                        assign rd_data_w[12] = rdata_w[3] ; 
                                                        assign rd_data_w[13] = rdata_w[7] ; 
                                                        assign rd_data_w[14] = rdata_w[11] ; 
                                                        assign rd_data_w[15] = rdata_w[15] ; 
                                                    end
                                                else
                                                    if (((DATA_WIDTH_W == 4) && (DATA_WIDTH_R == 8))) 
                                                        begin : genblk5
                                                            assign wdata_w[1] = wr_data_i[0] ; 
                                                            assign wdata_w[5] = wr_data_i[1] ; 
                                                            assign wdata_w[9] = wr_data_i[2] ; 
                                                            assign wdata_w[13] = wr_data_i[3] ; 
                                                            assign wdata_w[0] = 1'b0 ; 
                                                            assign wdata_w[4:2] = 3'b000 ; 
                                                            assign wdata_w[8:6] = 3'b000 ; 
                                                            assign wdata_w[12:10] = 3'b000 ; 
                                                            assign wdata_w[15:14] = 2'b00 ; 
                                                            assign waddr_w = {wr_addr_i[0],
                                                                        wr_addr_i[(ADDR_WIDTH_W - 1):1]} ; 
                                                            assign raddr_w = rd_addr_i ; 
                                                            assign rd_data_w[0] = rdata_w[0] ; 
                                                            assign rd_data_w[1] = rdata_w[4] ; 
                                                            assign rd_data_w[2] = rdata_w[8] ; 
                                                            assign rd_data_w[3] = rdata_w[12] ; 
                                                            assign rd_data_w[4] = rdata_w[2] ; 
                                                            assign rd_data_w[5] = rdata_w[6] ; 
                                                            assign rd_data_w[6] = rdata_w[10] ; 
                                                            assign rd_data_w[7] = rdata_w[14] ; 
                                                        end
                                                    else
                                                        if (((DATA_WIDTH_W == 4) && (DATA_WIDTH_R == 4))) 
                                                            begin : genblk5
                                                                assign wdata_w[1] = wr_data_i[0] ; 
                                                                assign wdata_w[5] = wr_data_i[1] ; 
                                                                assign wdata_w[9] = wr_data_i[2] ; 
                                                                assign wdata_w[13] = wr_data_i[3] ; 
                                                                assign wdata_w[0] = 1'b0 ; 
                                                                assign wdata_w[4:2] = 3'b000 ; 
                                                                assign wdata_w[8:6] = 3'b000 ; 
                                                                assign wdata_w[12:10] = 3'b000 ; 
                                                                assign wdata_w[15:14] = 2'b00 ; 
                                                                assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                                                                assign raddr_w[(ADDR_WIDTH_R - 1):0] = rd_addr_i ; 
                                                                assign rd_data_w[0] = rdata_w[1] ; 
                                                                assign rd_data_w[1] = rdata_w[5] ; 
                                                                assign rd_data_w[2] = rdata_w[9] ; 
                                                                assign rd_data_w[3] = rdata_w[13] ; 
                                                            end
                                                        else
                                                            if (((DATA_WIDTH_W == 4) && (DATA_WIDTH_R == 2))) 
                                                                begin : genblk5
                                                                    assign wdata_w[1] = wr_data_i[0] ; 
                                                                    assign wdata_w[9] = wr_data_i[1] ; 
                                                                    assign wdata_w[5] = wr_data_i[2] ; 
                                                                    assign wdata_w[13] = wr_data_i[3] ; 
                                                                    assign wdata_w[0] = 1'b0 ; 
                                                                    assign wdata_w[4:2] = 3'b000 ; 
                                                                    assign wdata_w[8:6] = 3'b000 ; 
                                                                    assign wdata_w[12:10] = 3'b000 ; 
                                                                    assign wdata_w[15:14] = 2'b00 ; 
                                                                    assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                                                                    assign raddr_w = {rd_addr_i[0],
                                                                                rd_addr_i[(ADDR_WIDTH_R - 1):1]} ; 
                                                                    assign rd_data_w[1] = rdata_w[11] ; 
                                                                    assign rd_data_w[0] = rdata_w[3] ; 
                                                                end
                                                            else
                                                                if (((DATA_WIDTH_W == 2) && (DATA_WIDTH_R == 16))) 
                                                                    begin : genblk5
                                                                        assign wdata_w[11] = wr_data_i[1] ; 
                                                                        assign wdata_w[3] = wr_data_i[0] ; 
                                                                        assign wdata_w[2:0] = 3'b000 ; 
                                                                        assign wdata_w[10:4] = 7'h00 ; 
                                                                        assign wdata_w[15:12] = 4'h0 ; 
                                                                        assign waddr_w = {wr_addr_i[2:0],
                                                                                wr_addr_i[(ADDR_WIDTH_W - 1):3]} ; 
                                                                        assign raddr_w = rd_addr_i ; 
                                                                        assign rd_data_w[0] = rdata_w[0] ; 
                                                                        assign rd_data_w[1] = rdata_w[8] ; 
                                                                        assign rd_data_w[2] = rdata_w[1] ; 
                                                                        assign rd_data_w[3] = rdata_w[9] ; 
                                                                        assign rd_data_w[4] = rdata_w[2] ; 
                                                                        assign rd_data_w[5] = rdata_w[10] ; 
                                                                        assign rd_data_w[6] = rdata_w[3] ; 
                                                                        assign rd_data_w[7] = rdata_w[11] ; 
                                                                        assign rd_data_w[8] = rdata_w[4] ; 
                                                                        assign rd_data_w[9] = rdata_w[12] ; 
                                                                        assign rd_data_w[10] = rdata_w[5] ; 
                                                                        assign rd_data_w[11] = rdata_w[13] ; 
                                                                        assign rd_data_w[12] = rdata_w[6] ; 
                                                                        assign rd_data_w[13] = rdata_w[14] ; 
                                                                        assign rd_data_w[14] = rdata_w[7] ; 
                                                                        assign rd_data_w[15] = rdata_w[15] ; 
                                                                    end
                                                                else
                                                                    if (((DATA_WIDTH_W == 2) && (DATA_WIDTH_R == 8))) 
                                                                        begin : genblk5
                                                                            assign wdata_w[11] = wr_data_i[1] ; 
                                                                            assign wdata_w[3] = wr_data_i[0] ; 
                                                                            assign wdata_w[2:0] = 3'b000 ; 
                                                                            assign wdata_w[10:4] = 7'h00 ; 
                                                                            assign wdata_w[15:12] = 4'h0 ; 
                                                                            assign waddr_w = {wr_addr_i[1:0],
                                                                                wr_addr_i[(ADDR_WIDTH_W - 1):2]} ; 
                                                                            assign raddr_w = rd_addr_i ; 
                                                                            assign rd_data_w[0] = rdata_w[0] ; 
                                                                            assign rd_data_w[1] = rdata_w[8] ; 
                                                                            assign rd_data_w[2] = rdata_w[2] ; 
                                                                            assign rd_data_w[3] = rdata_w[10] ; 
                                                                            assign rd_data_w[4] = rdata_w[4] ; 
                                                                            assign rd_data_w[5] = rdata_w[12] ; 
                                                                            assign rd_data_w[6] = rdata_w[6] ; 
                                                                            assign rd_data_w[7] = rdata_w[14] ; 
                                                                        end
                                                                    else
                                                                        if (((DATA_WIDTH_W == 2) && (DATA_WIDTH_R == 4))) 
                                                                            begin : genblk5
                                                                                assign wdata_w[11] = wr_data_i[1] ; 
                                                                                assign wdata_w[3] = wr_data_i[0] ; 
                                                                                assign wdata_w[2:0] = 3'b000 ; 
                                                                                assign wdata_w[10:4] = 7'h00 ; 
                                                                                assign wdata_w[15:12] = 4'h0 ; 
                                                                                assign waddr_w = {wr_addr_i[0],
                                                                                wr_addr_i[(ADDR_WIDTH_W - 1):1]} ; 
                                                                                assign raddr_w = rd_addr_i ; 
                                                                                assign rd_data_w[0] = rdata_w[1] ; 
                                                                                assign rd_data_w[1] = rdata_w[9] ; 
                                                                                assign rd_data_w[2] = rdata_w[5] ; 
                                                                                assign rd_data_w[3] = rdata_w[13] ; 
                                                                            end
                                                                        else
                                                                            begin : genblk5
                                                                                assign wdata_w[11] = wr_data_i[1] ; 
                                                                                assign wdata_w[3] = wr_data_i[0] ; 
                                                                                assign wdata_w[2:0] = 3'b000 ; 
                                                                                assign wdata_w[10:4] = 7'h00 ; 
                                                                                assign wdata_w[15:12] = 4'h0 ; 
                                                                                assign waddr_w = wr_addr_i ; 
                                                                                assign raddr_w = rd_addr_i ; 
                                                                                assign rd_data_w[0] = rdata_w[3] ; 
                                                                                assign rd_data_w[1] = rdata_w[11] ; 
                                                                            end
                wire t_wr_en_i = ((BYTE_ENABLE == 0) ? wr_en_i : ((BYTE_WIDTH > 1) ? wr_en_i : (wr_en_i & ben_i))) ; 
                PDP4K u_mem0 (.ADR(raddr_w), 
                            .ADW(waddr_w), 
                            .DI(wdata_w), 
                            .MASK_N(mask_t_w), 
                            .CER(rd_clk_en_i), 
                            .CKR(rd_clk_i), 
                            .RE(rd_en_i), 
                            .CEW(wr_clk_en_i), 
                            .CKW(wr_clk_i), 
                            .WE(t_wr_en_i), 
                            .DO(rdata_w)) ; 
                localparam R = ((DATA_WIDTH_R == 16) ? "16" : ((DATA_WIDTH_R == 8) ? "8" : ((DATA_WIDTH_R == 4) ? "4" : "2"))) ; 
                localparam W = ((DATA_WIDTH_W == 16) ? "16" : ((DATA_WIDTH_W == 8) ? "8" : ((DATA_WIDTH_W == 4) ? "4" : "2"))) ; 
                localparam X_T0 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T1 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T2 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T3 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T4 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T5 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T6 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T7 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T8 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T9 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TA = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TB = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TC = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TD = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TE = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TF = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X0 = ((INIT_MODE == "mem_file") ? INIT_VALUE_00 : X_T0) ; 
                localparam X1 = ((INIT_MODE == "mem_file") ? INIT_VALUE_01 : X_T1) ; 
                localparam X2 = ((INIT_MODE == "mem_file") ? INIT_VALUE_02 : X_T2) ; 
                localparam X3 = ((INIT_MODE == "mem_file") ? INIT_VALUE_03 : X_T3) ; 
                localparam X4 = ((INIT_MODE == "mem_file") ? INIT_VALUE_04 : X_T4) ; 
                localparam X5 = ((INIT_MODE == "mem_file") ? INIT_VALUE_05 : X_T5) ; 
                localparam X6 = ((INIT_MODE == "mem_file") ? INIT_VALUE_06 : X_T6) ; 
                localparam X7 = ((INIT_MODE == "mem_file") ? INIT_VALUE_07 : X_T7) ; 
                localparam X8 = ((INIT_MODE == "mem_file") ? INIT_VALUE_08 : X_T8) ; 
                localparam X9 = ((INIT_MODE == "mem_file") ? INIT_VALUE_09 : X_T9) ; 
                localparam XA = ((INIT_MODE == "mem_file") ? INIT_VALUE_0A : X_TA) ; 
                localparam XB = ((INIT_MODE == "mem_file") ? INIT_VALUE_0B : X_TB) ; 
                localparam XC = ((INIT_MODE == "mem_file") ? INIT_VALUE_0C : X_TC) ; 
                localparam XD = ((INIT_MODE == "mem_file") ? INIT_VALUE_0D : X_TD) ; 
                localparam XE = ((INIT_MODE == "mem_file") ? INIT_VALUE_0E : X_TE) ; 
                localparam XF = ((INIT_MODE == "mem_file") ? INIT_VALUE_0F : X_TF) ; 
                defparam u_mem0.DATA_WIDTH_W = W ; 
                defparam u_mem0.DATA_WIDTH_R = R ; 
                defparam u_mem0.INITVAL_0 = X0 ; 
                defparam u_mem0.INITVAL_1 = X1 ; 
                defparam u_mem0.INITVAL_2 = X2 ; 
                defparam u_mem0.INITVAL_3 = X3 ; 
                defparam u_mem0.INITVAL_4 = X4 ; 
                defparam u_mem0.INITVAL_5 = X5 ; 
                defparam u_mem0.INITVAL_6 = X6 ; 
                defparam u_mem0.INITVAL_7 = X7 ; 
                defparam u_mem0.INITVAL_8 = X8 ; 
                defparam u_mem0.INITVAL_9 = X9 ; 
                defparam u_mem0.INITVAL_A = XA ; 
                defparam u_mem0.INITVAL_B = XB ; 
                defparam u_mem0.INITVAL_C = XC ; 
                defparam u_mem0.INITVAL_D = XD ; 
                defparam u_mem0.INITVAL_E = XE ; 
                defparam u_mem0.INITVAL_F = XF ; 
                if ((REGMODE == "reg")) 
                    begin : genblk6
                        reg [(DATA_WIDTH_R - 1):0] rd_buff_r ; 
                        assign rd_data_o = rd_buff_r ; 
                        if ((RESETMODE == "sync")) 
                            begin : genblk1
                                always
                                    @(posedge rd_clk_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            begin
                                                rd_buff_r <=  {DATA_WIDTH_R{1'b0}} ;
                                            end
                                        else
                                            begin
                                                if ((rd_out_clk_en_i == 1'b1)) 
                                                    begin
                                                        rd_buff_r <=  rd_data_w ;
                                                    end
                                            end
                                    end
                            end
                        else
                            if ((RESET_RELEASE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge rd_clk_i or 
                                            posedge rst_i)
                                        begin
                                            if ((rst_i == 1'b1)) 
                                                begin
                                                    rd_buff_r <=  {DATA_WIDTH_R{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    if ((rd_out_clk_en_i == 1'b1)) 
                                                        begin
                                                            rd_buff_r <=  rd_data_w ;
                                                        end
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(*)
                                        begin
                                            if ((rst_i == 1'b1)) 
                                                begin
                                                    rd_buff_r = {DATA_WIDTH_R{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    if ((rd_out_clk_en_i == 1'b1)) 
                                                        begin
                                                            rd_buff_r = rd_data_w ;
                                                        end
                                                end
                                        end
                                end
                    end
                else
                    begin : genblk6
                        assign rd_data_o = rd_data_w ; 
                    end
            end
        else
            if ((FAMILY_CODE == _FCODE_LIFCL_)) 
                begin : LIFCL_MEM
                    localparam OUTREG = ((REGMODE == "reg") ? ((OUTPUT_CLK_EN == 0) ? "USED" : "BYPASSED") : "BYPASSED") ; 
                    localparam TRUE_CSW = ((CSDECODE_W == 0) ? "000" : ((CSDECODE_W == 1) ? "001" : ((CSDECODE_W == 2) ? "010" : ((CSDECODE_W == 3) ? "011" : ((CSDECODE_W == 4) ? "100" : ((CSDECODE_W == 5) ? "101" : ((CSDECODE_W == 6) ? "110" : "111"))))))) ; 
                    localparam TRUE_CSR = ((CSDECODE_R == 0) ? "000" : ((CSDECODE_R == 1) ? "001" : ((CSDECODE_R == 2) ? "010" : ((CSDECODE_R == 3) ? "011" : ((CSDECODE_R == 4) ? "100" : ((CSDECODE_R == 5) ? "101" : ((CSDECODE_R == 6) ? "110" : "111"))))))) ; 
                    localparam DW_W = (ECC_ENABLE ? "X32" : (((DATA_WIDTH_W == 36) || (DATA_WIDTH_W == 32)) ? "X36" : (((DATA_WIDTH_W == 18) || (DATA_WIDTH_W == 16)) ? "X18" : (((DATA_WIDTH_W == 9) || (DATA_WIDTH_W == 8)) ? "X9" : ((DATA_WIDTH_W == 4) ? "X4" : ((DATA_WIDTH_W == 2) ? "X2" : "X1")))))) ; 
                    localparam DW_R = (ECC_ENABLE ? "X32" : (((DATA_WIDTH_R == 36) || (DATA_WIDTH_R == 32)) ? "X36" : (((DATA_WIDTH_R == 18) || (DATA_WIDTH_R == 16)) ? "X18" : (((DATA_WIDTH_R == 9) || (DATA_WIDTH_R == 8)) ? "X9" : ((DATA_WIDTH_R == 4) ? "X4" : ((DATA_WIDTH_R == 2) ? "X2" : "X1")))))) ; 
                    localparam TRUE_RST = ((RESETMODE == "sync") ? "SYNC" : "ASYNC") ; 
                    localparam TRUE_RST_REL = ((RESET_RELEASE == "sync") ? "SYNC" : "ASYNC") ; 
                    localparam TRUE_ECC = (((ECC_ENABLE == 1) && (DATA_WIDTH_W == 32)) ? "ENABLED" : "DISABLED") ; 
                    localparam TRUE_GSR = ((GSR == "disabled") ? "DISABLED" : "ENABLED") ; 
                    wire [13:0] w_addr_w ; 
                    wire [13:0] r_addr_w ; 
                    wire [35:0] w_data_w ; 
                    wire [35:0] r_data_w ; 
                    wire [(DATA_WIDTH_R - 1):0] rd_data_w ; 
                    wire rd_en_w ; 
                    if (((REGMODE == "noreg") || (OUTPUT_CLK_EN == 0))) 
                        begin : genblk1
                            assign rd_data_o = rd_data_w ; 
                        end
                    else
                        begin : genblk1
                            reg [(DATA_WIDTH_R - 1):0] rd_data_r ; 
                            if ((RESETMODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge rd_clk_i)
                                        begin
                                            if (rst_i) 
                                                begin
                                                    rd_data_r <=  {DATA_WIDTH_R{1'b0}} ;
                                                end
                                            else
                                                if (rd_out_clk_en_i) 
                                                    begin
                                                        rd_data_r <=  rd_data_w ;
                                                    end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge rd_clk_i or 
                                            posedge rst_i)
                                        begin
                                            if (rst_i) 
                                                begin
                                                    rd_data_r <=  {DATA_WIDTH_R{1'b0}} ;
                                                end
                                            else
                                                if (rd_out_clk_en_i) 
                                                    begin
                                                        rd_data_r <=  rd_data_w ;
                                                    end
                                        end
                                end
                            assign rd_data_o = rd_data_r ; 
                        end
                    if (((DATA_WIDTH_W == 36) || (DATA_WIDTH_W == 32))) 
                        begin : genblk2
                            assign w_addr_w[13:5] = wr_addr_i ; 
                            assign w_addr_w[4] = 1'b1 ; 
                            assign w_addr_w[3:0] = ((BYTE_ENABLE == 1) ? ben_i : 4'b1111) ; 
                            if ((DATA_WIDTH_W == 36)) 
                                begin : genblk1
                                    assign w_data_w = wr_data_i ; 
                                end
                            else
                                begin : genblk1
                                    assign w_data_w[35] = 1'b0 ; 
                                    assign w_data_w[26] = 1'b0 ; 
                                    assign w_data_w[17] = 1'b0 ; 
                                    assign w_data_w[8] = 1'b0 ; 
                                    assign w_data_w[34:27] = wr_data_i[31:24] ; 
                                    assign w_data_w[25:18] = wr_data_i[23:16] ; 
                                    assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                    assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                end
                        end
                    else
                        if (((DATA_WIDTH_W == 18) || (DATA_WIDTH_W == 16))) 
                            begin : genblk2
                                assign w_addr_w[13:5] = wr_addr_i[9:1] ; 
                                assign w_addr_w[4] = wr_addr_i[0] ; 
                                assign w_addr_w[3:2] = 2'b11 ; 
                                assign w_addr_w[1:0] = ((BYTE_ENABLE == 1) ? ben_i : 2'b11) ; 
                                assign w_data_w[35:18] = {18{1'b0}} ; 
                                if ((DATA_WIDTH_W == 18)) 
                                    begin : genblk1
                                        assign w_data_w[17:0] = wr_data_i ; 
                                    end
                                else
                                    begin : genblk1
                                        assign w_data_w[17] = 1'b0 ; 
                                        assign w_data_w[8] = 1'b0 ; 
                                        assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                        assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                    end
                            end
                        else
                            if (((DATA_WIDTH_W == 9) || (DATA_WIDTH_W == 8))) 
                                begin : genblk2
                                    assign w_addr_w[13:5] = wr_addr_i[10:2] ; 
                                    assign w_addr_w[4] = wr_addr_i[1] ; 
                                    assign w_addr_w[3] = wr_addr_i[0] ; 
                                    assign w_addr_w[2:0] = 3'b111 ; 
                                    assign w_data_w[35:9] = {27{1'b0}} ; 
                                    if ((DATA_WIDTH_W == 9)) 
                                        begin: genblk1
                                            assign w_data_w[8:0] = wr_data_i ; 
                                        end
                                    else
                                        begin: genblk1
                                            assign w_data_w[8:0] = {1'b0,
                                                        wr_data_i} ; 
                                        end
                                end
                            else
                                if ((DATA_WIDTH_W == 4)) 
                                    begin : genblk2
                                        assign w_addr_w[13:5] = wr_addr_i[11:3] ; 
                                        assign w_addr_w[4] = wr_addr_i[2] ; 
                                        assign w_addr_w[3] = wr_addr_i[1] ; 
                                        assign w_addr_w[2] = wr_addr_i[0] ; 
                                        assign w_addr_w[1:0] = 2'b11 ; 
                                        assign w_data_w[35:4] = {32{1'b0}} ; 
                                        assign w_data_w[3:0] = wr_data_i ; 
                                    end
                                else
                                    if ((DATA_WIDTH_W == 2)) 
                                        begin : genblk2
                                            assign w_addr_w[13:5] = wr_addr_i[12:4] ; 
                                            assign w_addr_w[4] = wr_addr_i[3] ; 
                                            assign w_addr_w[3] = wr_addr_i[2] ; 
                                            assign w_addr_w[2] = wr_addr_i[1] ; 
                                            assign w_addr_w[1] = wr_addr_i[0] ; 
                                            assign w_addr_w[0] = 1'b1 ; 
                                            assign w_data_w[35:2] = {34{1'b0}} ; 
                                            assign w_data_w[1:0] = wr_data_i ; 
                                        end
                                    else
                                        begin : genblk2
                                            assign w_addr_w[13:5] = wr_addr_i[13:5] ; 
                                            assign w_addr_w[4] = wr_addr_i[4] ; 
                                            assign w_addr_w[3] = wr_addr_i[3] ; 
                                            assign w_addr_w[2] = wr_addr_i[2] ; 
                                            assign w_addr_w[1] = wr_addr_i[1] ; 
                                            assign w_addr_w[0] = wr_addr_i[0] ; 
                                            assign w_data_w[35:1] = {35{1'b0}} ; 
                                            assign w_data_w[0] = wr_data_i ; 
                                        end
                    if (((DATA_WIDTH_R == 36) || (DATA_WIDTH_R == 32))) 
                        begin : genblk3
                            assign r_addr_w[13:5] = rd_addr_i ; 
                            assign r_addr_w[4] = 1'b1 ; 
                            assign r_addr_w[3:0] = 4'b1111 ; 
                            if ((DATA_WIDTH_R == 36)) 
                                begin : genblk1
                                    assign rd_data_w = r_data_w ; 
                                end
                            else
                                begin : genblk1
                                    assign rd_data_w[31:24] = r_data_w[34:27] ; 
                                    assign rd_data_w[23:16] = r_data_w[25:18] ; 
                                    assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                    assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                end
                        end
                    else
                        if (((DATA_WIDTH_R == 18) || (DATA_WIDTH_R == 16))) 
                            begin : genblk3
                                assign r_addr_w[13:5] = rd_addr_i[9:1] ; 
                                assign r_addr_w[4] = rd_addr_i[0] ; 
                                assign r_addr_w[3:0] = 4'b1111 ; 
                                if ((DATA_WIDTH_R == 18)) 
                                    begin : genblk1
                                        assign rd_data_w[17:0] = r_data_w[17:0] ; 
                                    end
                                else
                                    begin : genblk1
                                        assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                        assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                    end
                            end
                        else
                            if (((DATA_WIDTH_R == 9) || (DATA_WIDTH_R == 8))) 
                                begin : genblk3
                                    assign r_addr_w[13:5] = rd_addr_i[10:2] ; 
                                    assign r_addr_w[4] = rd_addr_i[1] ; 
                                    assign r_addr_w[3] = rd_addr_i[0] ; 
                                    assign r_addr_w[2:0] = 3'b111 ; 
                                    if ((DATA_WIDTH_R == 9)) 
                                        begin: genblk1
                                            assign rd_data_w = r_data_w[8:0] ; 
                                        end
                                    else
                                        begin: genblk1
                                            assign rd_data_w = r_data_w[7:0] ; 
                                        end
                                end
                            else
                                if ((DATA_WIDTH_R == 4)) 
                                    begin : genblk3
                                        assign r_addr_w[13:5] = rd_addr_i[11:3] ; 
                                        assign r_addr_w[4] = rd_addr_i[2] ; 
                                        assign r_addr_w[3] = rd_addr_i[1] ; 
                                        assign r_addr_w[2] = rd_addr_i[0] ; 
                                        assign r_addr_w[1:0] = 2'b11 ; 
                                        assign rd_data_w = r_data_w[3:0] ; 
                                    end
                                else
                                    if ((DATA_WIDTH_R == 2)) 
                                        begin : genblk3
                                            assign r_addr_w[13:5] = rd_addr_i[12:4] ; 
                                            assign r_addr_w[4] = rd_addr_i[3] ; 
                                            assign r_addr_w[3] = rd_addr_i[2] ; 
                                            assign r_addr_w[2] = rd_addr_i[1] ; 
                                            assign r_addr_w[1] = rd_addr_i[0] ; 
                                            assign r_addr_w[0] = 1'b1 ; 
                                            assign rd_data_w = r_data_w[1:0] ; 
                                        end
                                    else
                                        begin : genblk3
                                            assign r_addr_w[13:5] = rd_addr_i[13:5] ; 
                                            assign r_addr_w[4] = rd_addr_i[4] ; 
                                            assign r_addr_w[3] = rd_addr_i[3] ; 
                                            assign r_addr_w[2] = rd_addr_i[2] ; 
                                            assign r_addr_w[1] = rd_addr_i[1] ; 
                                            assign r_addr_w[0] = rd_addr_i[0] ; 
                                            assign rd_data_w = r_data_w[0] ; 
                                        end
                    if ((OUTREG == "BYPASSED")) 
                        begin : genblk4
                            assign rd_en_w = rd_en_i ; 
                        end
                    else
                        begin : genblk4
                            reg rd_en_r ; 
                            assign rd_en_w = (rd_en_i | rd_en_r) ; 
                            if ((RESETMODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge rd_clk_i)
                                        begin
                                            if (rst_i) 
                                                begin
                                                    rd_en_r <=  1'b0 ;
                                                end
                                            else
                                                begin
                                                    rd_en_r <=  rd_en_i ;
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge rd_clk_i or 
                                            posedge rst_i)
                                        begin
                                            if (rst_i) 
                                                begin
                                                    rd_en_r <=  1'b0 ;
                                                end
                                            else
                                                begin
                                                    rd_en_r <=  rd_en_i ;
                                                end
                                        end
                                end
                        end
                    wire t_wr_en_i = ((BYTE_ENABLE == 0) ? wr_en_i : ((BYTE_WIDTH > 1) ? wr_en_i : (wr_en_i & ben_i))) ; 
                    wire t_rd_en_i = (((OUTREG == "USED") && (RESETMODE == "sync")) ? (rd_en_w | rst_i) : rd_en_w) ; 
                    wire [35:0] DI = w_data_w ; 
                    wire [13:0] ADW = w_addr_w ; 
                    wire [13:0] ADR = r_addr_w ; 
                    wire CLKW = wr_clk_i ; 
                    wire CLKR = rd_clk_i ; 
                    wire CEW = wr_clk_en_i ; 
                    wire CER = (((OUTREG == "USED") && (RESETMODE == "sync")) ? (rd_clk_en_i | rst_i) : rd_clk_en_i) ; 
                    wire [2:0] CSW = {t_wr_en_i,
                                t_wr_en_i,
                                t_wr_en_i} ; 
                    wire [2:0] CSR = {t_rd_en_i,
                                t_rd_en_i,
                                t_rd_en_i} ; 
                    wire RST = rst_i ; 
                    wire [35:0] DO ; 
                    assign r_data_w = DO ; 
                    localparam MEM_TYPE = "EBR" ; 
                    localparam T_MEM_SIZE = {"[",
                                MEM_SIZE,
                                "]"} ; 
                    (* ECO_MEM_TYPE=MEM_TYPE, ECO_MEM_ID=MEM_ID, ECO_MEM_SIZE=T_MEM_SIZE, ECO_MEM_BLOCK_SIZE=BLOCK_SIZE, ECO_MEM_BLOCK_POS=BLOCK_POS *) PDP16K pdp16k (.DI(DI), 
                                .ADW(ADW), 
                                .ADR(ADR), 
                                .CLKW(CLKW), 
                                .CLKR(CLKR), 
                                .CEW(CEW), 
                                .CER(CER), 
                                .CSW(CSW), 
                                .CSR(CSR), 
                                .RST(RST), 
                                .DO(DO), 
                                .ONEBITERR(one_err_det_o), 
                                .TWOBITERR(two_err_det_o)) ; 
                    defparam pdp16k.DATA_WIDTH_W = DW_W ; 
                    defparam pdp16k.DATA_WIDTH_R = DW_R ; 
                    defparam pdp16k.OUTREG = OUTREG ; 
                    defparam pdp16k.RESETMODE = TRUE_RST ; 
                    defparam pdp16k.CSDECODE_W = TRUE_CSW ; 
                    defparam pdp16k.CSDECODE_R = TRUE_CSR ; 
                    defparam pdp16k.ASYNC_RST_RELEASE = TRUE_RST_REL ; 
                    defparam pdp16k.INIT_DATA = "DYNAMIC" ; 
                    defparam pdp16k.ECC = (ECC_ENABLE ? "ENABLED" : "DISABLED") ; 
                    defparam pdp16k.INITVAL_00 = ((INIT_MODE == "mem_file") ? INIT_VALUE_00 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_01 = ((INIT_MODE == "mem_file") ? INIT_VALUE_01 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_02 = ((INIT_MODE == "mem_file") ? INIT_VALUE_02 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_03 = ((INIT_MODE == "mem_file") ? INIT_VALUE_03 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_04 = ((INIT_MODE == "mem_file") ? INIT_VALUE_04 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_05 = ((INIT_MODE == "mem_file") ? INIT_VALUE_05 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_06 = ((INIT_MODE == "mem_file") ? INIT_VALUE_06 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_07 = ((INIT_MODE == "mem_file") ? INIT_VALUE_07 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_08 = ((INIT_MODE == "mem_file") ? INIT_VALUE_08 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_09 = ((INIT_MODE == "mem_file") ? INIT_VALUE_09 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0A = ((INIT_MODE == "mem_file") ? INIT_VALUE_0A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0B = ((INIT_MODE == "mem_file") ? INIT_VALUE_0B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0C = ((INIT_MODE == "mem_file") ? INIT_VALUE_0C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0D = ((INIT_MODE == "mem_file") ? INIT_VALUE_0D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0E = ((INIT_MODE == "mem_file") ? INIT_VALUE_0E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0F = ((INIT_MODE == "mem_file") ? INIT_VALUE_0F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_10 = ((INIT_MODE == "mem_file") ? INIT_VALUE_10 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_11 = ((INIT_MODE == "mem_file") ? INIT_VALUE_11 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_12 = ((INIT_MODE == "mem_file") ? INIT_VALUE_12 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_13 = ((INIT_MODE == "mem_file") ? INIT_VALUE_13 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_14 = ((INIT_MODE == "mem_file") ? INIT_VALUE_14 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_15 = ((INIT_MODE == "mem_file") ? INIT_VALUE_15 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_16 = ((INIT_MODE == "mem_file") ? INIT_VALUE_16 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_17 = ((INIT_MODE == "mem_file") ? INIT_VALUE_17 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_18 = ((INIT_MODE == "mem_file") ? INIT_VALUE_18 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_19 = ((INIT_MODE == "mem_file") ? INIT_VALUE_19 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1A = ((INIT_MODE == "mem_file") ? INIT_VALUE_1A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1B = ((INIT_MODE == "mem_file") ? INIT_VALUE_1B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1C = ((INIT_MODE == "mem_file") ? INIT_VALUE_1C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1D = ((INIT_MODE == "mem_file") ? INIT_VALUE_1D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1E = ((INIT_MODE == "mem_file") ? INIT_VALUE_1E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1F = ((INIT_MODE == "mem_file") ? INIT_VALUE_1F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_20 = ((INIT_MODE == "mem_file") ? INIT_VALUE_20 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_21 = ((INIT_MODE == "mem_file") ? INIT_VALUE_21 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_22 = ((INIT_MODE == "mem_file") ? INIT_VALUE_22 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_23 = ((INIT_MODE == "mem_file") ? INIT_VALUE_23 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_24 = ((INIT_MODE == "mem_file") ? INIT_VALUE_24 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_25 = ((INIT_MODE == "mem_file") ? INIT_VALUE_25 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_26 = ((INIT_MODE == "mem_file") ? INIT_VALUE_26 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_27 = ((INIT_MODE == "mem_file") ? INIT_VALUE_27 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_28 = ((INIT_MODE == "mem_file") ? INIT_VALUE_28 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_29 = ((INIT_MODE == "mem_file") ? INIT_VALUE_29 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2A = ((INIT_MODE == "mem_file") ? INIT_VALUE_2A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2B = ((INIT_MODE == "mem_file") ? INIT_VALUE_2B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2C = ((INIT_MODE == "mem_file") ? INIT_VALUE_2C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2D = ((INIT_MODE == "mem_file") ? INIT_VALUE_2D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2E = ((INIT_MODE == "mem_file") ? INIT_VALUE_2E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2F = ((INIT_MODE == "mem_file") ? INIT_VALUE_2F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_30 = ((INIT_MODE == "mem_file") ? INIT_VALUE_30 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_31 = ((INIT_MODE == "mem_file") ? INIT_VALUE_31 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_32 = ((INIT_MODE == "mem_file") ? INIT_VALUE_32 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_33 = ((INIT_MODE == "mem_file") ? INIT_VALUE_33 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_34 = ((INIT_MODE == "mem_file") ? INIT_VALUE_34 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_35 = ((INIT_MODE == "mem_file") ? INIT_VALUE_35 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_36 = ((INIT_MODE == "mem_file") ? INIT_VALUE_36 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_37 = ((INIT_MODE == "mem_file") ? INIT_VALUE_37 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_38 = ((INIT_MODE == "mem_file") ? INIT_VALUE_38 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_39 = ((INIT_MODE == "mem_file") ? INIT_VALUE_39 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3A = ((INIT_MODE == "mem_file") ? INIT_VALUE_3A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3B = ((INIT_MODE == "mem_file") ? INIT_VALUE_3B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3C = ((INIT_MODE == "mem_file") ? INIT_VALUE_3C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3D = ((INIT_MODE == "mem_file") ? INIT_VALUE_3D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3E = ((INIT_MODE == "mem_file") ? INIT_VALUE_3E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3F = ((INIT_MODE == "mem_file") ? INIT_VALUE_3F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                end
            else
                if ((FAMILY_CODE == _FCODE_AP6_)) 
                    begin : AP6_MEM
                        localparam OUTREG = ((REGMODE == "reg") ? "USED" : "BYPASSED") ; 
                        localparam TRUE_CSW = ((CSDECODE_W == 0) ? "000" : ((CSDECODE_W == 1) ? "001" : ((CSDECODE_W == 2) ? "010" : ((CSDECODE_W == 3) ? "011" : ((CSDECODE_W == 4) ? "100" : ((CSDECODE_W == 5) ? "101" : ((CSDECODE_W == 6) ? "110" : "111"))))))) ; 
                        localparam TRUE_CSR = ((CSDECODE_R == 0) ? "000" : ((CSDECODE_R == 1) ? "001" : ((CSDECODE_R == 2) ? "010" : ((CSDECODE_R == 3) ? "011" : ((CSDECODE_R == 4) ? "100" : ((CSDECODE_R == 5) ? "101" : ((CSDECODE_R == 6) ? "110" : "111"))))))) ; 
                        localparam DW_W = (ECC_ENABLE ? "X64" : (((DATA_WIDTH_W == 72) || (DATA_WIDTH_W == 64)) ? "X72" : (((DATA_WIDTH_W == 36) || (DATA_WIDTH_W == 32)) ? "X36" : (((DATA_WIDTH_W == 18) || (DATA_WIDTH_W == 16)) ? "X18" : (((DATA_WIDTH_W == 9) || (DATA_WIDTH_W == 8)) ? "X9" : ((DATA_WIDTH_W == 4) ? "X4" : ((DATA_WIDTH_W == 2) ? "X2" : "X1"))))))) ; 
                        localparam DW_R = (ECC_ENABLE ? "X64" : (((DATA_WIDTH_R == 72) || (DATA_WIDTH_R == 64)) ? "X72" : (((DATA_WIDTH_R == 36) || (DATA_WIDTH_R == 32)) ? "X36" : (((DATA_WIDTH_R == 18) || (DATA_WIDTH_R == 16)) ? "X18" : (((DATA_WIDTH_R == 9) || (DATA_WIDTH_R == 8)) ? "X9" : ((DATA_WIDTH_R == 4) ? "X4" : ((DATA_WIDTH_R == 2) ? "X2" : "X1"))))))) ; 
                        localparam TRUE_RST = ((RESETMODE == "sync") ? "SYNC" : "ASYNC") ; 
                        localparam TRUE_RST_REL = ((RESET_RELEASE == "sync") ? "SYNC" : "ASYNC") ; 
                        localparam TRUE_ECC = (((ECC_ENABLE == 1) && (DATA_WIDTH_W == 64)) ? "ENABLED" : "DISABLED") ; 
                        localparam TRUE_GSR = ((GSR == "disabled") ? "DISABLED" : "ENABLED") ; 
                        wire [14:0] w_addr_w ; 
                        wire [14:0] r_addr_w ; 
                        wire [71:0] w_data_w ; 
                        wire [71:0] r_data_w ; 
                        wire [(DATA_WIDTH_R - 1):0] rd_data_w ; 
                        if (((DATA_WIDTH_W == 72) || (DATA_WIDTH_W == 64))) 
                            begin : genblk1
                                assign w_addr_w[14:6] = wr_addr_i ; 
                                assign w_addr_w[5:0] = ((BYTE_ENABLE == 1) ? ben_i[5:0] : 6'b11_1111) ; 
                                if ((DATA_WIDTH_W == 72)) 
                                    begin : genblk1
                                        assign w_data_w = wr_data_i ; 
                                    end
                                else
                                    begin : genblk1
                                        assign w_data_w[71] = 1'b0 ; 
                                        assign w_data_w[62] = 1'b0 ; 
                                        assign w_data_w[53] = 1'b0 ; 
                                        assign w_data_w[44] = 1'b0 ; 
                                        assign w_data_w[35] = 1'b0 ; 
                                        assign w_data_w[26] = 1'b0 ; 
                                        assign w_data_w[17] = 1'b0 ; 
                                        assign w_data_w[8] = 1'b0 ; 
                                        assign w_data_w[70:63] = wr_data_i[63:56] ; 
                                        assign w_data_w[61:54] = wr_data_i[55:48] ; 
                                        assign w_data_w[52:45] = wr_data_i[47:40] ; 
                                        assign w_data_w[43:36] = wr_data_i[39:32] ; 
                                        assign w_data_w[34:27] = wr_data_i[31:24] ; 
                                        assign w_data_w[25:18] = wr_data_i[23:16] ; 
                                        assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                        assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                    end
                            end
                        else
                            if (((DATA_WIDTH_W == 36) || (DATA_WIDTH_W == 32))) 
                                begin : genblk1
                                    assign w_addr_w[14:5] = wr_addr_i ; 
                                    assign w_addr_w[4] = 1'b1 ; 
                                    assign w_addr_w[3:0] = ((BYTE_ENABLE == 1) ? ben_i : 4'b1111) ; 
                                    assign w_data_w[71:36] = {36{1'b0}} ; 
                                    if ((DATA_WIDTH_W == 36)) 
                                        begin : genblk1
                                            assign w_data_w = wr_data_i ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign w_data_w[35] = 1'b0 ; 
                                            assign w_data_w[26] = 1'b0 ; 
                                            assign w_data_w[17] = 1'b0 ; 
                                            assign w_data_w[8] = 1'b0 ; 
                                            assign w_data_w[34:27] = wr_data_i[31:24] ; 
                                            assign w_data_w[25:18] = wr_data_i[23:16] ; 
                                            assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                            assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                        end
                                end
                            else
                                if (((DATA_WIDTH_W == 18) || (DATA_WIDTH_W == 16))) 
                                    begin : genblk1
                                        assign w_addr_w[14:4] = wr_addr_i ; 
                                        assign w_addr_w[3:2] = 2'b11 ; 
                                        assign w_addr_w[1:0] = ((BYTE_ENABLE == 1) ? ben_i : 2'b11) ; 
                                        assign w_data_w[71:18] = {54{1'b0}} ; 
                                        if ((DATA_WIDTH_W == 18)) 
                                            begin : genblk1
                                                assign w_data_w[17:0] = wr_data_i ; 
                                            end
                                        else
                                            begin : genblk1
                                                assign w_data_w[17] = 1'b0 ; 
                                                assign w_data_w[8] = 1'b0 ; 
                                                assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                                assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                            end
                                    end
                                else
                                    if (((DATA_WIDTH_W == 9) || (DATA_WIDTH_W == 8))) 
                                        begin : genblk1
                                            assign w_addr_w[14:3] = wr_addr_i ; 
                                            assign w_addr_w[2:0] = 3'b111 ; 
                                            assign w_data_w[71:9] = {63{1'b0}} ; 
                                            if ((DATA_WIDTH_W == 9)) 
                                                begin: genblk1
                                                    assign w_data_w[8:0] = wr_data_i ; 
                                                end
                                            else
                                                begin: genblk1
                                                    assign w_data_w[8:0] = {1'b0,
                                                                wr_data_i} ; 
                                                end
                                        end
                                    else
                                        if ((DATA_WIDTH_W == 4)) 
                                            begin : genblk1
                                                assign w_addr_w[14:2] = wr_addr_i ; 
                                                assign w_addr_w[1:0] = 2'b11 ; 
                                                assign w_data_w[71:4] = {68{1'b0}} ; 
                                                assign w_data_w[3:0] = wr_data_i ; 
                                            end
                                        else
                                            if ((DATA_WIDTH_W == 2)) 
                                                begin : genblk1
                                                    assign w_addr_w[14:1] = wr_addr_i ; 
                                                    assign w_addr_w[0] = 1'b1 ; 
                                                    assign w_data_w[71:2] = {70{1'b0}} ; 
                                                    assign w_data_w[1:0] = wr_data_i ; 
                                                end
                                            else
                                                begin : genblk1
                                                    assign w_addr_w[14:0] = wr_addr_i ; 
                                                    assign w_data_w[71:1] = {71{1'b0}} ; 
                                                    assign w_data_w[0] = wr_data_i ; 
                                                end
                        if (((DATA_WIDTH_R == 72) || (DATA_WIDTH_R == 64))) 
                            begin : genblk2
                                assign r_addr_w[14:6] = rd_addr_i ; 
                                assign r_addr_w[5:0] = 6'b11_1111 ; 
                                if ((DATA_WIDTH_R == 72)) 
                                    begin : genblk1
                                        assign rd_data_w = r_data_w ; 
                                    end
                                else
                                    begin : genblk1
                                        assign rd_data_w[63:56] = r_data_w[70:63] ; 
                                        assign rd_data_w[55:48] = r_data_w[61:54] ; 
                                        assign rd_data_w[47:40] = r_data_w[52:45] ; 
                                        assign rd_data_w[39:32] = r_data_w[43:36] ; 
                                        assign rd_data_w[31:24] = r_data_w[34:27] ; 
                                        assign rd_data_w[23:16] = r_data_w[25:18] ; 
                                        assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                        assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                    end
                            end
                        else
                            if (((DATA_WIDTH_R == 36) || (DATA_WIDTH_R == 32))) 
                                begin : genblk2
                                    assign r_addr_w[14:5] = rd_addr_i ; 
                                    assign r_addr_w[4] = 1'b1 ; 
                                    assign r_addr_w[3:0] = 4'b1111 ; 
                                    if ((DATA_WIDTH_R == 36)) 
                                        begin : genblk1
                                            assign rd_data_w[35:0] = r_data_w[35:0] ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign rd_data_w[31:24] = r_data_w[34:27] ; 
                                            assign rd_data_w[23:16] = r_data_w[25:18] ; 
                                            assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                            assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                        end
                                end
                            else
                                if (((DATA_WIDTH_R == 18) || (DATA_WIDTH_R == 16))) 
                                    begin : genblk2
                                        assign r_addr_w[14:4] = rd_addr_i ; 
                                        assign r_addr_w[3:2] = 2'b11 ; 
                                        assign r_addr_w[1:0] = 2'b11 ; 
                                        if ((DATA_WIDTH_R == 18)) 
                                            begin : genblk1
                                                assign rd_data_w[17:0] = r_data_w[17:0] ; 
                                            end
                                        else
                                            begin : genblk1
                                                assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                                assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                            end
                                    end
                                else
                                    if (((DATA_WIDTH_R == 9) || (DATA_WIDTH_R == 8))) 
                                        begin : genblk2
                                            assign r_addr_w[14:3] = rd_addr_i ; 
                                            assign r_addr_w[2:0] = 3'b111 ; 
                                            if ((DATA_WIDTH_R == 9)) 
                                                begin: genblk1
                                                    assign rd_data_w[8:0] = r_data_w[8:0] ; 
                                                end
                                            else
                                                begin: genblk1
                                                    assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                                end
                                        end
                                    else
                                        if ((DATA_WIDTH_R == 4)) 
                                            begin : genblk2
                                                assign r_addr_w[14:2] = rd_addr_i ; 
                                                assign r_addr_w[1:0] = 2'b11 ; 
                                                assign rd_data_w = r_data_w[3:0] ; 
                                            end
                                        else
                                            if ((DATA_WIDTH_R == 2)) 
                                                begin : genblk2
                                                    assign r_addr_w[14:1] = rd_addr_i ; 
                                                    assign r_addr_w[0] = 1'b1 ; 
                                                    assign rd_data_w = r_data_w[1:0] ; 
                                                end
                                            else
                                                begin : genblk2
                                                    assign r_addr_w[14:0] = rd_addr_i ; 
                                                    assign rd_data_w = r_data_w[0] ; 
                                                end
                        assign rd_data_o = rd_data_w ; 
                        wire t_wr_en_i = ((BYTE_ENABLE == 0) ? wr_en_i : ((BYTE_WIDTH > 1) ? wr_en_i : (wr_en_i & ben_i))) ; 
                        wire t_rd_en_i = (((RESETMODE == "sync") && (REGMODE == "reg")) ? (rd_en_i | rst_i) : rd_en_i) ; 
                        wire [71:0] DI = w_data_w ; 
                        wire [14:0] ADW = w_addr_w ; 
                        wire [14:0] ADR = r_addr_w ; 
                        wire CLKW = wr_clk_i ; 
                        wire CLKR = rd_clk_i ; 
                        wire CEW = wr_clk_en_i ; 
                        wire CER = (((RESETMODE == "sync") && (REGMODE == "reg")) ? (rd_clk_en_i | rst_i) : rd_clk_en_i) ; 
                        wire [2:0] CSW = {t_wr_en_i,
                                    t_wr_en_i,
                                    t_wr_en_i} ; 
                        wire [2:0] CSR = {t_rd_en_i,
                                    t_rd_en_i,
                                    t_rd_en_i} ; 
                        wire RST = rst_i ; 
                        wire [71:0] DO ; 
                        wire BE6 = (((BYTE_ENABLE == 1) && (BYTE_WIDTH == 8)) ? ben_i[6] : 1'b1) ; 
                        wire BE7 = (((BYTE_ENABLE == 1) && (BYTE_WIDTH == 8)) ? ben_i[7] : 1'b1) ; 
                        wire OCE = rd_out_clk_en_i ; 
                        assign r_data_w = DO ; 
                        localparam MEM_TYPE = "EBR" ; 
                        localparam T_MEM_SIZE = {"[",
                                    MEM_SIZE,
                                    "]"} ; 
                        (* ECO_MEM_TYPE=MEM_TYPE, ECO_MEM_ID=MEM_ID, ECO_MEM_SIZE=T_MEM_SIZE, ECO_MEM_BLOCK_SIZE=BLOCK_SIZE, ECO_MEM_BLOCK_POS=BLOCK_POS *) PDP32K pdp32k (.DI(DI), 
                                    .ADW(ADW), 
                                    .ADR(ADR), 
                                    .CLKW(CLKW), 
                                    .CLKR(CLKR), 
                                    .CEW(CEW), 
                                    .CER(CER), 
                                    .OCE(OCE), 
                                    .BE6(BE6), 
                                    .BE7(BE7), 
                                    .CSW(CSW), 
                                    .CSR(CSR), 
                                    .RST(RST), 
                                    .DO(DO), 
                                    .ONEBITERR(one_err_det_o), 
                                    .TWOBITERR(two_err_det_o)) ; 
                        defparam pdp32k.DATA_WIDTH_W = DW_W ; 
                        defparam pdp32k.DATA_WIDTH_R = DW_R ; 
                        defparam pdp32k.OUTREG = OUTREG ; 
                        defparam pdp32k.RESETMODE = TRUE_RST ; 
                        defparam pdp32k.CSDECODE_W = TRUE_CSW ; 
                        defparam pdp32k.CSDECODE_R = TRUE_CSR ; 
                        defparam pdp32k.ASYNC_RST_RELEASE = TRUE_RST_REL ; 
                        defparam pdp32k.INIT_DATA = "DYNAMIC" ; 
                        defparam pdp32k.ECC = (ECC_ENABLE ? "ENABLED" : "DISABLED") ; 
                        defparam pdp32k.INITVAL_00 = ((INIT_MODE == "mem_file") ? INIT_VALUE_00 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_01 = ((INIT_MODE == "mem_file") ? INIT_VALUE_01 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_02 = ((INIT_MODE == "mem_file") ? INIT_VALUE_02 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_03 = ((INIT_MODE == "mem_file") ? INIT_VALUE_03 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_04 = ((INIT_MODE == "mem_file") ? INIT_VALUE_04 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_05 = ((INIT_MODE == "mem_file") ? INIT_VALUE_05 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_06 = ((INIT_MODE == "mem_file") ? INIT_VALUE_06 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_07 = ((INIT_MODE == "mem_file") ? INIT_VALUE_07 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_08 = ((INIT_MODE == "mem_file") ? INIT_VALUE_08 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_09 = ((INIT_MODE == "mem_file") ? INIT_VALUE_09 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0A = ((INIT_MODE == "mem_file") ? INIT_VALUE_0A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0B = ((INIT_MODE == "mem_file") ? INIT_VALUE_0B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0C = ((INIT_MODE == "mem_file") ? INIT_VALUE_0C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0D = ((INIT_MODE == "mem_file") ? INIT_VALUE_0D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0E = ((INIT_MODE == "mem_file") ? INIT_VALUE_0E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0F = ((INIT_MODE == "mem_file") ? INIT_VALUE_0F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_10 = ((INIT_MODE == "mem_file") ? INIT_VALUE_10 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_11 = ((INIT_MODE == "mem_file") ? INIT_VALUE_11 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_12 = ((INIT_MODE == "mem_file") ? INIT_VALUE_12 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_13 = ((INIT_MODE == "mem_file") ? INIT_VALUE_13 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_14 = ((INIT_MODE == "mem_file") ? INIT_VALUE_14 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_15 = ((INIT_MODE == "mem_file") ? INIT_VALUE_15 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_16 = ((INIT_MODE == "mem_file") ? INIT_VALUE_16 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_17 = ((INIT_MODE == "mem_file") ? INIT_VALUE_17 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_18 = ((INIT_MODE == "mem_file") ? INIT_VALUE_18 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_19 = ((INIT_MODE == "mem_file") ? INIT_VALUE_19 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1A = ((INIT_MODE == "mem_file") ? INIT_VALUE_1A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1B = ((INIT_MODE == "mem_file") ? INIT_VALUE_1B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1C = ((INIT_MODE == "mem_file") ? INIT_VALUE_1C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1D = ((INIT_MODE == "mem_file") ? INIT_VALUE_1D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1E = ((INIT_MODE == "mem_file") ? INIT_VALUE_1E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1F = ((INIT_MODE == "mem_file") ? INIT_VALUE_1F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_20 = ((INIT_MODE == "mem_file") ? INIT_VALUE_20 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_21 = ((INIT_MODE == "mem_file") ? INIT_VALUE_21 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_22 = ((INIT_MODE == "mem_file") ? INIT_VALUE_22 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_23 = ((INIT_MODE == "mem_file") ? INIT_VALUE_23 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_24 = ((INIT_MODE == "mem_file") ? INIT_VALUE_24 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_25 = ((INIT_MODE == "mem_file") ? INIT_VALUE_25 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_26 = ((INIT_MODE == "mem_file") ? INIT_VALUE_26 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_27 = ((INIT_MODE == "mem_file") ? INIT_VALUE_27 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_28 = ((INIT_MODE == "mem_file") ? INIT_VALUE_28 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_29 = ((INIT_MODE == "mem_file") ? INIT_VALUE_29 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2A = ((INIT_MODE == "mem_file") ? INIT_VALUE_2A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2B = ((INIT_MODE == "mem_file") ? INIT_VALUE_2B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2C = ((INIT_MODE == "mem_file") ? INIT_VALUE_2C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2D = ((INIT_MODE == "mem_file") ? INIT_VALUE_2D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2E = ((INIT_MODE == "mem_file") ? INIT_VALUE_2E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2F = ((INIT_MODE == "mem_file") ? INIT_VALUE_2F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_30 = ((INIT_MODE == "mem_file") ? INIT_VALUE_30 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_31 = ((INIT_MODE == "mem_file") ? INIT_VALUE_31 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_32 = ((INIT_MODE == "mem_file") ? INIT_VALUE_32 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_33 = ((INIT_MODE == "mem_file") ? INIT_VALUE_33 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_34 = ((INIT_MODE == "mem_file") ? INIT_VALUE_34 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_35 = ((INIT_MODE == "mem_file") ? INIT_VALUE_35 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_36 = ((INIT_MODE == "mem_file") ? INIT_VALUE_36 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_37 = ((INIT_MODE == "mem_file") ? INIT_VALUE_37 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_38 = ((INIT_MODE == "mem_file") ? INIT_VALUE_38 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_39 = ((INIT_MODE == "mem_file") ? INIT_VALUE_39 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3A = ((INIT_MODE == "mem_file") ? INIT_VALUE_3A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3B = ((INIT_MODE == "mem_file") ? INIT_VALUE_3B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3C = ((INIT_MODE == "mem_file") ? INIT_VALUE_3C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3D = ((INIT_MODE == "mem_file") ? INIT_VALUE_3D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3E = ((INIT_MODE == "mem_file") ? INIT_VALUE_3E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3F = ((INIT_MODE == "mem_file") ? INIT_VALUE_3F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_40 = ((INIT_MODE == "mem_file") ? INIT_VALUE_40 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_41 = ((INIT_MODE == "mem_file") ? INIT_VALUE_41 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_42 = ((INIT_MODE == "mem_file") ? INIT_VALUE_42 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_43 = ((INIT_MODE == "mem_file") ? INIT_VALUE_43 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_44 = ((INIT_MODE == "mem_file") ? INIT_VALUE_44 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_45 = ((INIT_MODE == "mem_file") ? INIT_VALUE_45 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_46 = ((INIT_MODE == "mem_file") ? INIT_VALUE_46 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_47 = ((INIT_MODE == "mem_file") ? INIT_VALUE_47 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_48 = ((INIT_MODE == "mem_file") ? INIT_VALUE_48 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_49 = ((INIT_MODE == "mem_file") ? INIT_VALUE_49 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4A = ((INIT_MODE == "mem_file") ? INIT_VALUE_4A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4B = ((INIT_MODE == "mem_file") ? INIT_VALUE_4B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4C = ((INIT_MODE == "mem_file") ? INIT_VALUE_4C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4D = ((INIT_MODE == "mem_file") ? INIT_VALUE_4D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4E = ((INIT_MODE == "mem_file") ? INIT_VALUE_4E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4F = ((INIT_MODE == "mem_file") ? INIT_VALUE_4F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_50 = ((INIT_MODE == "mem_file") ? INIT_VALUE_50 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_51 = ((INIT_MODE == "mem_file") ? INIT_VALUE_51 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_52 = ((INIT_MODE == "mem_file") ? INIT_VALUE_52 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_53 = ((INIT_MODE == "mem_file") ? INIT_VALUE_53 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_54 = ((INIT_MODE == "mem_file") ? INIT_VALUE_54 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_55 = ((INIT_MODE == "mem_file") ? INIT_VALUE_55 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_56 = ((INIT_MODE == "mem_file") ? INIT_VALUE_56 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_57 = ((INIT_MODE == "mem_file") ? INIT_VALUE_57 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_58 = ((INIT_MODE == "mem_file") ? INIT_VALUE_58 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_59 = ((INIT_MODE == "mem_file") ? INIT_VALUE_59 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5A = ((INIT_MODE == "mem_file") ? INIT_VALUE_5A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5B = ((INIT_MODE == "mem_file") ? INIT_VALUE_5B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5C = ((INIT_MODE == "mem_file") ? INIT_VALUE_5C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5D = ((INIT_MODE == "mem_file") ? INIT_VALUE_5D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5E = ((INIT_MODE == "mem_file") ? INIT_VALUE_5E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5F = ((INIT_MODE == "mem_file") ? INIT_VALUE_5F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_60 = ((INIT_MODE == "mem_file") ? INIT_VALUE_60 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_61 = ((INIT_MODE == "mem_file") ? INIT_VALUE_61 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_62 = ((INIT_MODE == "mem_file") ? INIT_VALUE_62 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_63 = ((INIT_MODE == "mem_file") ? INIT_VALUE_63 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_64 = ((INIT_MODE == "mem_file") ? INIT_VALUE_64 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_65 = ((INIT_MODE == "mem_file") ? INIT_VALUE_65 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_66 = ((INIT_MODE == "mem_file") ? INIT_VALUE_66 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_67 = ((INIT_MODE == "mem_file") ? INIT_VALUE_67 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_68 = ((INIT_MODE == "mem_file") ? INIT_VALUE_68 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_69 = ((INIT_MODE == "mem_file") ? INIT_VALUE_69 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6A = ((INIT_MODE == "mem_file") ? INIT_VALUE_6A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6B = ((INIT_MODE == "mem_file") ? INIT_VALUE_6B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6C = ((INIT_MODE == "mem_file") ? INIT_VALUE_6C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6D = ((INIT_MODE == "mem_file") ? INIT_VALUE_6D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6E = ((INIT_MODE == "mem_file") ? INIT_VALUE_6E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6F = ((INIT_MODE == "mem_file") ? INIT_VALUE_6F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_70 = ((INIT_MODE == "mem_file") ? INIT_VALUE_70 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_71 = ((INIT_MODE == "mem_file") ? INIT_VALUE_71 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_72 = ((INIT_MODE == "mem_file") ? INIT_VALUE_72 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_73 = ((INIT_MODE == "mem_file") ? INIT_VALUE_73 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_74 = ((INIT_MODE == "mem_file") ? INIT_VALUE_74 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_75 = ((INIT_MODE == "mem_file") ? INIT_VALUE_75 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_76 = ((INIT_MODE == "mem_file") ? INIT_VALUE_76 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_77 = ((INIT_MODE == "mem_file") ? INIT_VALUE_77 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_78 = ((INIT_MODE == "mem_file") ? INIT_VALUE_78 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_79 = ((INIT_MODE == "mem_file") ? INIT_VALUE_79 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7A = ((INIT_MODE == "mem_file") ? INIT_VALUE_7A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7B = ((INIT_MODE == "mem_file") ? INIT_VALUE_7B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7C = ((INIT_MODE == "mem_file") ? INIT_VALUE_7C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7D = ((INIT_MODE == "mem_file") ? INIT_VALUE_7D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7E = ((INIT_MODE == "mem_file") ? INIT_VALUE_7E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7F = ((INIT_MODE == "mem_file") ? INIT_VALUE_7F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] calculateStringSize ; 
        input [31:0] x_calc ; 
        input [31:0] y_calc ; 
        reg [31:0] x_func ; 
        reg [31:0] y_func ; 
        begin
            if ((x_calc >= 10000000)) 
                begin
                    x_func = 8 ;
                end
            else
                if ((x_calc >= 1000000)) 
                    begin
                        x_func = 7 ;
                    end
                else
                    if ((x_calc >= 100000)) 
                        begin
                            x_func = 6 ;
                        end
                    else
                        if ((x_calc >= 10000)) 
                            begin
                                x_func = 5 ;
                            end
                        else
                            if ((x_calc >= 1000)) 
                                begin
                                    x_func = 4 ;
                                end
                            else
                                if ((x_calc >= 100)) 
                                    begin
                                        x_func = 3 ;
                                    end
                                else
                                    if ((x_calc >= 10)) 
                                        begin
                                            x_func = 2 ;
                                        end
                                    else
                                        begin
                                            x_func = 1 ;
                                        end
            if ((y_calc >= 10000000)) 
                begin
                    y_func = 8 ;
                end
            else
                if ((y_calc >= 1000000)) 
                    begin
                        y_func = 7 ;
                    end
                else
                    if ((y_calc >= 100000)) 
                        begin
                            y_func = 6 ;
                        end
                    else
                        if ((y_calc >= 10000)) 
                            begin
                                y_func = 5 ;
                            end
                        else
                            if ((y_calc >= 1000)) 
                                begin
                                    y_func = 4 ;
                                end
                            else
                                if ((y_calc >= 100)) 
                                    begin
                                        y_func = 3 ;
                                    end
                                else
                                    if ((y_calc >= 10)) 
                                        begin
                                            y_func = 2 ;
                                        end
                                    else
                                        begin
                                            y_func = 1 ;
                                        end
            calculateStringSize = (((3 + x_func) + y_func) * 8) ;
        end
    endfunction
    function [31:0] getByteWidth ; 
        input [31:0] data_width ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                begin
                    if (((data_width == 36) || (data_width == 32))) 
                        getByteWidth = 4 ;
                    else
                        if (((data_width == 18) || (data_width == 16))) 
                            getByteWidth = 2 ;
                        else
                            getByteWidth = 1 ;
                end
            _FCODE_ICE_ : 
                begin
                    if ((data_width == 16)) 
                        getByteWidth = 2 ;
                    else
                        getByteWidth = 1 ;
                end
            _FCODE_AP6_ : 
                begin
                    if (((data_width == 72) || (data_width == 64))) 
                        getByteWidth = 8 ;
                    else
                        if (((data_width == 36) || (data_width == 32))) 
                            getByteWidth = 4 ;
                        else
                            if (((data_width == 18) || (data_width == 16))) 
                                getByteWidth = 2 ;
                            else
                                getByteWidth = 1 ;
                end
            default : 
                getByteWidth = 1 ;
            endcase 
        end
    endfunction
    function [(STRING_SIZE - 1):0] getStringFromPos ; 
        input [31:0] x ; 
        input [31:0] y ; 
        begin
            if ((y >= 10000000)) 
                begin
                    if ((x >= 10000000)) 
                        begin
                            getStringFromPos = {"[",
                                    NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                    NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                    ",",
                                    NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                    NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                    "]"} ;
                        end
                    else
                        if ((x >= 1000000)) 
                            begin
                                getStringFromPos = {"[",
                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                        ",",
                                        NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                        "]"} ;
                            end
                        else
                            if ((x >= 100000)) 
                                begin
                                    getStringFromPos = {"[",
                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                            ",",
                                            NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                            "]"} ;
                                end
                            else
                                if ((x >= 10000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 1000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                    NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 100)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 10)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                end
            else
                if ((y >= 1000000)) 
                    begin
                        if ((x >= 10000000)) 
                            begin
                                getStringFromPos = {"[",
                                        NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                        ",",
                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                        "]"} ;
                            end
                        else
                            if ((x >= 1000000)) 
                                begin
                                    getStringFromPos = {"[",
                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                            ",",
                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                            "]"} ;
                                end
                            else
                                if ((x >= 100000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 10000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 1000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 100)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 10)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                    end
                else
                    if ((y >= 100000)) 
                        begin
                            if ((x >= 10000000)) 
                                begin
                                    getStringFromPos = {"[",
                                            NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                            ",",
                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                            "]"} ;
                                end
                            else
                                if ((x >= 1000000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 100000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 10000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 1000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 100)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 10)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                        end
                    else
                        if ((y >= 10000)) 
                            begin
                                if ((x >= 10000000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 1000000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 100000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 10000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 1000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 100)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 10)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                            end
                        else
                            if ((y >= 1000)) 
                                begin
                                    if ((x >= 10000000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                    NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 1000000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 100000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 10000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 1000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 100)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 10)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                end
                            else
                                if ((y >= 100)) 
                                    begin
                                        if ((x >= 10000000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 1000000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 100000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 10000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 1000)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 100)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                if ((x >= 10)) 
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                    end
                                else
                                    if ((y >= 10)) 
                                        begin
                                            if ((x >= 10000000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 1000000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 100000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 10000)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 1000)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                if ((x >= 100)) 
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                                                else
                                                                    if ((x >= 10)) 
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                        end
                                    else
                                        begin
                                            if ((x >= 10000000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 1000000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 100000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 10000)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 1000)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                if ((x >= 100)) 
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                                                else
                                                                    if ((x >= 10)) 
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                        end
        end
    endfunction
    function [31:0] getAddrWidth ; 
        input [31:0] data_width ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                begin
                    case (data_width)
                    36 : 
                        getAddrWidth = 9 ;
                    32 : 
                        getAddrWidth = 9 ;
                    18 : 
                        getAddrWidth = 10 ;
                    16 : 
                        getAddrWidth = 10 ;
                    9 : 
                        getAddrWidth = 11 ;
                    8 : 
                        getAddrWidth = 11 ;
                    4 : 
                        getAddrWidth = 12 ;
                    2 : 
                        getAddrWidth = 13 ;
                    1 : 
                        getAddrWidth = 14 ;
                    default : 
                        getAddrWidth = 9 ;
                    endcase 
                end
            _FCODE_ICE_ : 
                begin
                    case (data_width)
                    16 : 
                        getAddrWidth = 8 ;
                    8 : 
                        getAddrWidth = 9 ;
                    4 : 
                        getAddrWidth = 10 ;
                    2 : 
                        getAddrWidth = 11 ;
                    default : 
                        getAddrWidth = 8 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (data_width)
                    72 : 
                        getAddrWidth = 9 ;
                    64 : 
                        getAddrWidth = 9 ;
                    36 : 
                        getAddrWidth = 10 ;
                    32 : 
                        getAddrWidth = 10 ;
                    18 : 
                        getAddrWidth = 11 ;
                    16 : 
                        getAddrWidth = 11 ;
                    9 : 
                        getAddrWidth = 12 ;
                    8 : 
                        getAddrWidth = 12 ;
                    4 : 
                        getAddrWidth = 13 ;
                    2 : 
                        getAddrWidth = 14 ;
                    1 : 
                        getAddrWidth = 15 ;
                    default : 
                        getAddrWidth = 9 ;
                    endcase 
                end
            default : 
                getAddrWidth = 8 ;
            endcase 
        end
    endfunction

//=============================================================================
// lscc_fifo_mem_core.v
// Local Variables:
// verilog-library-directories: ("../../common")
// End:
//=============================================================================
endmodule


