-- Library and Use statements for IEEE packages
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity top is
port(
ClkA,ClkB   : in  std_logic;
A,SEL   : in std_logic;
B: out std_logic
);

end top;

architecture behave of top is

signal A_Sig, B_sig: std_logic;
signal clk : std_logic;

Component DCS is
generic ( DCSMODE : string);
port (
  CLK0     :in std_logic ;  -- I
  CLK1     :in std_logic ;  -- I
  SEL      :in std_logic ;  -- I
  SELFORCE :in std_logic ;  -- I
  DCSOUT   :out std_logic    -- O
);
end component;

begin

MyDCS: DCS
generic map (
  DCSMODE  => "DCS"
)
port map (
  CLK0     => CLKA,  -- I
  CLK1     => CLKB,  -- I
  SEL      => SEL,  -- I
  SELFORCE => '1',  -- I
  DCSOUT   => clk   -- O
);

process(clk)
begin
if rising_edge(clk) then
	A_sig <= A ;
	B_sig <= A_sig; 
end if;
end process;
B <= B_sig;

end behave;