-- Library and Use statements for IEEE packages
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity top is
port(
Clk1, clk2  : in  std_logic;
SEL,En   : in  std_logic;
A,B   : in std_logic_vector (7 downto 0);
D   : out std_logic_vector (15 downto 0)
);
end top;

architecture behave of top is
Component DCS is
generic ( DCSMODE : string);
port (
  CLK0     :in std_logic ;  -- I
  CLK1     :in std_logic ;  -- I
  SEL      :in std_logic ;  -- I
  SELFORCE :in std_logic ;  -- I
  DCSOUT   :out std_logic    -- O
);
end component;

Component CDC_sync is
port(
RClk   : in  std_logic;
A : in std_logic;
B : out std_logic
);
end component; 

component PLL01 is
    port(
        clki_i: in std_logic;
        clkop_o: out std_logic;
        clkos_o: out std_logic
    );
end component;

component FIFO_A2B is
    port(
        wr_clk_i: in std_logic;
        rd_clk_i: in std_logic;
        rst_i: in std_logic;
        rp_rst_i: in std_logic;
        wr_en_i: in std_logic;
        rd_en_i: in std_logic;
        wr_data_i: in std_logic_vector(15 downto 0);
        full_o: out std_logic;
        empty_o: out std_logic;
        rd_data_o: out std_logic_vector(15 downto 0)
    );
end component;
component PLL02 is
    port(
        clki_i: in std_logic;
        clkop_o: out std_logic
    );
end component;

signal CLKA, CLKB, CLK3, clk2x, clk1x : std_logic;
signal En_sig, En_Sig1 : std_logic;
signal A_Sig, B_sig : std_logic_vector (7 downto 0);
signal C_sig, D_sig, D_sig1 : std_logic_vector (15 downto 0);

--attribute syn_useioff : boolean;
--attribute syn_useioff of behave : architecture is true;

begin
MyPLL01 : PLL02 port map(
    clki_i=> CLK2,
    clkop_o=> CLK2x
);
MyPLL02 : PLL02 port map(
    clki_i=> CLK1,
    clkop_o=> CLK1x
);

MyCDC01 : CDC_sync 
port map(
RClk  => CLK3,
A => En_sig,
B => En_sig1
);

MyDCS: DCS
generic map (
  DCSMODE  => "DCS"
)
port map (
  CLK0     => CLK2x,  -- I
  CLK1     => CLK1x,  -- I
  SEL      => SEL,  -- I
  SELFORCE => '1',  -- I
  DCSOUT   => CLK3   -- O
);

process(clk1x)
begin
if rising_edge(clk1x) then
	A_sig <= A ;
	B_sig <= B; 
	C_sig <= A_sig * B_sig;
	En_sig <= En;
end if;
end process;

MyFIFO : FIFO_A2B port map(
    wr_clk_i=> CLK1x,
    rd_clk_i=> CLK3,
    rst_i=> '0',
    rp_rst_i=> '0',
    wr_en_i=> En_sig,
    rd_en_i=> En_Sig1,
    wr_data_i=> C_sig,
    full_o=> open,
    empty_o=> open,
    rd_data_o=> D_Sig
);
process(clk3)
begin
if rising_edge(clk3) then
D_sig1 <= D_sig;
D <= D_sig1;
end if;
end process;

end behave;