library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

-- Entity declaration
entity Gen_CNT is
	generic ( CNT_width : integer := 17);
    Port (
        clk   : in  STD_LOGIC;            -- Clock input
        rst_n : in  STD_LOGIC;   		-- Asynchronous reset input
		Dir   : in std_logic;			-- count up or down 
        count : out STD_LOGIC_VECTOR(CNT_width-1 downto 0)  -- 24-bit output count
    );
end Gen_CNT;

-- Architecture definition
architecture Behavioral of Gen_CNT is
    signal cnt_reg : STD_LOGIC_VECTOR(CNT_width-1 downto 0) := (others => '0');  -- 24-bit register to hold count
begin
    process(clk, rst_n)
    begin
        if rst_n = '0' then
            cnt_reg <= (others => '0');  -- Reset the counter to 0
        elsif rising_edge(clk) then
			if Dir='1' then 
				cnt_reg <= cnt_reg + 1;  -- Increment the counter
			else 
				cnt_reg <= cnt_reg - 1; 
			end if;
        end if;
    end process;

    count <= cnt_reg;  -- Assign the internal count to the output
end Behavioral;