library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Entity declaration
entity seven_segment_decoder is
    Port (
        binary_in : in  STD_LOGIC_VECTOR (3 downto 0);  -- 4-bit binary input
        seg_out   : out STD_LOGIC_VECTOR (6 downto 0)   -- 7-segment display output
    );
end seven_segment_decoder;

-- Architecture definition
architecture Behavioral of seven_segment_decoder is
begin

process (binary_in)
begin 
	case binary_in is 
			when "0001" =>   seg_out <=  "1001111" ;
			when "0010" =>   seg_out <=  "0010010" ;
			when "0011" =>   seg_out <=  "0000110" ;
			when "0100" =>   seg_out <=  "1001100" ;
			when "0101" =>   seg_out <=  "0100100" ;
			when "0110" =>   seg_out <=  "0100000" ;
			when "0111" =>   seg_out <=  "0001111" ;
			when "1000" =>   seg_out <=  "0000000" ;
			when "1001" =>   seg_out <=  "0000100" ;
			when "1010" =>   seg_out <=  "0001000" ;
			when "1011" =>   seg_out <=  "1100000" ;
			when "1100" =>   seg_out <=  "0110001" ;
			when "1101" =>   seg_out <=  "1000010" ;
			when "1110" =>   seg_out <=  "0110000" ;
			when "1111" =>   seg_out <=  "0111000" ;
			when others => seg_out <= "1111111";
	end case;
end process;

end Behavioral;