--
-- Synopsys
-- Vhdl wrapper for top level design, written on Wed Aug 21 09:33:46 2024
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity wrapper_for_counter_fsm is
   port (
      clk : in std_logic;
      rst_n : in std_logic;
      Data1 : in std_logic_vector(6 downto 0);
      Data2 : in std_logic_vector(6 downto 0);
      Data3 : in std_logic_vector(6 downto 0);
      Data_out : out std_logic_vector(6 downto 0);
      Disp_en : out std_logic_vector(2 downto 0)
   );
end wrapper_for_counter_fsm;

architecture behavioral of wrapper_for_counter_fsm is

component counter_fsm
 port (
   clk : in std_logic;
   rst_n : in std_logic;
   Data1 : in std_logic_vector (6 downto 0);
   Data2 : in std_logic_vector (6 downto 0);
   Data3 : in std_logic_vector (6 downto 0);
   Data_out : out std_logic_vector (6 downto 0);
   Disp_en : out std_logic_vector (2 downto 0)
 );
end component;

signal tmp_clk : std_logic;
signal tmp_rst_n : std_logic;
signal tmp_Data1 : std_logic_vector (6 downto 0);
signal tmp_Data2 : std_logic_vector (6 downto 0);
signal tmp_Data3 : std_logic_vector (6 downto 0);
signal tmp_Data_out : std_logic_vector (6 downto 0);
signal tmp_Disp_en : std_logic_vector (2 downto 0);

begin

tmp_clk <= clk;

tmp_rst_n <= rst_n;

tmp_Data1 <= Data1;

tmp_Data2 <= Data2;

tmp_Data3 <= Data3;

Data_out <= tmp_Data_out;

Disp_en <= tmp_Disp_en;



u1:   counter_fsm port map (
		clk => tmp_clk,
		rst_n => tmp_rst_n,
		Data1 => tmp_Data1,
		Data2 => tmp_Data2,
		Data3 => tmp_Data3,
		Data_out => tmp_Data_out,
		Disp_en => tmp_Disp_en
       );
end behavioral;
