library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

Package MyPackage is

-- Constant and signal declaration 
constant CNT_width: integer := 18; 
constant Letter_U: std_logic_vector (6 downto 0):="0111110";
constant Letter_P: std_logic_vector (6 downto 0):="1100111";
constant Letter_D: std_logic_vector (6 downto 0):="0111101";
constant Letter_N: std_logic_vector (6 downto 0):="0010101";

-- Component declaration 

component counter_fsm is
    Port (
        clk      : in  STD_LOGIC;
        rst_n    : in  STD_LOGIC;
        Data1, Data2, Data3  : in  STD_LOGIC_VECTOR(6 downto 0);
		Data_out : out  STD_LOGIC_VECTOR(6 downto 0);
        Disp_en    : out STD_LOGIC_VECTOR(2 downto 0) 
    );
end component;

Component Gen_CNT is
    Port (
        clk   : in  STD_LOGIC;            -- Clock input
        rst_n : in  STD_LOGIC;            -- Asynchronous reset input
		Dir   : in std_logic;
        count : out STD_LOGIC_VECTOR(CNT_width-1 downto 0)  -- CNT_width-bit output count
    );
end component;

Component seven_segment_decoder is
    Port (
        binary_in : in  STD_LOGIC_VECTOR (3 downto 0);  -- 4-bit binary input
        seg_out   : out STD_LOGIC_VECTOR (6 downto 0)   -- 7-segment display output
    );
end component; 

-- function declaration 
function decoder7Seg (input : std_logic_vector(3 downto 0)) return std_logic_vector;

end MyPackage; 


Package body mypackage is 

function decoder7Seg (input : std_logic_vector(3 downto 0)) return std_logic_vector is
    variable segments : std_logic_vector(6 downto 0); -- 7-segment output
begin
    case input is
        when "0000" => segments := "0000001"; -- 0
        when "0001" => segments := "1001111"; -- 1
        when "0010" => segments := "0010010"; -- 2
        when "0011" => segments := "0000110"; -- 3
        when "0100" => segments := "1001100"; -- 4
        when "0101" => segments := "0100100"; -- 5
        when "0110" => segments := "0100000"; -- 6
        when "0111" => segments := "0001111"; -- 7
        when "1000" => segments := "0000000"; -- 8
        when "1001" => segments := "0000100"; -- 9
        when "1010" => segments := "0001000"; -- A
        when "1011" => segments := "1100000"; -- B
        when "1100" => segments := "0110001"; -- C
        when "1101" => segments := "1000010"; -- D
        when "1110" => segments := "0110000"; -- E
        when "1111" => segments := "0111000"; -- F
        when others => segments := "1111111"; -- Default (all off)
    end case;
    return segments;
end decoder7Seg;

End MyPackage;
