library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Entity declaration
entity seven_segment_decoder is
    Port (
        binary_in : in  STD_LOGIC_VECTOR (3 downto 0);  -- 4-bit binary input
        seg_out   : out STD_LOGIC_VECTOR (6 downto 0)   -- 7-segment display output
    );
end seven_segment_decoder;

-- Architecture definition
architecture Behavioral of seven_segment_decoder is
begin

seg_out <= 	"1111110" when binary_in= "0000" else  
			"0110000" when binary_in= "0001" else    
			"1101101" when binary_in= "0010" else    
			"1111001" when binary_in= "0011" else    
			"0110011" when binary_in= "0100" else    
			"1011011" when binary_in= "0101" else    
			"1011111" when binary_in= "0110" else    
			"1110000" when binary_in= "0111" else    
			"1111111" when binary_in= "1000" else    
			"1111011" when binary_in= "1001" else    
			"1110111" when binary_in= "1010" else    
			"0011111" when binary_in= "1011" else    
			"1001110" when binary_in= "1100" else    
			"0111101" when binary_in= "1101" else    
			"1001111" when binary_in= "1110" else    
			"1000111" when binary_in= "1111" else    
			"1111111";                               

end Behavioral;