--
-- Synopsys
-- Vhdl wrapper for top level design, written on Wed Aug 21 08:30:00 2024
--
library ieee;
use ieee.std_logic_1164.all;

entity wrapper_for_seven_segment_decoder is
   port (
      binary_in : in std_logic_vector(3 downto 0);
      seg_out : out std_logic_vector(6 downto 0)
   );
end wrapper_for_seven_segment_decoder;

architecture behavioral of wrapper_for_seven_segment_decoder is

component seven_segment_decoder
 port (
   binary_in : in std_logic_vector (3 downto 0);
   seg_out : out std_logic_vector (6 downto 0)
 );
end component;

signal tmp_binary_in : std_logic_vector (3 downto 0);
signal tmp_seg_out : std_logic_vector (6 downto 0);

begin

tmp_binary_in <= binary_in;

seg_out <= tmp_seg_out;



u1:   seven_segment_decoder port map (
		binary_in => tmp_binary_in,
		seg_out => tmp_seg_out
       );
end behavioral;
