--
-- Synopsys
-- Vhdl wrapper for top level design, written on Mon Aug 26 15:06:05 2024
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library work;
use work.mypackage.all;

entity wrapper_for_top_level is
   port (
      rst_n : in std_logic;
      Dir : in std_logic;
      seg_out : out std_logic_vector(6 downto 0);
      Digit_en : out std_logic_vector(2 downto 0)
   );
end wrapper_for_top_level;

architecture behavioral of wrapper_for_top_level is

component top_level
 port (
   rst_n : in std_logic;
   Dir : in std_logic;
   seg_out : out std_logic_vector (6 downto 0);
   Digit_en : out std_logic_vector (2 downto 0)
 );
end component;

signal tmp_rst_n : std_logic;
signal tmp_Dir : std_logic;
signal tmp_seg_out : std_logic_vector (6 downto 0);
signal tmp_Digit_en : std_logic_vector (2 downto 0);

begin

tmp_rst_n <= rst_n;

tmp_Dir <= Dir;

seg_out <= tmp_seg_out;

Digit_en <= tmp_Digit_en;



u1:   top_level port map (
		rst_n => tmp_rst_n,
		Dir => tmp_Dir,
		seg_out => tmp_seg_out,
		Digit_en => tmp_Digit_en
       );
end behavioral;
