
-- VHDL Test Bench Created from source file seven_segment_decoder.vhd -- Wed Aug 21 08:33:39 2024

--
-- Notes: 
-- 1) This testbench template has been automatically generated using types
-- std_logic and std_logic_vector for the ports of the unit under test.
-- Lattice recommends that these types always be used for the top-level
-- I/O of a design in order to guarantee that the testbench will bind
-- correctly to the timing (post-route) simulation model.
-- 2) To use this template as your testbench, change the filename to any
-- name of your choice with the extension .vhd, and use the "source->import"
-- menu in the ispLEVER Project Navigator to import the testbench.
-- Then edit the user defined section below, adding code to generate the 
-- stimulus for your design.
-- 3) VHDL simulations will produce errors if there are Lattice FPGA library 
-- elements in your design that require the instantiation of GSR, PUR, and
-- TSALL and they are not present in the testbench. For more information see
-- the How To section of online help.  
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

ENTITY testbench IS
END testbench;

ARCHITECTURE behavior OF testbench IS 

	COMPONENT seven_segment_decoder
	PORT(
		binary_in : IN std_logic_vector(3 downto 0);          
		seg_out : OUT std_logic_vector(6 downto 0)
		);
	END COMPONENT;

	COMPONENT GSR
	PORT(
		GSR_N : IN std_logic
		);
	END COMPONENT;

	SIGNAL binary_in :  std_logic_vector(3 downto 0) := "0000" ;
	SIGNAL seg_out :  std_logic_vector(6 downto 0);

BEGIN

	GSR_INST : GSR 
		PORT map ( GSR_N => '1' );

-- Please check and add your generic clause manually
	uut: seven_segment_decoder PORT MAP(
		binary_in => binary_in,
		seg_out => seg_out
	);


-- *** Test Bench - User Defined Section ***
PROCESS
   BEGIN
	  wait for 20 ns ;
	  binary_in <= "0001";
      wait for 10ns; -- will wait forever
	  binary_in <= "0010";
      wait for 10ns; -- will wait forever
	  binary_in <= "0011";
      wait; -- will wait forever
   END PROCESS;
-- *** End Test Bench - User Defined Section ***

END;
