library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use work.MyPackage.all;

entity top_level is
    Port (
        rst_n, Dir   : in  STD_LOGIC;             -- Asynchronous reset input
        seg_out : out STD_LOGIC_VECTOR(6 downto 0);  -- 7-segment display output
        Digit_en : out STD_LOGIC_VECTOR(2 downto 0)  -- Digit select for multiple displays
    );
end top_level;

architecture Behavioral of top_level is
-- All omponent declaration are in the package MyPackage.vhd
Component OSCA
	generic (
		HF_CLK_DIV : string ;
		HF_SED_SEC_DIV : string ;
		HF_OSC_EN : string ;
		LF_OUTPUT_EN : string );
port (
		HFOUTEN : in std_logic;
		HFSDSCEN : in std_logic;
		HFCLKOUT : out std_logic;
		LFCLKOUT : out std_logic;
		HFCLKCFG : out std_logic;
		HFSDCOUT : out std_logic);
end component;		
-- they are made visible by using : use work.MyPackage.all;
signal clk2: std_logic; 
signal count : STD_LOGIC_VECTOR(CNT_width-1 downto 0);
signal digit : STD_LOGIC_VECTOR(3 downto 0);
signal sig_out1, sig_out2, sig_out3 : STD_LOGIC_VECTOR(6 downto 0);
signal seq_sig : STD_LOGIC_VECTOR(1 downto 0);

Begin

Sig_out3 <= Letter_U when Dir='1' else Letter_D;
Sig_out2 <= Letter_P when Dir='1' else Letter_N;

MyOSC: OSCA
generic map ( 	HF_CLK_DIV => "1", 			--(DIV = 2)
				HF_SED_SEC_DIV => "1", 		--(DIV = 2)
				HF_OSC_EN => "DISABLED",
				LF_OUTPUT_EN => "ENABLED")
port map (
				HFOUTEN => '0',
				HFSDSCEN => '0',
				HFCLKOUT => open,
				LFCLKOUT => clk2,
				HFCLKCFG => open,
				HFSDCOUT => open
		);

myFSM: counter_fsm
    Port map(
        clk      => clk2 ,
        rst_n    => rst_n ,
        Data1  => sig_out1 ,
		Data2  => sig_out2 ,
		Data3  => sig_out3 ,
		data_out => seg_out,
        Disp_en   => Digit_en 
    );

counter_inst : Gen_CNT
    Port map (
        clk   => clk2,
        rst_n => rst_n,
		Dir   => Dir,		
        count => count
    );

digit <= count(CNT_width-1 downto CNT_width-4);  -- Display the most significant 4 bits for example
---------------------------------------
-- We could use function to do the 7 Segment decoding 
-- Function is declared in the package MyPackage

--Process (clk2)
--begin
	--if rising_edge (clk2) then 
		--sig_out1 <= not (decoder7Seg (digit));
	--end if; 
--end process;
-------------------------------------
-- component could also be used. 
-- Refer to the subprogram decoder_7Seg.vhd
-- in the case of using the component you need to import the 
-- subprogram to the Radiant project.

 decoder_inst1 : seven_segment_decoder
    Port map (
        binary_in => digit,
		seg_out => sig_out1
    );
----------------------------------------

end Behavioral;