--
-- Synopsys
-- Vhdl wrapper for top level design, written on Wed Aug 21 09:23:27 2024
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity wrapper_for_Gen_CNT is
   port (
      clk : in std_logic;
      reset : in std_logic;
      Dir : in std_logic;
      count : out std_logic_vector(16 downto 0)
   );
end wrapper_for_Gen_CNT;

architecture behavioral of wrapper_for_Gen_CNT is

component Gen_CNT
 port (
   clk : in std_logic;
   reset : in std_logic;
   Dir : in std_logic;
   count : out std_logic_vector (16 downto 0)
 );
end component;

signal tmp_clk : std_logic;
signal tmp_reset : std_logic;
signal tmp_Dir : std_logic;
signal tmp_count : std_logic_vector (16 downto 0);

begin

tmp_clk <= clk;

tmp_reset <= reset;

tmp_Dir <= Dir;

count <= tmp_count;



u1:   Gen_CNT port map (
		clk => tmp_clk,
		reset => tmp_reset,
		Dir => tmp_Dir,
		count => tmp_count
       );
end behavioral;
