library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use work.Mysettings.all;

entity DPRAM1 is
--generic (addr_width, data_width );
port (
  wr_addr_i, rd_addr_i : in  std_logic_vector (Addr_width - 1 downto 0);
  wr_en_i, rd_en_i : in  std_logic; 
  wr_clk_i, rd_clk_i : in  std_logic; 
  wr_clk_en_i, rd_clk_en_i : in  std_logic; 
  rst_i : in std_logic;
  wr_data_i : in  std_logic_vector ((Data_width - 1) downto 0);
  rd_data_o : out  std_logic_vector ((Data_width - 1) downto 0)
  );
end DPRAM1;
 
architecture rtl of DPRAM1 is
 
signal mem : mem_type;
attribute syn_ramstyle : string;
attribute syn_ramstyle of mem : signal is "block_ram";
--attribute syn_ramstyle of mem : signal is "distributed";

begin

-----   Write Port A Memory -----------

  process (wr_clk_i, wr_clk_en_i)
  begin
    if rst_i ='1' then 
		mem <= (Others => "000000000000000000"); 
	elsif wr_clk_en_i ='1' then 
		if (wr_clk_i'event and wr_clk_i = '1') then --Control with clock edge
			if (wr_en_i = '1') then -- Control with a write enable.
				mem(conv_integer(wr_addr_i)) <= wr_data_i;
			end if;  
		end if;
	end if;
  end process;
  
-----   Read Port B Memory -----------

  process (rd_clk_i, rd_clk_en_i,rst_i)
  begin
  	if rst_i ='1' then 
		rd_data_o <= (Others => '1'); 
	elsif rd_clk_en_i ='1' then 
		if (rd_clk_i'event and rd_clk_i = '1') then --Control with clock edge
			if (rd_en_i = '1') then -- Control with a write enable.
				rd_data_o <= mem(conv_integer(rd_addr_i));
			end if;  
		end if;
	end if;
  end process;
end rtl;
