library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity presubmult is
generic (
AWIDTH : natural := 12; -- Width of A input
BWIDTH : natural := 16; -- Width of B input
CWIDTH : natural := 16 -- Width of C input
);
port (
clk, rst : in std_logic; -- Clock
ain : in std_logic_vector(AWIDTH-1 downto 0); -- A input
bin : in std_logic_vector(BWIDTH-1 downto 0); -- B input
cin : in std_logic_vector(CWIDTH-1 downto 0); -- C input
pout : out std_logic_vector(BWIDTH+CWIDTH downto 0) -- Output
);
--attribute syn_multstyle : string ;
--attribute syn_multstyle of presubmult : entity is "logic" ;

end presubmult;
architecture rtl of presubmult is
signal a, ai : signed(AWIDTH-1 downto 0);
signal b, bi: signed(BWIDTH-1 downto 0);
signal c, ci : signed(CWIDTH-1 downto 0);
signal add, addi : signed(BWIDTH downto 0);
signal mult, p, multi, pi : signed(BWIDTH+CWIDTH downto 0);
Component GSR  
		Port ( GSR_N : in std_logic;
			CLK : in std_logic);
	end component;

begin

--GSR_INST: GSR  port map (rst, clk);

process(clk,rst)
begin
	if rst ='1' then 
			mult <= (others =>'0');
	elsif rising_edge(clk) then
		a <= signed(ain);
		b <= signed(bin);
		c <= signed(cin);
		mult <= (resize(a, BWIDTH+1) + resize(b, BWIDTH+1))* c;
	end if;
--end if;
end process;
pout <= std_logic_vector(mult);
end rtl;