library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity CNT is
generic ( CNT_WIDTH : natural := 10);-- Width of counter 
port (
clk, rst,enable : in std_logic;
Cout : out std_logic_vector((CNT_WIDTH-1) downto 0)
);
end CNT;
architecture rtl of CNT is
signal Couti : std_logic_vector((CNT_WIDTH-1) downto 0);

begin

process(clk)
begin
if rising_edge(clk) then
	if rst = '0' then 
		Couti <= (Others =>'0');
	else 
		if enable ='1' then
			Couti <= Couti + 1;
		else 
			Couti <= Couti;
		end if;
	end if ;
end if; 
end process;

Cout <= Couti;

end rtl;