--
-- Synopsys
-- Vhdl wrapper for top level design, written on Wed Nov 29 09:20:18 2023
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_signed.all;
library work;
use work.mysettings.all;

entity wrapper_for_Top is
   port (
      RST_N : in std_logic;
      LED1 : out std_logic;
      LED2 : out std_logic;
      LED3 : out std_logic;
      LED4 : out std_logic;
      TCK : in std_logic;
      TMS : in std_logic;
      TDI : in std_logic;
      TDO : out std_logic
   );
end wrapper_for_Top;

architecture behave of wrapper_for_Top is

component Top
 port (
   RST_N : in std_logic;
   LED1 : out std_logic;
   LED2 : out std_logic;
   LED3 : out std_logic;
   LED4 : out std_logic;
   TCK : in std_logic;
   TMS : in std_logic;
   TDI : in std_logic;
   TDO : out std_logic
 );
end component;

signal tmp_RST_N : std_logic;
signal tmp_LED1 : std_logic;
signal tmp_LED2 : std_logic;
signal tmp_LED3 : std_logic;
signal tmp_LED4 : std_logic;
signal tmp_TCK : std_logic;
signal tmp_TMS : std_logic;
signal tmp_TDI : std_logic;
signal tmp_TDO : std_logic;

begin

tmp_RST_N <= RST_N;

LED1 <= tmp_LED1;

LED2 <= tmp_LED2;

LED3 <= tmp_LED3;

LED4 <= tmp_LED4;

tmp_TCK <= TCK;

tmp_TMS <= TMS;

tmp_TDI <= TDI;

TDO <= tmp_TDO;



u1:   Top port map (
		RST_N => tmp_RST_N,
		LED1 => tmp_LED1,
		LED2 => tmp_LED2,
		LED3 => tmp_LED3,
		LED4 => tmp_LED4,
		TCK => tmp_TCK,
		TMS => tmp_TMS,
		TDI => tmp_TDI,
		TDO => tmp_TDO
       );
end behave;
