library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;


entity CE_Sync is
port (
clki, RST_N : in std_logic;
clko : out std_logic 
);
end CE_Sync;
architecture rtl of CE_Sync is
signal CE, CE1 : std_logic;

COMPONENT DCC 
generic (DCCEN:String);
PORT ( 	CLKI :IN STD_LOGIC; 
		CE :IN STD_LOGIC; 
		CLKO :OUT STD_LOGIC); 
END COMPONENT;

begin

DCC01 : DCC
generic map ( DCCEN  => "1") 
port map (
  CE   => CE,  -- I
  CLKI => CLKi,  -- I
  CLKO => CLKo   -- O
);

process(clki, RST_N)
begin
if RST_N = '0' then 
		CE <= '0';
		CE1 <= '0';
elsif rising_edge(clki) then
		CE1 <= '1';
		CE <= CE1;
end if;
end process;
end rtl;