--
-- Synopsys
-- Vhdl wrapper for top level design, written on Fri Dec  1 10:21:43 2023
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_signed.all;
library work;
use work.mysettings.all;

entity wrapper_for_Top is
   port (
      reset : in std_logic;
      G_reset : in std_logic;
      CLK1 : in std_logic;
      clk2 : in std_logic;
      LED1 : out std_logic;
      LED2 : out std_logic
   );
end wrapper_for_Top;

architecture behave of wrapper_for_Top is

component Top
 port (
   reset : in std_logic;
   G_reset : in std_logic;
   CLK1 : in std_logic;
   clk2 : in std_logic;
   LED1 : out std_logic;
   LED2 : out std_logic
 );
end component;

signal tmp_reset : std_logic;
signal tmp_G_reset : std_logic;
signal tmp_CLK1 : std_logic;
signal tmp_clk2 : std_logic;
signal tmp_LED1 : std_logic;
signal tmp_LED2 : std_logic;

begin

tmp_reset <= reset;

tmp_G_reset <= G_reset;

tmp_CLK1 <= CLK1;

tmp_clk2 <= clk2;

LED1 <= tmp_LED1;

LED2 <= tmp_LED2;



u1:   Top port map (
		reset => tmp_reset,
		G_reset => tmp_G_reset,
		CLK1 => tmp_CLK1,
		clk2 => tmp_clk2,
		LED1 => tmp_LED1,
		LED2 => tmp_LED2
       );
end behave;
