--
-- Synopsys
-- Vhdl wrapper for top level design, written on Mon Nov 20 09:09:36 2023
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
library work;
use work.mysettings.all;

entity wrapper_for_DPRAM1 is
   port (
      wr_addr_i : in std_logic_vector(9 downto 0);
      rd_addr_i : in std_logic_vector(9 downto 0);
      wr_en_i : in std_logic;
      rd_en_i : in std_logic;
      wr_clk_i : in std_logic;
      rd_clk_i : in std_logic;
      wr_clk_en_i : in std_logic;
      rd_clk_en_i : in std_logic;
      rst_i : in std_logic;
      wr_data_i : in std_logic_vector(17 downto 0);
      rd_data_o : out std_logic_vector(17 downto 0)
   );
end wrapper_for_DPRAM1;

architecture rtl of wrapper_for_DPRAM1 is

component DPRAM1
 port (
   wr_addr_i : in std_logic_vector (9 downto 0);
   rd_addr_i : in std_logic_vector (9 downto 0);
   wr_en_i : in std_logic;
   rd_en_i : in std_logic;
   wr_clk_i : in std_logic;
   rd_clk_i : in std_logic;
   wr_clk_en_i : in std_logic;
   rd_clk_en_i : in std_logic;
   rst_i : in std_logic;
   wr_data_i : in std_logic_vector (17 downto 0);
   rd_data_o : out std_logic_vector (17 downto 0)
 );
end component;

signal tmp_wr_addr_i : std_logic_vector (9 downto 0);
signal tmp_rd_addr_i : std_logic_vector (9 downto 0);
signal tmp_wr_en_i : std_logic;
signal tmp_rd_en_i : std_logic;
signal tmp_wr_clk_i : std_logic;
signal tmp_rd_clk_i : std_logic;
signal tmp_wr_clk_en_i : std_logic;
signal tmp_rd_clk_en_i : std_logic;
signal tmp_rst_i : std_logic;
signal tmp_wr_data_i : std_logic_vector (17 downto 0);
signal tmp_rd_data_o : std_logic_vector (17 downto 0);

begin

tmp_wr_addr_i <= wr_addr_i;

tmp_rd_addr_i <= rd_addr_i;

tmp_wr_en_i <= wr_en_i;

tmp_rd_en_i <= rd_en_i;

tmp_wr_clk_i <= wr_clk_i;

tmp_rd_clk_i <= rd_clk_i;

tmp_wr_clk_en_i <= wr_clk_en_i;

tmp_rd_clk_en_i <= rd_clk_en_i;

tmp_rst_i <= rst_i;

tmp_wr_data_i <= wr_data_i;

rd_data_o <= tmp_rd_data_o;



u1:   DPRAM1 port map (
		wr_addr_i => tmp_wr_addr_i,
		rd_addr_i => tmp_rd_addr_i,
		wr_en_i => tmp_wr_en_i,
		rd_en_i => tmp_rd_en_i,
		wr_clk_i => tmp_wr_clk_i,
		rd_clk_i => tmp_rd_clk_i,
		wr_clk_en_i => tmp_wr_clk_en_i,
		rd_clk_en_i => tmp_rd_clk_en_i,
		rst_i => tmp_rst_i,
		wr_data_i => tmp_wr_data_i,
		rd_data_o => tmp_rd_data_o
       );
end rtl;
