`timescale 100 ps/100 ps
(* black_box_pad_pin="TDI,TCK,TMS,TDO" *)module JTAGH19 (
  TCK,
  TMS,
  TDI,
  TDO,
  JTDI,
  JTCK,
  JSHIFT,
  JUPDATE,
  JRSTN,
  JCE2,
  CDN,
  IP_ENABLE,
  ER2_TDO
)
;
input TCK ;
input TMS ;
input TDI ;
output TDO ;
output JTDI ;
output JTCK ;
output JSHIFT ;
output JUPDATE ;
output JRSTN ;
output JCE2 ;
output CDN ;
output [18:0] IP_ENABLE ;
input [18:0] ER2_TDO ;
endmodule /* JTAGH19 */

module CCU2 (
  A0,
  B0,
  C0,
  D0,
  A1,
  B1,
  C1,
  D1,
  CIN,
  COUT,
  S0,
  S1
)
;
input A0 ;
input B0 ;
input C0 ;
input D0 ;
input A1 ;
input B1 ;
input C1 ;
input D1 ;
input CIN ;
output COUT ;
output S0 ;
output S1 ;
parameter INIT0="0x0000";
parameter INIT1="0x0000";
parameter INJECT="NO";
endmodule /* CCU2 */

module OSCA (
  HFOUTEN,
  HFSDSCEN,
  HFCLKOUT,
  LFCLKOUT,
  HFCLKCFG,
  HFSDCOUT
)
;
input HFOUTEN ;
input HFSDSCEN ;
output HFCLKOUT ;
output LFCLKOUT ;
output HFCLKCFG ;
output HFSDCOUT ;
endmodule /* OSCA */

module DCC (
  CLKI,
  CE,
  CLKO
)
;
input CLKI ;
input CE ;
output CLKO ;
endmodule /* DCC */

