 library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_SIGNED.all;
use work.Mysettings.all;


entity Top is 	  
    port ( 
        reset, en : in std_logic;
        LED1,LED2, LED3, LED4 :out std_logic
       );
end Top;

architecture behave of Top is 

Component OSCA 
generic ( 
		HF_CLK_DIV : string; 
		HF_SED_SEC_DIV : string; 
		HF_OSC_EN : string; 
		LF_OUTPUT_EN : string );
port ( 	HFOUTEN : in std_logic; 
		HFSDSCEN : in std_logic; 
		HFCLKOUT : out std_logic; 
		LFCLKOUT : out std_logic; 
		HFCLKCFG : out std_logic; 
		HFSDCOUT : out std_logic );
end component;
Component Reset_Sync
port (
clk, A_Rst : in std_logic;
Rst_Sync : out std_logic );
end component;

Component GSR  
		Port ( GSR_N : in std_logic;
			CLK : in std_logic);
end component;
----------- CNT component --------------
Component CNT is
generic ( CNT_WIDTH : natural);  
port (
clk, rst, enable : in std_logic;
Cout : out std_logic_vector((CNT_WIDTH-1) downto 0)
);
end component;

------------ Signal declaration ----------------
signal CNT1 : std_logic_vector(Width1-1 downto 0);
signal CNT2 : std_logic_vector(Width2-1 downto 0);
signal CNT3 : std_logic_vector(Width3-1 downto 0);
signal CNT4 : std_logic_vector(Width4-1 downto 0);

signal rsti,rstni : std_logic;
signal clk112,clk150 : std_logic;

begin 
-------------------------------------------------
--    Sync Hybrid Reset Generation			----
-------------------------------------------------
RST001: Reset_Sync 
port map(
	clk => clk150, 
	A_Rst => reset,
	Rst_Sync => rsti );
-------------------------------------------------


OSCA001: OSCA 
generic map ( 
		HF_CLK_DIV => "3", 
		HF_SED_SEC_DIV => "1", 
		HF_OSC_EN => "ENABLED", 
		LF_OUTPUT_EN => "ENABLED" ) 
	port map ( 	HFOUTEN => '1', 
				HFSDSCEN => '1', 
				HFCLKOUT => clk150,
				LFCLKOUT => open, 
				HFCLKCFG => open, 
				HFSDCOUT => open );


CNT01: CNT 
generic map( CNT_WIDTH => Width1)  -- Width of counter 
port map(
    clk => clk150,
    rst => rsti,
	enable => en,
    cout => CNT1
);

CNT02: CNT 
generic map( CNT_WIDTH => Width2)  -- Width of counter 
port map(
    clk => clk150,
    rst => rsti,
	enable => en,
    cout => CNT2
);

CNT03: CNT 
generic map( CNT_WIDTH => Width3)  -- Width of counter 
port map(
    clk => clk150,
    rst => rsti,
	enable => en,
    cout => CNT3
);

CNT04: CNT 
generic map( CNT_WIDTH => Width4)  -- Width of counter 
port map(
    clk => clk150,
    rst => rsti,
	enable => en,
    cout => CNT4
);
----------- signal sync -------

process (clk150)
begin
	if rising_edge(clk150) then
		LED1 <= CNT1(0) xor CNT1 (Width1-1);
	end if;
end process;

process (clk150)
begin
	if rising_edge(clk150) then
		LED2 <= CNT2(0) xor CNT2 (Width2-1);
	end if;
end process;

process (clk150)
begin
	if rising_edge(clk150) then
		LED3 <= CNT3(0) xor CNT3 (Width3-1);
	end if;
end process;

process (clk150)
begin
	if rising_edge(clk150) then
		if CNT4 /= CNT3 or CNT4 /= CNT2 or CNT4 /= CNT1 then 
			LED4 <= '1';
		else 
			LED4 <= '0'; 
		end if; 
	end if;
end process;

end architecture behave;