 library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_SIGNED.all;
use work.Mysettings.all;


entity Top is 	  
    port ( 
        RST_N : in std_logic;
        LED1,LED2, LED3, LED4 :out std_logic
       );
end Top;

architecture behave of Top is 
Component OSCA 
generic ( 
		HF_CLK_DIV : string; 
		HF_SED_SEC_DIV : string; 
		HF_OSC_EN : string; 
		LF_OUTPUT_EN : string );
port ( 	HFOUTEN : in std_logic; 
		HFSDSCEN : in std_logic; 
		HFCLKOUT : out std_logic; 
		LFCLKOUT : out std_logic; 
		HFCLKCFG : out std_logic; 
		HFSDCOUT : out std_logic );
end component;

Component CE_Sync
port (
clki,RST_N: in std_logic;
clko : out std_logic 
);
end component;

----------- CNT component --------------
Component CNT is
generic ( CNT_WIDTH : natural);  
port (
clk, rst: in std_logic;
Cout : out std_logic_vector((CNT_WIDTH-1) downto 0)
);
end component;

Component GSR  
		Port ( GSR_N : in std_logic;
			CLK : in std_logic);
end component;

------------ Signal declaration ----------------
signal CNT1 : std_logic_vector(Width1-1 downto 0);
signal CNT2 : std_logic_vector(Width2-1 downto 0);
signal CNT3 : std_logic_vector(Width1-1 downto 0);
signal CNT4 : std_logic_vector(Width2-1 downto 0);
signal CLK1, CLK, rsti : std_logic;

attribute syn_preserve : boolean;
attribute syn_preserve of behave: architecture is true;

attribute syn_keep: boolean;
attribute syn_keep of CNT1, CNT2, CNT3, CNT4: signal is true;


begin 
-------------------------------------------------
--        	     Reset Generation			----
-------------------------------------------------
-- using GSR Component 
--GSR_INST : GSR  port map (GSR_N, open);
rsti <= RST_N;
-------------------------------------------------
CE001: CE_Sync
port map(
	clki => CLK,
	RST_N => RST_N,
	clko => CLK1 
);
--CLK1 <= CLK;
-------------------------------------------------
OSCA001: OSCA 
generic map ( 
		HF_CLK_DIV => "2", 
		HF_SED_SEC_DIV => "1", 
		HF_OSC_EN => "ENABLED", 
		LF_OUTPUT_EN => "ENABLED" ) 
	port map ( 	HFOUTEN => '1', 
				HFSDSCEN => '1', 
				HFCLKOUT => CLK,
				LFCLKOUT => open, 
				HFCLKCFG => open, 
				HFSDCOUT => open );
--************************************************-
CNT01: CNT 
generic map( CNT_WIDTH => Width1)  -- Width of counter 
port map( clk => CLK1, rst => rsti, cout => CNT1);

CNT02: CNT 
generic map( CNT_WIDTH => Width2)  -- Width of counter 
port map(clk => CLK1, rst => rsti, cout => CNT2);

CNT03: CNT 
generic map( CNT_WIDTH => Width3)  -- Width of counter 
port map(clk => CLK1, rst => rsti, cout => CNT3);

CNT04: CNT 
generic map( CNT_WIDTH => Width4)  -- Width of counter 
port map( clk => CLK1, rst => rsti, cout => CNT4);
--***************************************************
------------------- signal sync ---------------------
process (CLK1)
begin
	if rising_edge(CLK1) then
		LED1 <= CNT1(0) xor CNT1 (Width1-1);
	end if;
end process;

process (CLK1)
begin
	if rising_edge(CLK1) then
		LED2 <= CNT2(0) xor CNT2 (Width2-5);
	end if;
end process;

process (CLK1)
begin
	if rising_edge(CLK1) then
		LED3 <= CNT3(0) xor CNT3 (Width3-3);
	end if;
end process;

process (CLK1)
begin
	if rising_edge(CLK1) then
		LED4 <= CNT4(0)  xor CNT4 (Width4-2);
	end if;
end process;

end architecture behave;