library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


entity counter_fsm is
    Port (
        clk      : in  STD_LOGIC;
        rst_n    : in  STD_LOGIC;
--		refresh    : in  STD_LOGIC;
        Data1, Data2, Data3  : in  STD_LOGIC_VECTOR(6 downto 0);
		Data_out : out  STD_LOGIC_VECTOR(6 downto 0);
        Disp_en    : out STD_LOGIC_VECTOR(2 downto 0)  
    );
end counter_fsm;

architecture Behavioral of counter_fsm is

type state_type is (IDLE, DISP1, DISP2, DISP3);
signal state : state_type;

begin

process(clk, rst_n)
begin
if rst_n = '0' then
     state <= IDLE;
	 Data_out <= "0000000";
	 Disp_en <= "000";
elsif rising_edge(clk) then
--	if refresh='1' then 
        case state is
            when IDLE =>
                state <= DISP1;
				Data_out <= Data1;
				Disp_en <= "100";
            when DISP1 =>
                state <= DISP2;
				Data_out <= Data2;
				Disp_en <= "010";				
            when DISP2 =>
                state <= DISP3;
				Data_out <= Data3;
				Disp_en <= "001";					
			when DISP3 =>
                state <= DISP1;
				Data_out <= data1;
				Disp_en <= "100";					
            when others =>
                state <= IDLE;
				Data_out <= "0000000";
				Disp_en <= "000";
        end case;
--	end if; 
end if;
end process;

end Behavioral;